/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.lombok;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import lombok.Builder;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.core.LombokImmutableList;
import lombok.core.LombokNode;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.HandleBuilder;
import lombok.javac.handlers.HandleConstructor;

@HandlerPriority(value=-1024)
public class BuilderHandler
extends JavacAnnotationHandler<Builder> {
    public void handle(AnnotationValues<Builder> annotationValues, JCTree.JCAnnotation jcAnnotation, JavacNode javacNode) {
        JavacNode parent = (JavacNode)javacNode.up();
        if (!(parent.get() instanceof JCTree.JCClassDecl)) {
            new HandleBuilder().handle(annotationValues, jcAnnotation, javacNode);
            return;
        }
        HashMap<JCTree.JCModifiers, FlagAndAnnotations> modifiersRestoreMap = new HashMap<JCTree.JCModifiers, FlagAndAnnotations>();
        HashMap<JavacNode, LombokImmutableList> nodeToChildrenMap = new HashMap<JavacNode, LombokImmutableList>();
        Field childrenField = null;
        try {
            childrenField = LombokNode.class.getDeclaredField("children");
            childrenField.setAccessible(true);
            for (JavacNode javacNode2 : HandleConstructor.findAllFields((JavacNode)parent, (boolean)true)) {
                LombokImmutableList children = (LombokImmutableList)childrenField.get(javacNode2);
                nodeToChildrenMap.put(javacNode2, children);
                LombokImmutableList filtered = children;
                for (int i : this.findBuilderDefaultIndexes((LombokImmutableList<JavacNode>)children)) {
                    filtered = filtered.removeElementAt(i);
                }
                childrenField.set(javacNode2, filtered);
                JCTree.JCVariableDecl fd = (JCTree.JCVariableDecl)javacNode2.get();
                JCTree.JCModifiers modifiers = fd.getModifiers();
                modifiersRestoreMap.put(modifiers, new FlagAndAnnotations(modifiers.flags, modifiers.annotations));
                modifiers.annotations = this.removeBuilderDefault(modifiers.annotations);
                modifiers.flags &= 0xFFFFFFFFFFFFFFEFL;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        new HandleBuilder().handle(annotationValues, jcAnnotation, javacNode);
        for (Map.Entry entry : modifiersRestoreMap.entrySet()) {
            ((JCTree.JCModifiers)entry.getKey()).flags = ((FlagAndAnnotations)entry.getValue()).flags;
            ((JCTree.JCModifiers)entry.getKey()).annotations = ((FlagAndAnnotations)entry.getValue()).annotations;
        }
        for (Map.Entry entry : nodeToChildrenMap.entrySet()) {
            try {
                childrenField.set(entry.getKey(), entry.getValue());
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private List<JCTree.JCAnnotation> removeBuilderDefault(List<JCTree.JCAnnotation> annotations) {
        ListBuffer<JCTree.JCAnnotation> filteredAnnotations = new ListBuffer<JCTree.JCAnnotation>();
        for (JCTree.JCAnnotation annotation : annotations) {
            if (annotation.getAnnotationType().toString().equals("lombok.Builder.Default")) continue;
            filteredAnnotations = filteredAnnotations.append(annotation);
        }
        return filteredAnnotations.toList();
    }

    private List<Integer> findBuilderDefaultIndexes(LombokImmutableList<JavacNode> nodes) {
        ListBuffer<Integer> indexes = new ListBuffer<Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            JavacNode node = (JavacNode)nodes.get(i);
            if (node.getKind() != AST.Kind.ANNOTATION || !"lombok.Builder.Default".equals(((JCTree)node.get()).type.toString())) continue;
            indexes.add(i);
        }
        return indexes.toList();
    }

    private static class FlagAndAnnotations {
        long flags;
        List<JCTree.JCAnnotation> annotations;

        FlagAndAnnotations(long flags, List<JCTree.JCAnnotation> annotations) {
            this.flags = flags;
            this.annotations = annotations;
        }
    }
}

