/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java8ModifierResults;
import org.openrewrite.java.JavaParsingException;
import org.openrewrite.java.ReloadableJava8JavadocVisitor;
import org.openrewrite.java.ReloadableJava8TypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class ReloadableJava8ParserVisitor
extends TreePathScanner<J, Space> {
    private static final int SURR_FIRST = 55296;
    private static final int SURR_LAST = 57343;
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final Collection<NamedStyles> styles;
    private final ExecutionContext ctx;
    private final Context context;
    private final ReloadableJava8TypeMapping typeMapping;
    private EndPosTable endPosTable;
    private DocCommentTable docCommentTable;
    private int cursor = 0;
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");
    private final Function<com.sun.source.tree.Tree, Space> semiDelim = ignored -> this.sourceBefore(";");
    private final Function<com.sun.source.tree.Tree, Space> commaDelim = ignored -> this.sourceBefore(",");
    private final Function<com.sun.source.tree.Tree, Space> noDelim = ignored -> Space.EMPTY;

    public ReloadableJava8ParserVisitor(Path sourcePath, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source, Collection<NamedStyles> styles, JavaTypeCache typeCache, ExecutionContext ctx, Context context) {
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
        this.styles = styles;
        this.ctx = ctx;
        this.context = context;
        this.typeMapping = new ReloadableJava8TypeMapping(typeCache);
    }

    @Override
    public J visitAnnotation(AnnotationTree node, Space fmt) {
        this.skip("@");
        NameTree name = (NameTree)this.convert(node.getAnnotationType());
        JContainer args = null;
        if (node.getArguments().size() > 0) {
            ExpressionTree arg;
            Space argsPrefix = this.sourceBefore("(");
            List expressions = node.getArguments().size() == 1 ? ((arg = node.getArguments().get(0)) instanceof JCTree.JCAssign ? (this.endPos(arg) < 0 ? Collections.singletonList(this.convert(((JCTree.JCAssign)arg).rhs, t -> this.sourceBefore(")"))) : Collections.singletonList(this.convert(arg, t -> this.sourceBefore(")")))) : Collections.singletonList(this.convert(arg, t -> this.sourceBefore(")")))) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")"));
            args = JContainer.build((Space)argsPrefix, expressions, (Markers)Markers.EMPTY);
        } else {
            String remaining = this.source.substring(this.cursor, this.endPos(node));
            if (remaining.contains("(") && remaining.contains(")")) {
                args = JContainer.build((Space)this.sourceBefore("("), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            }
        }
        return new J.Annotation(Tree.randomId(), fmt, Markers.EMPTY, name, args);
    }

    @Override
    public J visitArrayAccess(ArrayAccessTree node, Space fmt) {
        return new J.ArrayAccess(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getExpression()), new J.ArrayDimension(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, this.convert(node.getIndex(), t -> this.sourceBefore("]"))), this.typeMapping.type(node));
    }

    @Override
    public J visitArrayType(ArrayTypeTree node, Space fmt) {
        com.sun.source.tree.Tree typeIdent = node.getType();
        int dimCount = 1;
        while (typeIdent instanceof ArrayTypeTree) {
            ++dimCount;
            typeIdent = ((ArrayTypeTree)typeIdent).getType();
        }
        TypeTree elemType = (TypeTree)this.convert(typeIdent);
        List dimensions = Collections.emptyList();
        if (dimCount > 0) {
            dimensions = new ArrayList(dimCount);
            for (int n = 0; n < dimCount; ++n) {
                dimensions.add(this.padRight(this.sourceBefore("["), this.sourceBefore("]")));
            }
        }
        return new J.ArrayType(Tree.randomId(), fmt, Markers.EMPTY, elemType, dimensions);
    }

    @Override
    public J visitAssert(AssertTree node, Space fmt) {
        this.skip("assert");
        JCTree.JCAssert jcAssert = (JCTree.JCAssert)node;
        return new J.Assert(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(jcAssert.cond), jcAssert.detail == null ? null : this.padLeft(this.sourceBefore(":"), this.convert(jcAssert.detail)));
    }

    @Override
    public J visitAssignment(AssignmentTree node, Space fmt) {
        return new J.Assignment(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getVariable()), this.padLeft(this.sourceBefore("="), this.convert(node.getExpression())), this.typeMapping.type(node));
    }

    @Override
    public J visitBinary(BinaryTree node, Space fmt) {
        J.Binary.Type op;
        Expression left = (Expression)this.convert(node.getLeftOperand());
        Space opPrefix = this.whitespace();
        switch (((JCTree.JCBinary)node).getTag()) {
            case PLUS: {
                this.skip("+");
                op = J.Binary.Type.Addition;
                break;
            }
            case MINUS: {
                this.skip("-");
                op = J.Binary.Type.Subtraction;
                break;
            }
            case DIV: {
                this.skip("/");
                op = J.Binary.Type.Division;
                break;
            }
            case MUL: {
                this.skip("*");
                op = J.Binary.Type.Multiplication;
                break;
            }
            case MOD: {
                this.skip("%");
                op = J.Binary.Type.Modulo;
                break;
            }
            case AND: {
                this.skip("&&");
                op = J.Binary.Type.And;
                break;
            }
            case OR: {
                this.skip("||");
                op = J.Binary.Type.Or;
                break;
            }
            case BITAND: {
                this.skip("&");
                op = J.Binary.Type.BitAnd;
                break;
            }
            case BITOR: {
                this.skip("|");
                op = J.Binary.Type.BitOr;
                break;
            }
            case BITXOR: {
                this.skip("^");
                op = J.Binary.Type.BitXor;
                break;
            }
            case SL: {
                this.skip("<<");
                op = J.Binary.Type.LeftShift;
                break;
            }
            case SR: {
                this.skip(">>");
                op = J.Binary.Type.RightShift;
                break;
            }
            case USR: {
                this.skip(">>>");
                op = J.Binary.Type.UnsignedRightShift;
                break;
            }
            case LT: {
                this.skip("<");
                op = J.Binary.Type.LessThan;
                break;
            }
            case GT: {
                this.skip(">");
                op = J.Binary.Type.GreaterThan;
                break;
            }
            case LE: {
                this.skip("<=");
                op = J.Binary.Type.LessThanOrEqual;
                break;
            }
            case GE: {
                this.skip(">=");
                op = J.Binary.Type.GreaterThanOrEqual;
                break;
            }
            case EQ: {
                this.skip("==");
                op = J.Binary.Type.Equal;
                break;
            }
            case NE: {
                this.skip("!=");
                op = J.Binary.Type.NotEqual;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binary tag " + (Object)((Object)((JCTree.JCBinary)node).getTag()));
            }
        }
        return new J.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, this.padLeft(opPrefix, op), (Expression)this.convert(node.getRightOperand()), this.typeMapping.type(node));
    }

    @Override
    public J visitBlock(BlockTree node, Space fmt) {
        JRightPadded stat;
        if ((((JCTree.JCBlock)node).flags & 8L) != 0L) {
            this.skip("static");
            stat = new JRightPadded((Object)true, this.sourceBefore("{"), Markers.EMPTY);
        } else {
            this.skip("{");
            stat = new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY);
        }
        ArrayList<StatementTree> statementTrees = new ArrayList<StatementTree>();
        for (StatementTree statementTree : node.getStatements()) {
            if (this.endPos(statementTree) <= 0) continue;
            statementTrees.add(statementTree);
        }
        return new J.Block(Tree.randomId(), fmt, Markers.EMPTY, stat, this.convertStatements(statementTrees), this.sourceBefore("}"));
    }

    @Override
    public J visitBreak(BreakTree node, Space fmt) {
        this.skip("break");
        J.Identifier label = node.getLabel() == null ? null : new J.Identifier(Tree.randomId(), this.sourceBefore(node.getLabel().toString()), Markers.EMPTY, this.skip(node.getLabel().toString()), null, null);
        return new J.Break(Tree.randomId(), fmt, Markers.EMPTY, label);
    }

    @Override
    public J visitCase(CaseTree node, Space fmt) {
        Expression pattern;
        if (node.getExpression() == null) {
            pattern = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.skip("default"), null, null);
        } else {
            this.skip("case");
            pattern = (Expression)this.convertOrNull(node.getExpression());
        }
        return new J.Case(Tree.randomId(), fmt, Markers.EMPTY, pattern, JContainer.build((Space)this.sourceBefore(":"), this.convertStatements(node.getStatements()), (Markers)Markers.EMPTY));
    }

    @Override
    public J visitCatch(CatchTree node, Space fmt) {
        this.skip("catch");
        Space paramPrefix = this.sourceBefore("(");
        J.VariableDeclarations paramDecl = (J.VariableDeclarations)this.convert(node.getParameter());
        J.ControlParentheses param = new J.ControlParentheses(Tree.randomId(), paramPrefix, Markers.EMPTY, this.padRight(paramDecl, this.sourceBefore(")")));
        return new J.Try.Catch(Tree.randomId(), fmt, Markers.EMPTY, param, (J.Block)this.convert(node.getBlock()));
    }

    @Override
    public J visitClass(ClassTree node, Space fmt) {
        HashMap<Integer, JCTree.JCAnnotation> annotationPosTable = new HashMap<Integer, JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : node.getModifiers().getAnnotations()) {
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
            annotationPosTable.put(annotation.pos, annotation);
        }
        Java8ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        List<J.Annotation> list = this.collectAnnotations(annotationPosTable);
        J.ClassDeclaration.Kind kind = this.hasFlag(node.getModifiers(), 16384L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("enum"), Markers.EMPTY, list, J.ClassDeclaration.Kind.Type.Enum) : (this.hasFlag(node.getModifiers(), 8192L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("@interface"), Markers.EMPTY, list, J.ClassDeclaration.Kind.Type.Annotation) : (this.hasFlag(node.getModifiers(), 512L) ? new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("interface"), Markers.EMPTY, list, J.ClassDeclaration.Kind.Type.Interface) : new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("class"), Markers.EMPTY, list, J.ClassDeclaration.Kind.Type.Class)));
        J.Identifier name = new J.Identifier(Tree.randomId(), this.sourceBefore(node.getSimpleName().toString()), Markers.EMPTY, ((JCTree.JCClassDecl)node).getSimpleName().toString(), this.typeMapping.type(node), null);
        JContainer typeParams = node.getTypeParameters().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("<"), this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")), (Markers)Markers.EMPTY);
        JLeftPadded extendings = node.getExtendsClause() == null ? null : this.padLeft(this.sourceBefore("extends"), this.convertOrNull(node.getExtendsClause()));
        JContainer implementings = null;
        if (node.getImplementsClause() != null && !node.getImplementsClause().isEmpty()) {
            Space implementsPrefix = this.sourceBefore(kind.getType() == J.ClassDeclaration.Kind.Type.Interface ? "extends" : "implements");
            implementings = JContainer.build((Space)implementsPrefix, this.convertAll(node.getImplementsClause(), this.commaDelim, this.noDelim), (Markers)Markers.EMPTY);
        }
        Space bodyPrefix = this.sourceBefore("{");
        ArrayList<com.sun.source.tree.Tree> jcEnums = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (!(tree instanceof JCTree.JCVariableDecl) || !this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            jcEnums.add(tree);
        }
        JRightPadded<J.EnumValueSet> enumSet = null;
        if (!jcEnums.isEmpty()) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            List enumValues = this.convertAll(jcEnums, this.commaDelim, t -> {
                semicolonPresent.set(this.positionOfNext(";", Character.valueOf('}')) > 0);
                return semicolonPresent.get() ? this.sourceBefore(";", Character.valueOf('}')) : Space.EMPTY;
            });
            enumSet = this.padRight(new J.EnumValueSet(Tree.randomId(), ((J.EnumValue)((JRightPadded)enumValues.get(0)).getElement()).getPrefix(), Markers.EMPTY, ListUtils.map((List)enumValues, (i, ev) -> i == 0 ? ev.withElement((Object)((J.EnumValue)ev.getElement()).withPrefix(Space.EMPTY)) : ev), atomicBoolean.get()), Space.EMPTY);
        }
        ArrayList<com.sun.source.tree.Tree> arrayList = new ArrayList<com.sun.source.tree.Tree>();
        for (com.sun.source.tree.Tree tree : node.getMembers()) {
            if (tree instanceof JCTree.JCMethodDecl && this.hasFlag(((JCTree.JCMethodDecl)tree).getModifiers(), 0x1000000000L) || tree instanceof JCTree.JCVariableDecl && this.hasFlag(((JCTree.JCVariableDecl)tree).getModifiers(), 16384L)) continue;
            arrayList.add(tree);
        }
        ArrayList<Object> members = new ArrayList<Object>();
        if (enumSet != null) {
            members.add(enumSet);
        }
        members.addAll(this.convertStatements(arrayList));
        J.Block block = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), members, this.sourceBefore("}"));
        return new J.ClassDeclaration(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), kind, name, typeParams, extendings, implementings, block, (JavaType.FullyQualified)this.typeMapping.type(node));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public J visitCompilationUnit(CompilationUnitTree node, Space fmt) {
        void var6_9;
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)node;
        if (node.getTypeDecls().isEmpty() || cu.getPackageName() != null || !node.getImports().isEmpty()) {
            fmt = Space.format((String)this.source.substring(0, cu.getStartPosition()));
            this.cursor(cu.getStartPosition());
        }
        this.endPosTable = cu.endPositions;
        this.docCommentTable = cu.docComments;
        HashMap<Integer, JCTree.JCAnnotation> annotationPosTable = new HashMap<Integer, JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : node.getPackageAnnotations()) {
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
            annotationPosTable.put(annotation.pos, annotation);
        }
        List<J.Annotation> packageAnnotations = this.collectAnnotations(annotationPosTable);
        Object var6_7 = null;
        if (cu.getPackageName() != null) {
            Space packagePrefix = this.sourceBefore("package");
            J.Package package_ = new J.Package(Tree.randomId(), packagePrefix, Markers.EMPTY, (Expression)this.convert(cu.getPackageName()), packageAnnotations);
        }
        return new J.CompilationUnit(Tree.randomId(), fmt, Markers.build(this.styles), this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, var6_9 == null ? null : this.padRight(var6_9, this.sourceBefore(";")), this.convertAll(node.getImports(), this::statementDelim, this::statementDelim), this.convertAll(node.getTypeDecls().stream().filter(JCTree.JCClassDecl.class::isInstance).collect(Collectors.toList())), Space.format((String)this.source.substring(this.cursor)));
    }

    @Override
    public J visitCompoundAssignment(CompoundAssignmentTree node, Space fmt) {
        J.AssignmentOperation.Type op;
        Expression left = (Expression)this.convert(((JCTree.JCAssignOp)node).lhs);
        Space opPrefix = this.whitespace();
        switch (((JCTree.JCAssignOp)node).getTag()) {
            case PLUS_ASG: {
                this.skip("+=");
                op = J.AssignmentOperation.Type.Addition;
                break;
            }
            case MINUS_ASG: {
                this.skip("-=");
                op = J.AssignmentOperation.Type.Subtraction;
                break;
            }
            case DIV_ASG: {
                this.skip("/=");
                op = J.AssignmentOperation.Type.Division;
                break;
            }
            case MUL_ASG: {
                this.skip("*=");
                op = J.AssignmentOperation.Type.Multiplication;
                break;
            }
            case MOD_ASG: {
                this.skip("%=");
                op = J.AssignmentOperation.Type.Modulo;
                break;
            }
            case BITAND_ASG: {
                this.skip("&=");
                op = J.AssignmentOperation.Type.BitAnd;
                break;
            }
            case BITOR_ASG: {
                this.skip("|=");
                op = J.AssignmentOperation.Type.BitOr;
                break;
            }
            case BITXOR_ASG: {
                this.skip("^=");
                op = J.AssignmentOperation.Type.BitXor;
                break;
            }
            case SL_ASG: {
                this.skip("<<=");
                op = J.AssignmentOperation.Type.LeftShift;
                break;
            }
            case SR_ASG: {
                this.skip(">>=");
                op = J.AssignmentOperation.Type.RightShift;
                break;
            }
            case USR_ASG: {
                this.skip(">>>=");
                op = J.AssignmentOperation.Type.UnsignedRightShift;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected compound assignment tag " + (Object)((Object)((JCTree.JCAssignOp)node).getTag()));
            }
        }
        return new J.AssignmentOperation(Tree.randomId(), fmt, Markers.EMPTY, left, this.padLeft(opPrefix, op), (Expression)this.convert(((JCTree.JCAssignOp)node).rhs), this.typeMapping.type(node));
    }

    @Override
    public J visitConditionalExpression(ConditionalExpressionTree node, Space fmt) {
        return new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getCondition()), this.padLeft(this.sourceBefore("?"), this.convert(node.getTrueExpression())), this.padLeft(this.sourceBefore(":"), this.convert(node.getFalseExpression())), this.typeMapping.type(node));
    }

    @Override
    public J visitContinue(ContinueTree node, Space fmt) {
        this.skip("continue");
        Name label = node.getLabel();
        return new J.Continue(Tree.randomId(), fmt, Markers.EMPTY, label == null ? null : new J.Identifier(Tree.randomId(), this.sourceBefore(label.toString()), Markers.EMPTY, label.toString(), null, null));
    }

    @Override
    public J visitDoWhileLoop(DoWhileLoopTree node, Space fmt) {
        this.skip("do");
        return new J.DoWhileLoop(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getStatement(), this::statementDelim), this.padLeft(this.sourceBefore("while"), this.convert(node.getCondition())));
    }

    @Override
    public J visitEmptyStatement(EmptyStatementTree node, Space fmt) {
        return new J.Empty(Tree.randomId(), fmt, Markers.EMPTY);
    }

    @Override
    public J visitEnhancedForLoop(EnhancedForLoopTree node, Space fmt) {
        this.skip("for");
        return new J.ForEachLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForEachLoop.Control(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, this.convert(node.getVariable(), t -> this.sourceBefore(":")), this.convert(node.getExpression(), t -> this.sourceBefore(")"))), this.convert(node.getStatement(), this::statementDelim));
    }

    private J visitEnumVariable(VariableTree node, Space fmt) {
        List<Object> annotations = Collections.emptyList();
        Space nameSpace = Space.EMPTY;
        if (!node.getModifiers().getAnnotations().isEmpty()) {
            annotations = this.convertAll(node.getModifiers().getAnnotations());
            nameSpace = this.sourceBefore(node.getName().toString());
        } else {
            this.skip(node.getName().toString());
        }
        J.Identifier name = new J.Identifier(Tree.randomId(), nameSpace, Markers.EMPTY, node.getName().toString(), this.typeMapping.type(node), null);
        J.NewClass initializer = null;
        if (this.source.charAt(this.endPos(node) - 1) == ')' || this.source.charAt(this.endPos(node) - 1) == '}') {
            initializer = (J.NewClass)this.convert(node.getInitializer());
        }
        return new J.EnumValue(Tree.randomId(), fmt, Markers.EMPTY, annotations, name, initializer);
    }

    @Override
    public J visitForLoop(ForLoopTree node, Space fmt) {
        List<Object> update;
        this.skip("for");
        Space ctrlPrefix = this.sourceBefore("(");
        List<JRightPadded<Statement>> init = node.getInitializer().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY), Space.EMPTY)) : this.convertStatements(node.getInitializer(), t -> this.positionOfNext(",", Character.valueOf(';')) == -1 ? this.semiDelim.apply((com.sun.source.tree.Tree)t) : this.commaDelim.apply((com.sun.source.tree.Tree)t));
        Object condition = this.convertOrNull(node.getCondition(), this.semiDelim);
        if (condition == null) {
            condition = this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(";"), Markers.EMPTY), Space.EMPTY);
        }
        if (node.getUpdate().isEmpty()) {
            update = Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY));
        } else {
            List<? extends ExpressionStatementTree> nodeUpdate = node.getUpdate();
            update = new ArrayList(nodeUpdate.size());
            for (int i = 0; i < nodeUpdate.size(); ++i) {
                ExpressionStatementTree tree = nodeUpdate.get(i);
                update.add(this.convert(tree, i == nodeUpdate.size() - 1 ? t -> this.sourceBefore(")") : this.commaDelim));
            }
        }
        return new J.ForLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForLoop.Control(Tree.randomId(), ctrlPrefix, Markers.EMPTY, init, condition, update), this.convert(node.getStatement(), this::statementDelim));
    }

    @Override
    public J visitIdentifier(IdentifierTree node, Space fmt) {
        String name = node.getName().toString();
        this.cursor += name.length();
        JCTree.JCIdent ident = (JCTree.JCIdent)node;
        JavaType type = this.typeMapping.type(node);
        return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, name, type, this.typeMapping.variableType(ident.sym));
    }

    @Override
    public J visitIf(IfTree node, Space fmt) {
        this.skip("if");
        return new J.If(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getCondition()), this.convert(node.getThenStatement(), this::statementDelim), node.getElseStatement() instanceof JCTree.JCStatement ? new J.If.Else(Tree.randomId(), this.sourceBefore("else"), Markers.EMPTY, this.convert(node.getElseStatement(), this::statementDelim)) : null);
    }

    @Override
    public J visitImport(ImportTree node, Space fmt) {
        this.skip("import");
        return new J.Import(Tree.randomId(), fmt, Markers.EMPTY, new JLeftPadded(node.isStatic() ? this.sourceBefore("static") : Space.EMPTY, (Object)node.isStatic(), Markers.EMPTY), (J.FieldAccess)this.convert(node.getQualifiedIdentifier()));
    }

    @Override
    public J visitInstanceOf(InstanceOfTree node, Space fmt) {
        return new J.InstanceOf(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getExpression(), t -> this.sourceBefore("instanceof")), this.convert(node.getType()), null, this.typeMapping.type(node));
    }

    @Override
    public J visitLabeledStatement(LabeledStatementTree node, Space fmt) {
        this.skip(node.getLabel().toString());
        return new J.Label(Tree.randomId(), fmt, Markers.EMPTY, this.padRight(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, node.getLabel().toString(), null, null), this.sourceBefore(":")), (Statement)this.convert(node.getStatement()));
    }

    @Override
    public J visitLambdaExpression(LambdaExpressionTree node, Space fmt) {
        Object body;
        boolean parenthesized = this.source.charAt(this.cursor) == '(';
        this.skip("(");
        List<Object> paramList = parenthesized && node.getParameters().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getParameters(), this.commaDelim, t -> parenthesized ? this.sourceBefore(")") : Space.EMPTY);
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, parenthesized, paramList);
        Space arrow = this.sourceBefore("->");
        if (node.getBody() instanceof JCTree.JCBlock) {
            Space prefix = this.sourceBefore("{");
            --this.cursor;
            body = this.convert(node.getBody());
            body = body.withPrefix(prefix);
        } else {
            body = this.convert(node.getBody());
        }
        return new J.Lambda(Tree.randomId(), fmt, Markers.EMPTY, params, arrow, body, this.typeMapping.type(node));
    }

    @Override
    public J visitLiteral(LiteralTree node, Space fmt) {
        this.cursor(this.endPos(node));
        Object value = node.getValue();
        String valueSource = this.source.substring(((JCTree.JCLiteral)node).getStartPosition(), this.endPos(node));
        JavaType.Primitive type = this.typeMapping.primitive(((JCTree.JCLiteral)node).typetag);
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c >= '\ud800' && c <= '\udfff') {
                return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, null, "''", Collections.singletonList(new J.Literal.UnicodeEscape(1, valueSource.substring(3, valueSource.length() - 1))), type);
            }
        } else if (JavaType.Primitive.String.equals((Object)type)) {
            StringBuilder valueSourceWithoutSurrogates = new StringBuilder();
            ArrayList<J.Literal.UnicodeEscape> unicodeEscapes = null;
            int i = 0;
            char[] valueSourceArr = valueSource.toCharArray();
            for (int j = 0; j < valueSourceArr.length; ++j) {
                String codePoint;
                int codePointNumeric;
                char c = valueSourceArr[j];
                if (c == '\\' && j < valueSourceArr.length - 1 && (j == 0 || valueSourceArr[j - 1] != '\\') && valueSourceArr[j + 1] == 'u' && j < valueSource.length() - 5 && (codePointNumeric = Integer.parseInt(codePoint = valueSource.substring(j + 2, j + 6), 16)) >= 55296 && codePointNumeric <= 57343) {
                    if (unicodeEscapes == null) {
                        unicodeEscapes = new ArrayList<J.Literal.UnicodeEscape>();
                    }
                    unicodeEscapes.add(new J.Literal.UnicodeEscape(i, codePoint));
                    j += 5;
                    continue;
                }
                valueSourceWithoutSurrogates.append(c);
                ++i;
            }
            return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, unicodeEscapes == null ? value : valueSourceWithoutSurrogates.toString(), valueSourceWithoutSurrogates.toString(), unicodeEscapes, type);
        }
        return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, value, valueSource, null, type);
    }

    @Override
    public J visitMemberReference(MemberReferenceTree node, Space fmt) {
        String referenceName;
        JCTree.JCMemberReference ref = (JCTree.JCMemberReference)node;
        switch (ref.getMode()) {
            case NEW: {
                referenceName = "new";
                break;
            }
            default: {
                referenceName = node.getName().toString();
            }
        }
        JavaType.Method methodReferenceType = null;
        if (ref.sym instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)ref.sym;
            methodReferenceType = this.typeMapping.methodInvocationType(methodSymbol.type, methodSymbol);
        }
        JavaType.Variable fieldReferenceType = null;
        if (ref.sym instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)ref.sym;
            fieldReferenceType = this.typeMapping.variableType(varSymbol);
        }
        return new J.MemberReference(Tree.randomId(), fmt, Markers.EMPTY, this.padRight(this.convert(ref.expr), this.sourceBefore("::")), this.convertTypeParameters(node.getTypeArguments()), this.padLeft(this.whitespace(), new J.Identifier(Tree.randomId(), this.sourceBefore(referenceName), Markers.EMPTY, referenceName, null, null)), this.typeMapping.type(node), methodReferenceType, fieldReferenceType);
    }

    @Override
    public J visitMemberSelect(MemberSelectTree node, Space fmt) {
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
        JavaType type = this.typeMapping.type(node);
        return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(fieldAccess.selected), this.padLeft(this.sourceBefore("."), new J.Identifier(Tree.randomId(), this.sourceBefore(fieldAccess.name.toString()), Markers.EMPTY, fieldAccess.name.toString(), type, this.typeMapping.variableType(fieldAccess.sym))), type);
    }

    @Override
    public J visitMethodInvocation(MethodInvocationTree node, Space fmt) {
        J.Identifier name;
        JCTree.JCExpression jcSelect = ((JCTree.JCMethodInvocation)node).getMethodSelect();
        JRightPadded select = null;
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            select = this.convert(((JCTree.JCFieldAccess)jcSelect).selected, t -> this.sourceBefore("."));
        } else if (!(jcSelect instanceof JCTree.JCIdent)) {
            throw new IllegalStateException("Unexpected method select type " + jcSelect.getClass().getSimpleName());
        }
        JContainer typeParams = null;
        if (!node.getTypeArguments().isEmpty()) {
            typeParams = JContainer.build((Space)this.sourceBefore("<"), this.convertAll(node.getTypeArguments(), this.commaDelim, t -> this.sourceBefore(">")), (Markers)Markers.EMPTY);
        }
        if (jcSelect instanceof JCTree.JCFieldAccess) {
            String selectName = ((JCTree.JCFieldAccess)jcSelect).name.toString();
            name = new J.Identifier(Tree.randomId(), this.sourceBefore(selectName), Markers.EMPTY, selectName, null, null);
        } else {
            name = (J.Identifier)this.convert(jcSelect);
        }
        JContainer args = JContainer.build((Space)this.sourceBefore("("), node.getArguments().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY);
        Symbol genericSymbol = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).sym : ((JCTree.JCIdent)jcSelect).sym;
        return new J.MethodInvocation(Tree.randomId(), fmt, Markers.EMPTY, select, typeParams, name, args, this.typeMapping.methodInvocationType(jcSelect.type, genericSymbol));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public J visitMethod(MethodTree node, Space fmt) {
        void var6_9;
        J.MethodDeclaration.IdentifierWithAnnotations name;
        JCTree.JCMethodDecl jcMethod = (JCTree.JCMethodDecl)node;
        HashMap<Integer, JCTree.JCAnnotation> annotationPosTable = new HashMap<Integer, JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : node.getModifiers().getAnnotations()) {
            JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
            annotationPosTable.put(annotation.pos, annotation);
        }
        Java8ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        if (node.getTypeParameters().isEmpty()) {
            Object var6_7 = null;
        } else {
            List<J.Annotation> typeParamsAnnotations = this.collectAnnotations(annotationPosTable);
            J.TypeParameters typeParameters = new J.TypeParameters(Tree.randomId(), this.sourceBefore("<"), Markers.EMPTY, typeParamsAnnotations, this.convertAll(node.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">")));
        }
        List<J.Annotation> returnTypeAnnotations = this.collectAnnotations(annotationPosTable);
        TypeTree returnType = (TypeTree)this.convertOrNull(node.getReturnType());
        if (returnType != null && !returnTypeAnnotations.isEmpty()) {
            returnType = new J.AnnotatedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, returnTypeAnnotations, returnType);
        }
        Symbol.MethodSymbol nodeSym = jcMethod.sym;
        if ("<init>".equals(node.getName().toString())) {
            String owner = null;
            if (nodeSym == null) {
                for (com.sun.source.tree.Tree tree : this.getCurrentPath()) {
                    if (!(tree instanceof JCTree.JCClassDecl)) continue;
                    owner = ((JCTree.JCClassDecl)tree).getSimpleName().toString();
                    break;
                }
                if (owner == null) {
                    throw new IllegalStateException("Should have been able to locate an owner");
                }
            } else {
                owner = jcMethod.sym.owner.name.toString();
            }
            name = new J.MethodDeclaration.IdentifierWithAnnotations(new J.Identifier(Tree.randomId(), this.sourceBefore(owner), Markers.EMPTY, owner, null, null), returnType == null ? returnTypeAnnotations : Collections.emptyList());
        } else {
            name = new J.MethodDeclaration.IdentifierWithAnnotations(new J.Identifier(Tree.randomId(), this.sourceBefore(node.getName().toString()), Markers.EMPTY, node.getName().toString(), null, null), returnType == null ? returnTypeAnnotations : Collections.emptyList());
        }
        Space paramFmt = this.sourceBefore("(");
        JContainer params = !node.getParameters().isEmpty() ? JContainer.build((Space)paramFmt, this.convertAll(node.getParameters(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY) : JContainer.build((Space)paramFmt, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        JContainer throwss = node.getThrows().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("throws"), this.convertAll(node.getThrows(), this.commaDelim, this.noDelim), (Markers)Markers.EMPTY);
        J.Block body = (J.Block)this.convertOrNull(node.getBody());
        JLeftPadded defaultValue = node.getDefaultValue() == null ? null : this.padLeft(this.sourceBefore("default"), this.convert(node.getDefaultValue()));
        return new J.MethodDeclaration(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), (J.TypeParameters)var6_9, returnType, name, params, throwss, body, defaultValue, this.typeMapping.methodDeclarationType(jcMethod.sym, null));
    }

    @Override
    public J visitNewArray(NewArrayTree node, Space fmt) {
        TypeTree typeExpr;
        this.skip("new");
        JCTree.JCExpression jcVarType = ((JCTree.JCNewArray)node).elemtype;
        if (jcVarType instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)jcVarType).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convertOrNull(elementType);
        } else {
            typeExpr = (TypeTree)this.convertOrNull(jcVarType);
        }
        ArrayList<J.ArrayDimension> dimensions = new ArrayList<J.ArrayDimension>();
        List<? extends ExpressionTree> nodeDimensions = node.getDimensions();
        for (ExpressionTree expressionTree : nodeDimensions) {
            dimensions.add(new J.ArrayDimension(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, this.convert(expressionTree, t -> this.sourceBefore("]"))));
        }
        Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
        while (matcher.find(this.cursor)) {
            this.cursor(matcher.end());
            dimensions.add(new J.ArrayDimension(Tree.randomId(), Space.format((String)matcher.group(1)), Markers.EMPTY, this.padRight(new J.Empty(Tree.randomId(), Space.format((String)matcher.group(2)), Markers.EMPTY), Space.EMPTY)));
        }
        JContainer jContainer = node.getInitializers() == null ? null : JContainer.build((Space)this.sourceBefore("{"), node.getInitializers().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore("}"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getInitializers(), this.commaDelim, t -> this.sourceBefore("}")), (Markers)Markers.EMPTY);
        return new J.NewArray(Tree.randomId(), fmt, Markers.EMPTY, typeExpr, dimensions, jContainer, this.typeMapping.type(node));
    }

    @Override
    public J visitNewClass(NewClassTree node, Space fmt) {
        TypeTree clazz;
        JRightPadded encl = node.getEnclosingExpression() == null ? null : this.convert(node.getEnclosingExpression(), t -> this.sourceBefore("."));
        Space whitespaceBeforeNew = Space.EMPTY;
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        if (!(parent instanceof JCTree.JCVariableDecl) || (((JCTree.JCVariableDecl)parent).mods.flags & 0x4000L) == 0L) {
            whitespaceBeforeNew = this.sourceBefore("new");
        }
        TypeTree typeTree = clazz = this.endPos(node.getIdentifier()) >= 0 ? (TypeTree)this.convertOrNull(node.getIdentifier()) : null;
        JContainer args = this.positionOfNext("(", Character.valueOf('{')) > -1 ? JContainer.build((Space)this.sourceBefore("("), node.getArguments().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(node.getArguments(), this.commaDelim, t -> this.sourceBefore(")")), (Markers)Markers.EMPTY) : JContainer.empty().withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
        J.Block body = null;
        if (node.getClassBody() != null) {
            Space bodyPrefix = this.sourceBefore("{");
            ArrayList<com.sun.source.tree.Tree> members = new ArrayList<com.sun.source.tree.Tree>();
            for (com.sun.source.tree.Tree tree : node.getClassBody().getMembers()) {
                if (tree instanceof JCTree.JCMethodDecl && (((JCTree.JCMethodDecl)tree).getModifiers().flags & 0x1000000000L) != 0L) continue;
                members.add(tree);
            }
            body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), this.convertAll(members, this.noDelim, this.noDelim), this.sourceBefore("}"));
        }
        JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)node;
        JavaType.Method constructorType = this.typeMapping.methodInvocationType(jcNewClass.constructorType, jcNewClass.constructor);
        return new J.NewClass(Tree.randomId(), fmt, Markers.EMPTY, encl, whitespaceBeforeNew, clazz, args, body, constructorType);
    }

    @Override
    public J visitParameterizedType(ParameterizedTypeTree node, Space fmt) {
        return new J.ParameterizedType(Tree.randomId(), fmt, Markers.EMPTY, (NameTree)this.convert(node.getType()), this.convertTypeParameters(node.getTypeArguments()));
    }

    @Override
    public J visitParenthesized(ParenthesizedTree node, Space fmt) {
        this.skip("(");
        com.sun.source.tree.Tree parent = this.getCurrentPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case CATCH: 
            case DO_WHILE_LOOP: 
            case IF: 
            case SWITCH: 
            case SYNCHRONIZED: 
            case TYPE_CAST: 
            case WHILE_LOOP: {
                return new J.ControlParentheses(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getExpression(), t -> this.sourceBefore(")")));
            }
        }
        return new J.Parentheses(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node.getExpression(), t -> this.sourceBefore(")")));
    }

    @Override
    public J visitPrimitiveType(PrimitiveTypeTree node, Space fmt) {
        JavaType.Primitive primitiveType;
        this.cursor(this.endPos(node));
        switch (node.getPrimitiveTypeKind()) {
            case BOOLEAN: {
                primitiveType = JavaType.Primitive.Boolean;
                break;
            }
            case BYTE: {
                primitiveType = JavaType.Primitive.Byte;
                break;
            }
            case CHAR: {
                primitiveType = JavaType.Primitive.Char;
                break;
            }
            case DOUBLE: {
                primitiveType = JavaType.Primitive.Double;
                break;
            }
            case FLOAT: {
                primitiveType = JavaType.Primitive.Float;
                break;
            }
            case INT: {
                primitiveType = JavaType.Primitive.Int;
                break;
            }
            case LONG: {
                primitiveType = JavaType.Primitive.Long;
                break;
            }
            case SHORT: {
                primitiveType = JavaType.Primitive.Short;
                break;
            }
            case VOID: {
                primitiveType = JavaType.Primitive.Void;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type " + (Object)((Object)node.getPrimitiveTypeKind()));
            }
        }
        return new J.Primitive(Tree.randomId(), fmt, Markers.EMPTY, primitiveType);
    }

    @Override
    public J visitReturn(ReturnTree node, Space fmt) {
        this.skip("return");
        return new J.Return(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convertOrNull(node.getExpression()));
    }

    @Override
    public J visitSwitch(SwitchTree node, Space fmt) {
        this.skip("switch");
        return new J.Switch(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getExpression()), new J.Block(Tree.randomId(), this.sourceBefore("{"), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), this.convertAll(node.getCases(), this.noDelim, this.noDelim), this.sourceBefore("}")));
    }

    @Override
    public J visitSynchronized(SynchronizedTree node, Space fmt) {
        this.skip("synchronized");
        return new J.Synchronized(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getExpression()), (J.Block)this.convert(node.getBlock()));
    }

    @Override
    public J visitThrow(ThrowTree node, Space fmt) {
        this.skip("throw");
        return new J.Throw(Tree.randomId(), fmt, Markers.EMPTY, (Expression)this.convert(node.getExpression()));
    }

    @Override
    public J visitTry(TryTree node, Space fmt) {
        JContainer resources;
        this.skip("try");
        if (node.getResources().isEmpty()) {
            resources = null;
        } else {
            Space before = this.sourceBefore("(");
            ArrayList<JRightPadded<J.Try.Resource>> resourceList = new ArrayList<JRightPadded<J.Try.Resource>>();
            for (int i = 0; i < node.getResources().size(); ++i) {
                com.sun.source.tree.Tree resource = node.getResources().get(i);
                Object resourceVar = this.convert(resource);
                boolean semicolonPresent = true;
                if (i == node.getResources().size() - 1) {
                    semicolonPresent = this.positionOfNext(";", Character.valueOf(')')) > 0;
                }
                Space resourcePrefix = resourceVar.getPrefix();
                resourceVar = resourceVar.withPrefix(Space.EMPTY);
                if (semicolonPresent && resourceVar instanceof J.VariableDeclarations) {
                    J.VariableDeclarations resourceVarDecl = (J.VariableDeclarations)resourceVar;
                    resourceVar = resourceVarDecl.getPadding().withVariables(Space.formatLastSuffix((List)resourceVarDecl.getPadding().getVariables(), (Space)this.sourceBefore(";")));
                }
                J.Try.Resource tryResource = new J.Try.Resource(Tree.randomId(), resourcePrefix, Markers.EMPTY, (TypedTree)resourceVar.withPrefix(Space.EMPTY), semicolonPresent);
                resourceList.add(this.padRight(tryResource, i == node.getResources().size() - 1 ? this.sourceBefore(")") : Space.EMPTY));
            }
            resources = JContainer.build((Space)before, resourceList, (Markers)Markers.EMPTY);
        }
        J.Block block = (J.Block)this.convert(node.getBlock());
        List catches = this.convertAll(node.getCatches());
        JLeftPadded finallyy = node.getFinallyBlock() == null ? null : this.padLeft(this.sourceBefore("finally"), this.convert(node.getFinallyBlock()));
        return new J.Try(Tree.randomId(), fmt, Markers.EMPTY, resources, block, catches, finallyy);
    }

    @Override
    public J visitTypeCast(TypeCastTree node, Space fmt) {
        return new J.TypeCast(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, this.convert(node.getType(), t -> this.sourceBefore(")"))), (Expression)this.convert(node.getExpression()));
    }

    @Override
    public J visitAnnotatedType(AnnotatedTypeTree node, Space fmt) {
        return new J.AnnotatedType(Tree.randomId(), fmt, Markers.EMPTY, this.convertAll(node.getAnnotations()), (TypeTree)this.convert(node.getUnderlyingType()));
    }

    @Override
    public J visitTypeParameter(TypeParameterTree node, Space fmt) {
        List annotations = this.convertAll(node.getAnnotations());
        Expression name = (Expression)this.buildName(node.getName().toString()).withPrefix(this.sourceBefore(node.getName().toString()));
        JContainer bounds = node.getBounds().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("extends"), this.convertAll(node.getBounds(), t -> this.sourceBefore("&"), this.noDelim), (Markers)Markers.EMPTY);
        return new J.TypeParameter(Tree.randomId(), fmt, Markers.EMPTY, annotations, name, bounds);
    }

    private <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        String[] parts = fullyQualifiedName.split("\\.");
        String fullName = "";
        J.Identifier expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, part, null, null);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Space identFmt = whitespacePrefix.matches() ? Space.format((String)whitespacePrefix.group(0)) : Space.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Space namePrefix = i == parts.length - 1 ? Space.EMPTY : Space.format((String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expr, this.padLeft(namePrefix, new J.Identifier(Tree.randomId(), identFmt, Markers.EMPTY, part.trim(), null, null)), (JavaType)(Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.ShallowClass.build((String)fullName) : null));
        }
        return (T)((TypeTree)expr);
    }

    @Override
    public J visitUnionType(UnionTypeTree node, Space fmt) {
        return new J.MultiCatch(Tree.randomId(), fmt, Markers.EMPTY, this.convertAll(node.getTypeAlternatives(), t -> this.sourceBefore("|"), this.noDelim));
    }

    @Override
    public J visitUnary(UnaryTree node, Space fmt) {
        Expression expr;
        JLeftPadded<J.Unary.Type> op;
        JCTree.JCUnary unary = (JCTree.JCUnary)node;
        JCTree.Tag tag = unary.getTag();
        switch (tag) {
            case POS: {
                this.skip("+");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Positive);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NEG: {
                this.skip("-");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Negative);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREDEC: {
                this.skip("--");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.PreDecrement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case PREINC: {
                this.skip("++");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.PreIncrement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case POSTDEC: {
                expr = (Expression)this.convert(unary.arg);
                op = this.padLeft(this.sourceBefore("--"), J.Unary.Type.PostDecrement);
                break;
            }
            case POSTINC: {
                expr = (Expression)this.convert(unary.arg);
                op = this.padLeft(this.sourceBefore("++"), J.Unary.Type.PostIncrement);
                break;
            }
            case COMPL: {
                this.skip("~");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Complement);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            case NOT: {
                this.skip("!");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Not);
                expr = (Expression)this.convert(unary.arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unary tag " + (Object)((Object)tag));
            }
        }
        return new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, op, expr, this.typeMapping.type(node));
    }

    @Override
    public J visitVariable(VariableTree node, Space fmt) {
        return this.hasFlag(node.getModifiers(), 16384L) ? this.visitEnumVariable(node, fmt) : this.visitVariables(Collections.singletonList(node), fmt);
    }

    private J.VariableDeclarations visitVariables(List<VariableTree> nodes, Space fmt) {
        TypeTree typeExpr;
        JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)nodes.get(0);
        JCTree.JCExpression vartype = node.vartype;
        HashMap<Integer, JCTree.JCAnnotation> annotationPosTable = new HashMap<Integer, JCTree.JCAnnotation>();
        for (JCTree.JCAnnotation annotationNode : node.getModifiers().getAnnotations()) {
            annotationPosTable.put(annotationNode.pos, annotationNode);
        }
        Java8ModifierResults modifierResults = this.sortedModifiersAndAnnotations(node.getModifiers(), annotationPosTable);
        List<J.Annotation> typeExprAnnotations = this.collectAnnotations(annotationPosTable);
        if (vartype == null || this.endPos(vartype) < 0 || vartype instanceof JCTree.JCErroneous) {
            typeExpr = null;
        } else if (vartype instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCExpression elementType = ((JCTree.JCArrayTypeTree)vartype).elemtype;
            while (elementType instanceof JCTree.JCArrayTypeTree) {
                elementType = ((JCTree.JCArrayTypeTree)elementType).elemtype;
            }
            typeExpr = (TypeTree)this.convert(elementType);
        } else {
            typeExpr = (TypeTree)this.convert(vartype);
        }
        if (typeExpr != null && !typeExprAnnotations.isEmpty()) {
            typeExpr = new J.AnnotatedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, typeExprAnnotations, typeExpr);
        }
        Supplier<List> dimensions = () -> {
            Matcher matcher = Pattern.compile("\\G(\\s*)\\[(\\s*)]").matcher(this.source);
            ArrayList<JLeftPadded<Space>> dims = new ArrayList<JLeftPadded<Space>>();
            while (matcher.find(this.cursor)) {
                this.cursor(matcher.end());
                dims.add(this.padLeft(Space.format((String)matcher.group(1)), Space.format((String)matcher.group(2))));
            }
            return dims;
        };
        List beforeDimensions = dimensions.get();
        String vartypeString = typeExpr == null ? "" : this.source.substring(vartype.getStartPosition(), this.endPos(vartype));
        Matcher varargMatcher = Pattern.compile("(\\s*)\\.{3}").matcher(vartypeString);
        Space varargs = null;
        if (varargMatcher.find()) {
            Matcher matcher = Pattern.compile("\\G(\\s*)\\.{3}").matcher(this.source);
            if (matcher.find(this.cursor)) {
                this.cursor(matcher.end());
            }
            varargs = Space.format((String)varargMatcher.group(1));
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>();
        for (int i = 0; i < nodes.size(); ++i) {
            VariableTree n = nodes.get(i);
            Space namedVarPrefix = this.sourceBefore(n.getName().toString());
            JCTree.JCVariableDecl vd = (JCTree.JCVariableDecl)n;
            JavaType type = this.typeMapping.type(node);
            J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, n.getName().toString(), type instanceof JavaType.Variable ? ((JavaType.Variable)type).getType() : type, type instanceof JavaType.Variable ? (JavaType.Variable)type : null);
            List dimensionsAfterName = dimensions.get();
            vars.add(this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), namedVarPrefix, Markers.EMPTY, name, dimensionsAfterName, vd.init != null ? this.padLeft(this.sourceBefore("="), this.convertOrNull(vd.init)) : null, (JavaType.Variable)this.typeMapping.type(n)), i == nodes.size() - 1 ? Space.EMPTY : this.sourceBefore(",")));
        }
        return new J.VariableDeclarations(Tree.randomId(), fmt, Markers.EMPTY, modifierResults.getLeadingAnnotations(), modifierResults.getModifiers(), typeExpr, varargs, beforeDimensions, vars);
    }

    @Override
    public J visitWhileLoop(WhileLoopTree node, Space fmt) {
        this.skip("while");
        return new J.WhileLoop(Tree.randomId(), fmt, Markers.EMPTY, (J.ControlParentheses)this.convert(node.getCondition()), this.convert(node.getStatement(), this::statementDelim));
    }

    @Override
    public J visitWildcard(WildcardTree node, Space fmt) {
        JLeftPadded<J.Wildcard.Bound> bound;
        this.skip("?");
        JCTree.JCWildcard wildcard = (JCTree.JCWildcard)node;
        switch (wildcard.kind.kind) {
            case EXTENDS: {
                bound = this.padLeft(this.sourceBefore("extends"), J.Wildcard.Bound.Extends);
                break;
            }
            case SUPER: {
                bound = this.padLeft(this.sourceBefore("super"), J.Wildcard.Bound.Super);
                break;
            }
            default: {
                bound = null;
            }
        }
        return new J.Wildcard(Tree.randomId(), fmt, Markers.EMPTY, bound, (NameTree)this.convertOrNull(wildcard.inner));
    }

    private <J2 extends J> J2 convert(com.sun.source.tree.Tree t) {
        try {
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)t).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            J j = (J)this.scan(t, this.formatWithCommentTree(prefix, (JCTree)t, this.docCommentTable.getCommentTree((JCTree)t)));
            return (J2)j;
        }
        catch (Throwable ex) {
            StringBuilder message = new StringBuilder("Failed to convert for the following cursor stack:");
            message.append("--- BEGIN PATH ---\n");
            List paths = StreamSupport.stream(this.getCurrentPath().spliterator(), false).collect(Collectors.toList());
            int i = paths.size();
            while (i-- > 0) {
                JCTree tree = (JCTree)paths.get(i);
                if (tree instanceof JCTree.JCCompilationUnit) {
                    message.append("JCCompilationUnit(sourceFile = ").append(((JCTree.JCCompilationUnit)tree).sourcefile.getName()).append(")\n");
                    continue;
                }
                if (tree instanceof JCTree.JCClassDecl) {
                    message.append("JCClassDecl(name = ").append(((JCTree.JCClassDecl)tree).name).append(", line = ").append(this.lineNumber(tree)).append(")\n");
                    continue;
                }
                if (tree instanceof JCTree.JCVariableDecl) {
                    message.append("JCVariableDecl(name = ").append(((JCTree.JCVariableDecl)tree).name).append(", line = ").append(this.lineNumber(tree)).append(")\n");
                    continue;
                }
                message.append(tree.getClass().getSimpleName()).append("(line = ").append(this.lineNumber(tree)).append(")\n");
            }
            message.append("--- END PATH ---\n");
            this.ctx.getOnError().accept(new JavaParsingException(message.toString(), ex));
            throw ex;
        }
    }

    private <J2 extends J> JRightPadded<J2> convert(com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, Space> suffix) {
        J2 j = this.convert(t);
        JRightPadded rightPadded = j == null ? null : new JRightPadded(j, suffix.apply(t), Markers.EMPTY);
        this.cursor(Math.max(this.endPos(t), this.cursor));
        return rightPadded;
    }

    private long lineNumber(com.sun.source.tree.Tree tree) {
        return this.source.substring(0, ((JCTree)tree).getStartPosition()).chars().filter(c -> c == 10).count() + 1L;
    }

    @Nullable
    private <T extends J> T convertOrNull(@Nullable com.sun.source.tree.Tree t) {
        return t == null ? null : (T)this.convert(t);
    }

    @Nullable
    private <J2 extends J> JRightPadded<J2> convertOrNull(@Nullable com.sun.source.tree.Tree t, Function<com.sun.source.tree.Tree, Space> suffix) {
        return t == null ? null : this.convert(t, suffix);
    }

    private <J2 extends J> List<J2> convertAll(List<? extends com.sun.source.tree.Tree> trees) {
        ArrayList<J2> converted = new ArrayList<J2>(trees.size());
        for (com.sun.source.tree.Tree tree : trees) {
            converted.add(this.convert(tree));
        }
        return converted;
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, Space> innerSuffix, Function<com.sun.source.tree.Tree, Space> suffix) {
        if (trees.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JRightPadded<J2>> converted = new ArrayList<JRightPadded<J2>>(trees.size());
        for (int i = 0; i < trees.size(); ++i) {
            converted.add(this.convert(trees.get(i), i == trees.size() - 1 ? suffix : innerSuffix));
        }
        return converted;
    }

    @Nullable
    private JContainer<Expression> convertTypeParameters(@Nullable List<? extends com.sun.source.tree.Tree> typeArguments) {
        if (typeArguments == null) {
            return null;
        }
        Space typeArgPrefix = this.sourceBefore("<");
        List<Object> params = typeArguments.isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(">"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(typeArguments, this.commaDelim, t -> this.sourceBefore(">"));
        return JContainer.build((Space)typeArgPrefix, params, (Markers)Markers.EMPTY);
    }

    private Space statementDelim(@Nullable com.sun.source.tree.Tree t) {
        if (t instanceof JCTree.JCAssert || t instanceof JCTree.JCAssign || t instanceof JCTree.JCAssignOp || t instanceof JCTree.JCBreak || t instanceof JCTree.JCContinue || t instanceof JCTree.JCDoWhileLoop || t instanceof JCTree.JCMethodInvocation || t instanceof JCTree.JCNewClass || t instanceof JCTree.JCReturn || t instanceof JCTree.JCThrow || t instanceof JCTree.JCUnary || t instanceof JCTree.JCExpressionStatement || t instanceof JCTree.JCVariableDecl) {
            return this.sourceBefore(";");
        }
        if (t instanceof JCTree.JCLabeledStatement) {
            return this.statementDelim(((JCTree.JCLabeledStatement)t).getStatement());
        }
        if (t instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl m = (JCTree.JCMethodDecl)t;
            return this.sourceBefore(m.body == null || m.defaultValue != null ? ";" : "");
        }
        return Space.EMPTY;
    }

    private List<JRightPadded<Statement>> convertStatements(@Nullable List<? extends com.sun.source.tree.Tree> trees) {
        return this.convertStatements(trees, this::statementDelim);
    }

    private List<JRightPadded<Statement>> convertStatements(@Nullable List<? extends com.sun.source.tree.Tree> trees, Function<com.sun.source.tree.Tree, Space> suffix) {
        if (trees == null || trees.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Integer, List> treesGroupedByStartPosition = new LinkedHashMap<Integer, List>();
        for (com.sun.source.tree.Tree tree : trees) {
            treesGroupedByStartPosition.computeIfAbsent(((JCTree)tree).getStartPosition(), k -> new ArrayList()).add(tree);
        }
        ArrayList<JRightPadded<Statement>> converted = new ArrayList<JRightPadded<Statement>>();
        for (List treeGroup : treesGroupedByStartPosition.values()) {
            if (treeGroup.size() == 1) {
                converted.add(this.convert((com.sun.source.tree.Tree)treeGroup.get(0), suffix));
                continue;
            }
            String prefix = this.source.substring(this.cursor, Math.max(((JCTree)treeGroup.get(0)).getStartPosition(), this.cursor));
            this.cursor += prefix.length();
            com.sun.source.tree.Tree last = (com.sun.source.tree.Tree)treeGroup.get(treeGroup.size() - 1);
            J.VariableDeclarations vars = this.visitVariables(treeGroup, Space.format((String)prefix));
            JRightPadded<J.VariableDeclarations> paddedVars = this.padRight(vars, this.semiDelim.apply(last));
            this.cursor(Math.max(this.endPos(last), this.cursor));
            converted.add(paddedVars);
        }
        return converted;
    }

    private int endPos(com.sun.source.tree.Tree t) {
        return ((JCTree)t).getEndPosition(this.endPosTable);
    }

    private Space sourceBefore(String untilDelim) {
        return this.sourceBefore(untilDelim, null);
    }

    private Space sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private <T> JRightPadded<T> padRight(T tree, Space right) {
        return new JRightPadded(tree, right, Markers.EMPTY);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        delimIndex += 2;
                    }
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }

    private String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
        return token;
    }

    private void cursor(int n) {
        this.cursor = n;
    }

    private boolean hasFlag(ModifiersTree modifiers, long flag) {
        return (((JCTree.JCModifiers)modifiers).flags & flag) != 0L;
    }

    private List<String> listFlags(long flags) {
        Map<String, Long> allFlags = Arrays.stream(Flags.class.getDeclaredFields()).filter(field -> {
            field.setAccessible(true);
            try {
                return field.get(null) instanceof Long && field.getName().matches("[A-Z_]+");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(Field::getName, field -> {
            try {
                return (Long)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }));
        ArrayList<String> all = new ArrayList<String>();
        for (Map.Entry<String, Long> flagNameAndCode : allFlags.entrySet()) {
            if ((flagNameAndCode.getValue() & flags) == 0L) continue;
            all.add(flagNameAndCode.getKey());
        }
        return all;
    }

    private Java8ModifierResults sortedModifiersAndAnnotations(ModifiersTree modifiers, Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        ArrayList leadingAnnotations = new ArrayList();
        ArrayList sortedModifiers = new ArrayList();
        ArrayList<Object> currentAnnotations = new ArrayList<J.Annotation>();
        boolean afterFirstModifier = false;
        boolean inComment = false;
        boolean inMultilineComment = false;
        AtomicReference<String> word = new AtomicReference<String>("");
        int afterLastModifierPosition = this.cursor;
        int lastAnnotationPosition = this.cursor;
        for (int i = this.cursor; i < this.source.length(); ++i) {
            if (annotationPosTable.containsKey(i)) {
                J.Annotation annotation = (J.Annotation)this.convert(annotationPosTable.get(i));
                if (afterFirstModifier) {
                    currentAnnotations.add(annotation);
                } else {
                    leadingAnnotations.add(annotation);
                }
                i = this.cursor;
                lastAnnotationPosition = this.cursor;
                continue;
            }
            char c = this.source.charAt(i);
            if (c == '/' && this.source.length() > i + 1) {
                char next = this.source.charAt(i + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && this.source.charAt(i - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (inMultilineComment || inComment) continue;
            if (Character.isWhitespace(c)) {
                if (word.get().isEmpty()) continue;
                Modifier matching = null;
                for (Modifier modifier : modifiers.getFlags()) {
                    if (!modifier.name().toLowerCase().equals(word.get())) continue;
                    matching = modifier;
                    break;
                }
                if (matching == null) {
                    this.cursor = afterLastModifierPosition;
                    break;
                }
                sortedModifiers.add(this.mapModifier(matching, currentAnnotations));
                afterFirstModifier = true;
                currentAnnotations = new ArrayList();
                word.set("");
                afterLastModifierPosition = this.cursor;
                continue;
            }
            word.getAndUpdate(w -> w + c);
        }
        if (sortedModifiers.isEmpty()) {
            this.cursor = lastAnnotationPosition;
        }
        return new Java8ModifierResults(leadingAnnotations.isEmpty() ? Collections.emptyList() : leadingAnnotations, sortedModifiers.isEmpty() ? Collections.emptyList() : sortedModifiers);
    }

    private J.Modifier mapModifier(Modifier mod, List<J.Annotation> annotations) {
        J.Modifier.Type type;
        Space modFormat = this.whitespace();
        this.cursor += mod.name().length();
        switch (mod) {
            case DEFAULT: {
                type = J.Modifier.Type.Default;
                break;
            }
            case PUBLIC: {
                type = J.Modifier.Type.Public;
                break;
            }
            case PROTECTED: {
                type = J.Modifier.Type.Protected;
                break;
            }
            case PRIVATE: {
                type = J.Modifier.Type.Private;
                break;
            }
            case ABSTRACT: {
                type = J.Modifier.Type.Abstract;
                break;
            }
            case STATIC: {
                type = J.Modifier.Type.Static;
                break;
            }
            case FINAL: {
                type = J.Modifier.Type.Final;
                break;
            }
            case NATIVE: {
                type = J.Modifier.Type.Native;
                break;
            }
            case STRICTFP: {
                type = J.Modifier.Type.Strictfp;
                break;
            }
            case SYNCHRONIZED: {
                type = J.Modifier.Type.Synchronized;
                break;
            }
            case TRANSIENT: {
                type = J.Modifier.Type.Transient;
                break;
            }
            case VOLATILE: {
                type = J.Modifier.Type.Volatile;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected modifier " + (Object)((Object)mod));
            }
        }
        return new J.Modifier(Tree.randomId(), modFormat, Markers.EMPTY, type, annotations);
    }

    private List<J.Annotation> collectAnnotations(Map<Integer, JCTree.JCAnnotation> annotationPosTable) {
        int maxAnnotationPosition = annotationPosTable.keySet().stream().mapToInt(i -> i).max().orElse(0);
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        boolean inComment = false;
        boolean inMultilineComment = false;
        for (int i2 = this.cursor; i2 <= maxAnnotationPosition && i2 < this.source.length(); ++i2) {
            if (annotationPosTable.containsKey(i2)) {
                annotations.add((J.Annotation)this.convert(annotationPosTable.get(i2)));
                i2 = this.cursor;
                continue;
            }
            char c = this.source.charAt(i2);
            if (c == '/' && this.source.length() > i2 + 1) {
                char next = this.source.charAt(i2 + 1);
                if (next == '*') {
                    inMultilineComment = true;
                } else if (next == '/') {
                    inComment = true;
                }
            }
            if (inMultilineComment && c == '/' && i2 > 0 && this.source.charAt(i2 - 1) == '*') {
                inMultilineComment = false;
                continue;
            }
            if (inComment && c == '\n' || c == '\r') {
                inComment = false;
                continue;
            }
            if (!inMultilineComment && !inComment && !Character.isWhitespace(c)) break;
        }
        return annotations;
    }

    Space formatWithCommentTree(String prefix, JCTree tree, @Nullable DCTree.DCDocComment commentTree) {
        Space fmt = Space.format((String)prefix);
        if (commentTree != null) {
            Comment comment;
            int i;
            List comments = fmt.getComments();
            for (i = comments.size() - 1; !(i < 0 || (comment = (Comment)comments.get(i)).isMultiline() && ((TextComment)comment).getText().startsWith("*")); --i) {
            }
            AtomicReference<Javadoc.DocComment> javadoc = new AtomicReference<Javadoc.DocComment>();
            int commentCursor = this.cursor - prefix.length() + fmt.getWhitespace().length();
            for (int j2 = 0; j2 < comments.size(); ++j2) {
                Comment comment2 = (Comment)comments.get(j2);
                if (i == j2) {
                    javadoc.set((Javadoc.DocComment)new ReloadableJava8JavadocVisitor(this.context, this.getCurrentPath(), this.typeMapping, this.source.substring(commentCursor, this.source.indexOf("*/", commentCursor + 1)), tree).scan(commentTree, new ArrayList()));
                    break;
                }
                commentCursor += comment2.printComment().length() + comment2.getSuffix().length();
            }
            int javadocIndex = i;
            return fmt.withComments(ListUtils.map((List)fmt.getComments(), (j, c) -> j == javadocIndex ? ((Javadoc.DocComment)javadoc.get()).withSuffix(c.getSuffix()) : c));
        }
        return fmt;
    }
}

