/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.Java8ParserInputFileObject;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.LoggingHandler;
import org.openrewrite.java.ReloadableJava8ParserVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;

class ReloadableJava8Parser
implements JavaParser {
    @Nullable
    private final Collection<Path> classpath;
    private final boolean relaxedClassTypeMatching;
    private final boolean suppressMappingErrors;
    private final JavacFileManager pfm;
    private final Context context = new Context();
    private final Collection<NamedStyles> styles;
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog = new ResettableLog(this.context);
    @Nullable
    private final LoggingHandler loggingHandler;

    ReloadableJava8Parser(@Nullable Collection<Path> classpath, Charset charset, boolean relaxedClassTypeMatching, boolean suppressMappingErrors, final boolean logCompilationWarningsAndErrors, Collection<NamedStyles> styles, final @Nullable LoggingHandler loggingHandler) {
        this.classpath = classpath;
        this.styles = styles;
        this.loggingHandler = loggingHandler;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.suppressMappingErrors = suppressMappingErrors;
        this.pfm = new JavacFileManager(this.context, true, charset){

            @Override
            public boolean isSameFile(FileObject fileObject, FileObject fileObject1) {
                return fileObject.equals(fileObject1);
            }
        };
        Options.instance(this.context).put("allowStringFolding", "false");
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log = new String(Arrays.copyOfRange(cbuf, off, len));
                if (logCompilationWarningsAndErrors && !StringUtils.isBlank((String)log) && loggingHandler != null) {
                    loggingHandler.onWarn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
    }

    public java.util.List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        Map cus;
        block6: {
            if (this.classpath != null) {
                if (this.context.get(JavaFileManager.class) != this.pfm) {
                    throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
                }
                try {
                    this.pfm.setLocation(StandardLocation.CLASS_PATH, this.classpath.stream().map(Path::toFile).collect(Collectors.toList()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            cus = this.acceptedInputs(sourceFiles).stream().collect(Collectors.toMap(Function.identity(), input -> (JCTree.JCCompilationUnit)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in parsing and tokenizing the source file").tag("file.type", "Java").tag("step", "JDK parsing").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
                try {
                    return this.compiler.parse(new Java8ParserInputFileObject((Parser.Input)input));
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("endPosTable already set")) {
                        throw new IllegalStateException("Call reset() on JavaParser before parsing anotherset of source files that have some of the same fully qualified names", e);
                    }
                    throw e;
                }
            }), (e2, e1) -> e1, LinkedHashMap::new));
            try {
                this.enterAll(cus.values());
                this.compiler.attribute(new TimedTodo(this.compiler.todo));
            }
            catch (Throwable t) {
                if (this.loggingHandler == null) break block6;
                this.loggingHandler.onWarn("Failed symbol entering or attribution", t);
            }
        }
        HashMap sharedClassTypes = new HashMap();
        return cus.entrySet().stream().map(cuByPath -> {
            Timer.Sample sample = Timer.start();
            Parser.Input input = (Parser.Input)cuByPath.getKey();
            try {
                ReloadableJava8ParserVisitor parser = new ReloadableJava8ParserVisitor(input.getRelativePath(relativeTo), StringUtils.readFully((InputStream)input.getSource()), this.relaxedClassTypeMatching, this.styles, sharedClassTypes, this.loggingHandler);
                J.CompilationUnit cu = (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Space.EMPTY);
                sample.stop(Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("outcome", "success").tag("exception", "none").tag("step", "Map to Rewrite AST").register((MeterRegistry)Metrics.globalRegistry));
                return cu;
            }
            catch (Throwable t) {
                sample.stop(Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("outcome", "error").tag("exception", t.getClass().getSimpleName()).tag("step", "Map to Rewrite AST").register((MeterRegistry)Metrics.globalRegistry));
                if (!this.suppressMappingErrors) {
                    throw t;
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ReloadableJava8Parser reset() {
        this.compilerLog.reset();
        this.pfm.flush();
        Check.instance((Context)this.context).compiled.clear();
        return this;
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from(cus.toArray(new JCTree.JCCompilationUnit[0]));
        enter.main(compilationUnits);
    }

    private static class TimedTodo
    extends Todo {
        private final Todo todo;
        @Nullable
        private Timer.Sample sample;

        private TimedTodo(Todo todo) {
            super(new Context());
            this.todo = todo;
        }

        @Override
        public boolean isEmpty() {
            if (this.sample != null) {
                this.sample.stop(Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in type attributing the source file").tag("file.type", "Java").tag("step", "Type attribution").register((MeterRegistry)Metrics.globalRegistry));
            }
            return this.todo.isEmpty();
        }

        @Override
        public Env<AttrContext> remove() {
            this.sample = Timer.start();
            return (Env)this.todo.remove();
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }
    }
}

