/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.isolated;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTypeTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.SummaryTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.isolated.ReloadableJava17TypeMapping;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public class ReloadableJava17JavadocVisitor
extends DocTreeScanner<Tree, List<Javadoc>> {
    private final Attr attr;
    @Nullable
    private final Symbol.TypeSymbol symbol;
    @Nullable
    private final Type enclosingClassType;
    private final ReloadableJava17TypeMapping typeMapping;
    private final TreeScanner<J, Space> javaVisitor = new JavaVisitor();
    private final Map<Integer, Javadoc.LineBreak> lineBreaks = new HashMap<Integer, Javadoc.LineBreak>();
    private String firstPrefix = "";
    private String source;
    private int cursor = 0;

    public ReloadableJava17JavadocVisitor(Context context, TreePath scope, ReloadableJava17TypeMapping typeMapping, String source, JCTree tree) {
        this.attr = Attr.instance(context);
        this.typeMapping = typeMapping;
        this.source = source;
        if (scope.getLeaf() instanceof JCTree.JCCompilationUnit) {
            this.enclosingClassType = tree.type;
            this.symbol = ((JCTree.JCClassDecl)tree).sym;
        } else {
            com.sun.source.tree.Tree classDecl = scope.getLeaf();
            if (classDecl instanceof JCTree.JCClassDecl) {
                this.enclosingClassType = ((JCTree.JCClassDecl)classDecl).type;
                this.symbol = ((JCTree.JCClassDecl)classDecl).sym;
            } else if (classDecl instanceof JCTree.JCNewClass) {
                this.enclosingClassType = ((JCTree.JCNewClass)classDecl).def.type;
                this.symbol = ((JCTree.JCNewClass)classDecl).def.sym;
            } else {
                this.enclosingClassType = null;
                this.symbol = null;
            }
        }
    }

    private void init() {
        char[] sourceArr = this.source.toCharArray();
        StringBuilder firstPrefixBuilder = new StringBuilder();
        StringBuilder javadocContent = new StringBuilder();
        StringBuilder marginBuilder = null;
        boolean inFirstPrefix = true;
        boolean isPrefixAsterisk = true;
        for (int i = 3; i < sourceArr.length; ++i) {
            String newLine;
            char c = sourceArr[i];
            if (inFirstPrefix) {
                if (Character.isWhitespace(c) || c == '*' && isPrefixAsterisk) {
                    if (isPrefixAsterisk && i + 1 <= sourceArr.length - 1 && sourceArr[i + 1] != '*') {
                        isPrefixAsterisk = false;
                    }
                    firstPrefixBuilder.append(c);
                } else {
                    this.firstPrefix = firstPrefixBuilder.toString();
                    inFirstPrefix = false;
                }
            }
            if (c == '\r') continue;
            if (c == '\n') {
                if (inFirstPrefix) {
                    this.firstPrefix = firstPrefixBuilder.toString();
                    inFirstPrefix = false;
                } else {
                    if (sourceArr[i - 1] == '\n' || sourceArr[i - 1] == '\r' && sourceArr[i - 2] == '\n') {
                        String prevLineLine = sourceArr[i - 1] == '\n' ? "\n" : "\r\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), prevLineLine, Markers.EMPTY));
                    } else if (marginBuilder != null) {
                        newLine = sourceArr[i - 1] == '\r' ? "\r\n" : "\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), newLine, Markers.EMPTY));
                        javadocContent.append(marginBuilder.substring(marginBuilder.indexOf("\n") + 1));
                    }
                    javadocContent.append(c);
                }
                newLine = sourceArr[i - 1] == '\r' ? "\r\n" : "\n";
                marginBuilder = new StringBuilder(newLine);
                continue;
            }
            if (marginBuilder != null) {
                if (!Character.isWhitespace(c)) {
                    if (c == '*') {
                        marginBuilder.append(c);
                        if (i + 1 > sourceArr.length - 1 || sourceArr[i + 1] == '*') continue;
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                        marginBuilder = null;
                        continue;
                    }
                    if (c == '@') {
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                        javadocContent.append(c);
                    } else {
                        newLine = marginBuilder.toString().startsWith("\r") ? "\r\n" : "\n";
                        this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), newLine, Markers.EMPTY));
                        String margin = marginBuilder.toString();
                        javadocContent.append(margin.substring(margin.indexOf("\n") + 1)).append(c);
                    }
                    marginBuilder = null;
                    continue;
                }
                marginBuilder.append(c);
                continue;
            }
            if (inFirstPrefix) continue;
            javadocContent.append(c);
        }
        if (inFirstPrefix) {
            javadocContent.append((CharSequence)firstPrefixBuilder);
        }
        this.source = javadocContent.toString();
        if (marginBuilder != null && marginBuilder.length() > 0) {
            if (javadocContent.length() > 0 && javadocContent.charAt(0) != '\n') {
                this.lineBreaks.put(javadocContent.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
                this.source = this.source.substring(0, this.source.length() - 1);
            } else {
                this.lineBreaks.put(this.source.length(), new Javadoc.LineBreak(Tree.randomId(), marginBuilder.toString(), Markers.EMPTY));
            }
        }
    }

    @Override
    public Tree visitAttribute(AttributeTree node, List<Javadoc> body) {
        List value;
        List beforeEqual;
        String name = node.getName().toString();
        this.cursor += name.length();
        if (node.getValueKind() == AttributeTree.ValueKind.EMPTY) {
            beforeEqual = Collections.emptyList();
            value = Collections.emptyList();
        } else {
            Javadoc.LineBreak lineBreak;
            beforeEqual = new ArrayList();
            value = new ArrayList();
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                beforeEqual.add(lineBreak);
            }
            String whitespaceBeforeEqual = this.whitespaceBeforeAsString();
            beforeEqual.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeEqual));
            this.sourceBefore("=");
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                value.add(lineBreak);
            }
            switch (node.getValueKind()) {
                case UNQUOTED: {
                    value.addAll(this.convertMultiline(node.getValue()));
                    break;
                }
                case SINGLE: {
                    value.addAll(this.sourceBefore("'"));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "'"));
                    value.addAll(this.convertMultiline(node.getValue()));
                    value.addAll(this.sourceBefore("'"));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "'"));
                    break;
                }
                default: {
                    value.addAll(this.sourceBefore("\""));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "\""));
                    value.addAll(this.convertMultiline(node.getValue()));
                    value.addAll(this.sourceBefore("\""));
                    value.add(new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "\""));
                }
            }
        }
        return new Javadoc.Attribute(Tree.randomId(), Markers.EMPTY, name, beforeEqual, value);
    }

    @Override
    public Tree visitAuthor(AuthorTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@author"));
        return new Javadoc.Author(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getName()));
    }

    @Override
    public Tree visitComment(CommentTree node, List<Javadoc> body) {
        this.cursor += node.getBody().length();
        return new Javadoc.Text(Tree.randomId(), Markers.EMPTY, node.getBody());
    }

    @Override
    public Tree visitDeprecated(DeprecatedTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@deprecated"));
        return new Javadoc.Deprecated(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitDocComment(DocCommentTree node, List<Javadoc> body) {
        this.init();
        Javadoc.LineBreak leadingLineBreak = this.lineBreaks.remove(0);
        if (leadingLineBreak != null) {
            if (!this.firstPrefix.isEmpty()) {
                body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, this.firstPrefix.substring(0, this.firstPrefix.length() - (this.firstPrefix.endsWith("\r\n") ? 2 : 1))));
                this.firstPrefix = "";
            }
            body.add((Javadoc)leadingLineBreak);
        }
        if (!this.firstPrefix.isEmpty()) {
            body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, this.firstPrefix));
        }
        List<? extends DocTree> fullBody = node.getFullBody();
        for (int i = 0; i < fullBody.size(); ++i) {
            DocTree docTree = fullBody.get(i);
            if (!(docTree instanceof DCTree.DCText) || i <= 0) {
                body.addAll(this.whitespaceBefore());
            }
            if (docTree instanceof DCTree.DCText) {
                body.addAll(this.visitText(((DCTree.DCText)docTree).getBody()));
                continue;
            }
            body.add((Javadoc)this.scan(docTree, body));
        }
        for (DocTree docTree : node.getBlockTags()) {
            Javadoc.LineBreak lineBreak;
            block2: do {
                if ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                    body.add((Javadoc)lineBreak);
                }
                StringBuilder whitespaceBeforeNewLine = new StringBuilder();
                for (int j = ++this.cursor; j < this.source.length(); ++j) {
                    char ch = this.source.charAt(j);
                    if (ch == '\r') {
                        ++this.cursor;
                        continue;
                    }
                    if (ch == '\n') {
                        if (whitespaceBeforeNewLine.length() > 0) {
                            body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeNewLine.toString()));
                        }
                        this.cursor += whitespaceBeforeNewLine.length();
                        continue block2;
                    }
                    if (Character.isWhitespace(ch)) {
                        whitespaceBeforeNewLine.append(ch);
                        continue;
                    }
                    if (whitespaceBeforeNewLine.length() > 0) {
                        body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, whitespaceBeforeNewLine.toString()));
                        this.cursor += whitespaceBeforeNewLine.length();
                    }
                    break block2;
                }
            } while (lineBreak != null);
            body.addAll(this.whitespaceBefore());
            body.addAll(this.convertMultiline(Collections.singletonList(docTree)));
        }
        if (this.cursor < this.source.length() && this.source.substring(this.cursor).contains(" ")) {
            String trailingWhitespace = this.source.substring(this.cursor);
            if (trailingWhitespace.contains("\n")) {
                String[] stringArray;
                for (String part : stringArray = trailingWhitespace.split("\n")) {
                    int pos;
                    if (!part.isEmpty()) {
                        body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, part));
                    }
                    if (this.lineBreaks.isEmpty() || !this.lineBreaks.containsKey(pos = Collections.min(this.lineBreaks.keySet()).intValue())) continue;
                    body.add((Javadoc)this.lineBreaks.get(pos));
                    this.lineBreaks.remove(pos);
                }
            } else {
                body.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, trailingWhitespace));
            }
        }
        if (!this.lineBreaks.isEmpty()) {
            this.lineBreaks.keySet().stream().sorted().forEach(o -> body.add((Javadoc)this.lineBreaks.get(o)));
        }
        return new Javadoc.DocComment(Tree.randomId(), Markers.EMPTY, body, "");
    }

    @Override
    public Tree visitDocRoot(DocRootTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@docRoot"));
        return new Javadoc.DocRoot(Tree.randomId(), Markers.EMPTY, this.endBrace());
    }

    @Override
    public Tree visitDocType(DocTypeTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("<!doctype"));
        return new Javadoc.DocType(Tree.randomId(), Markers.EMPTY, ListUtils.concatAll((List)ListUtils.concat(this.sourceBefore(node.getText()), (Object)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, node.getText())), this.sourceBefore(">")));
    }

    @Override
    public Tree visitEndElement(EndElementTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("</"));
        String name = node.getName().toString();
        this.cursor += name.length();
        return new Javadoc.EndElement(Tree.randomId(), Markers.EMPTY, name, this.sourceBefore(">"));
    }

    @Override
    public Tree visitEntity(EntityTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("&"));
        this.cursor += node.getName().length() + 1;
        return new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "&" + node.getName().toString() + ";");
    }

    @Override
    public Tree visitErroneous(ErroneousTree node, List<Javadoc> body) {
        return new Javadoc.Erroneous(Tree.randomId(), Markers.EMPTY, this.visitText(node.getBody()));
    }

    @Override
    public Tree visitHidden(HiddenTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@hidden"));
        return new Javadoc.Hidden(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public J.Identifier visitIdentifier(IdentifierTree node, List<Javadoc> body) {
        String name = node.getName().toString();
        this.sourceBefore(name);
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, null, null);
    }

    @Override
    public Tree visitIndex(IndexTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@index"));
        List searchTerm = ListUtils.concatAll(this.whitespaceBefore(), this.convertMultiline(Collections.singletonList(node.getSearchTerm())));
        List<Javadoc> description = this.convertMultiline(node.getDescription());
        List paddedDescription = ListUtils.flatMap(description, (i, desc) -> {
            if (i == description.size() - 1) {
                if (desc instanceof Javadoc.Text) {
                    Javadoc.Text text = (Javadoc.Text)desc;
                    return text.withText(text.getText());
                }
                return ListUtils.concat((Object)desc, this.endBrace());
            }
            return desc;
        });
        return new Javadoc.Index(Tree.randomId(), Markers.EMPTY, searchTerm, paddedDescription, this.endBrace());
    }

    @Override
    public Tree visitInheritDoc(InheritDocTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@inheritDoc"));
        return new Javadoc.InheritDoc(Tree.randomId(), Markers.EMPTY, this.endBrace());
    }

    @Override
    public Tree visitLink(LinkTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore(node.getKind() == DocTree.Kind.LINK ? "{@link" : "{@linkplain"));
        List<Javadoc> spaceBeforeRef = this.whitespaceBefore();
        Javadoc.Reference reference = null;
        J ref = this.visitReference(node.getReference(), body);
        if (ref != null) {
            reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, ref, this.lineBreaksInMultilineJReference());
        }
        List<Javadoc> label = this.convertMultiline(node.getLabel());
        return new Javadoc.Link(Tree.randomId(), Markers.EMPTY, node.getKind() != DocTree.Kind.LINK, spaceBeforeRef, null, reference, label, this.endBrace());
    }

    @Override
    public Tree visitLiteral(LiteralTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore(node.getKind() == DocTree.Kind.CODE ? "{@code" : "{@literal"));
        List<Javadoc> description = this.whitespaceBefore();
        description.addAll(this.visitText(node.getBody().getBody()));
        return new Javadoc.Literal(Tree.randomId(), Markers.EMPTY, node.getKind() == DocTree.Kind.CODE, description, this.endBrace());
    }

    @Override
    public Tree visitParam(ParamTree node, List<Javadoc> body) {
        J typeName;
        List<Javadoc> spaceBefore;
        body.addAll(this.sourceBefore("@param"));
        DCTree.DCParam param = (DCTree.DCParam)node;
        if (param.isTypeParameter) {
            spaceBefore = this.sourceBefore("<");
            String beforeName = this.whitespaceBeforeAsString();
            Space namePrefix = beforeName.isEmpty() ? Space.EMPTY : Space.build((String)beforeName, Collections.emptyList());
            typeName = new J.TypeParameter(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), (Expression)this.visitIdentifier(node.getName(), this.whitespaceBefore()).withPrefix(namePrefix), null);
            this.sourceBefore(">");
        } else {
            spaceBefore = this.whitespaceBefore();
            typeName = (J)this.scan(node.getName(), body);
        }
        List<Javadoc> beforeReference = this.lineBreaksInMultilineJReference();
        Javadoc.Reference reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, typeName, beforeReference);
        return new Javadoc.Parameter(Tree.randomId(), Markers.EMPTY, spaceBefore, null, reference, this.convertMultiline(param.getDescription()));
    }

    @Override
    public Tree visitProvides(ProvidesTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@provides"));
        return new Javadoc.Provides(Tree.randomId(), Markers.EMPTY, this.whitespaceBefore(), this.visitReference(node.getServiceType(), body), this.convertMultiline(node.getDescription()));
    }

    @Override
    public J visitReference(@Nullable ReferenceTree node, List<Javadoc> body) {
        JavaType qualifierType;
        TypedTree qualifier;
        DCTree.DCReference ref = (DCTree.DCReference)node;
        if (node == null) {
            return null;
        }
        if (ref.qualifierExpression != null) {
            try {
                this.attr.attribType(ref.qualifierExpression, this.symbol);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (ref.qualifierExpression != null) {
            qualifier = (TypedTree)this.javaVisitor.scan(ref.qualifierExpression, Space.EMPTY);
            qualifierType = qualifier.getType();
            if (ref.memberName != null) {
                ++this.cursor;
            }
        } else {
            qualifierType = this.typeMapping.type(this.enclosingClassType);
            if (this.source.charAt(this.cursor) == '#') {
                qualifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", qualifierType, null);
                ++this.cursor;
            } else {
                qualifier = null;
            }
        }
        if (ref.memberName != null) {
            JavaType.Variable fieldRefType;
            J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, ref.memberName.toString(), null, null);
            this.cursor += ref.memberName.toString().length();
            JavaType.Method methodRefType = this.methodReferenceType(ref, qualifierType);
            JavaType.Variable variable = fieldRefType = methodRefType == null ? this.fieldReferenceType(ref, qualifierType) : null;
            if (ref.paramTypes != null) {
                JContainer paramContainer;
                this.sourceBeforeAsString("(");
                if (ref.paramTypes.isEmpty()) {
                    paramContainer = JContainer.build((Space)Space.EMPTY, Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.build((String)this.sourceBeforeAsString(")"), Collections.emptyList()), Markers.EMPTY))), (Markers)Markers.EMPTY);
                } else {
                    ArrayList<JRightPadded> parameters = new ArrayList<JRightPadded>(ref.paramTypes.size());
                    List<JCTree> paramTypes = ref.paramTypes;
                    for (int i = 0; i < paramTypes.size(); ++i) {
                        JCTree param = paramTypes.get(i);
                        Expression paramExpr = (Expression)this.javaVisitor.scan(param, Space.build((String)this.whitespaceBeforeAsString(), Collections.emptyList()));
                        Space rightFmt = Space.format((String)(i == paramTypes.size() - 1 ? this.sourceBeforeAsString(")") : this.sourceBeforeAsString(",")));
                        parameters.add(new JRightPadded((Object)paramExpr, rightFmt, Markers.EMPTY));
                    }
                    paramContainer = JContainer.build((Space)Space.EMPTY, parameters, (Markers)Markers.EMPTY);
                }
                return new J.MethodInvocation(Tree.randomId(), qualifier == null ? Space.EMPTY : qualifier.getPrefix(), Markers.EMPTY, qualifier == null ? null : JRightPadded.build((Object)((Expression)qualifier.withPrefix(Space.EMPTY))), null, name, paramContainer, methodRefType);
            }
            return new J.MemberReference(Tree.randomId(), qualifier == null ? Space.EMPTY : qualifier.getPrefix(), Markers.EMPTY, qualifier == null ? null : JRightPadded.build((Object)((Expression)qualifier.withPrefix(Space.EMPTY))), JContainer.empty(), JLeftPadded.build((Object)name), null, methodRefType, fieldRefType);
        }
        assert (qualifier != null);
        return qualifier;
    }

    @Nullable
    private JavaType.Method methodReferenceType(DCTree.DCReference ref, @Nullable JavaType type) {
        block8: {
            block7: {
                if (!(type instanceof JavaType.Class)) break block7;
                JavaType.Class classType = (JavaType.Class)type;
                block0: for (JavaType.Method method : classType.getMethods()) {
                    if (!method.getName().equals(ref.memberName.toString())) continue;
                    if (ref.paramTypes != null) {
                        for (JCTree param : ref.paramTypes) {
                            for (JavaType testParamType : method.getParameterTypes()) {
                                Type paramType = this.attr.attribType(param, this.symbol);
                                if (testParamType instanceof JavaType.GenericTypeVariable) {
                                    for (JavaType bound : ((JavaType.GenericTypeVariable)testParamType).getBounds()) {
                                        if (!this.paramTypeMatches(bound, paramType)) continue;
                                        return method;
                                    }
                                    continue block0;
                                }
                                if (!this.paramTypeMatches(testParamType, paramType)) continue;
                                continue block0;
                            }
                        }
                    }
                    return method;
                }
                break block8;
            }
            if (!(type instanceof JavaType.GenericTypeVariable)) break block8;
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)type;
            for (JavaType bound : generic.getBounds()) {
                JavaType.Method method = this.methodReferenceType(ref, bound);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private boolean paramTypeMatches(JavaType testParamType, Type paramType) {
        if (paramType instanceof Type.ClassType) {
            JavaType.FullyQualified fqTestParamType = TypeUtils.asFullyQualified((JavaType)testParamType);
            return fqTestParamType == null || !fqTestParamType.getFullyQualifiedName().equals(((Symbol.ClassSymbol)paramType.tsym).fullname.toString());
        }
        return false;
    }

    @Nullable
    private JavaType.Variable fieldReferenceType(DCTree.DCReference ref, @Nullable JavaType type) {
        JavaType.Class classType = TypeUtils.asClass((JavaType)type);
        if (classType == null) {
            return null;
        }
        for (JavaType.Variable member : classType.getMembers()) {
            if (!member.getName().equals(ref.memberName.toString())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Tree visitReturn(ReturnTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@return"));
        return new Javadoc.Return(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSee(SeeTree node, List<Javadoc> body) {
        List<Javadoc> docs;
        body.addAll(this.sourceBefore("@see"));
        Javadoc.Reference reference = null;
        List<Javadoc> spaceBeforeTree = this.whitespaceBefore();
        if (node.getReference().get(0) instanceof DCTree.DCReference) {
            J ref = this.visitReference((ReferenceTree)node.getReference().get(0), body);
            if (ref != null) {
                reference = new Javadoc.Reference(Tree.randomId(), Markers.EMPTY, ref, this.lineBreaksInMultilineJReference());
            }
            docs = this.convertMultiline(node.getReference().subList(1, node.getReference().size()));
        } else {
            docs = this.convertMultiline(node.getReference());
        }
        return new Javadoc.See(Tree.randomId(), Markers.EMPTY, spaceBeforeTree, null, reference, docs);
    }

    @Override
    public Tree visitSerial(SerialTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serial"));
        return new Javadoc.Serial(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSerialData(SerialDataTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serialData"));
        return new Javadoc.SerialData(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSerialField(SerialFieldTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@serialField"));
        return new Javadoc.SerialField(Tree.randomId(), Markers.EMPTY, this.visitIdentifier(node.getName(), this.whitespaceBefore()), this.visitReference(node.getType(), this.whitespaceBefore()), this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitSince(SinceTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@since"));
        return new Javadoc.Since(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitStartElement(StartElementTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("<"));
        String name = node.getName().toString();
        this.cursor += name.length();
        return new Javadoc.StartElement(Tree.randomId(), Markers.EMPTY, name, this.convertMultiline(node.getAttributes()), node.isSelfClosing(), node.isSelfClosing() ? this.sourceBefore("/>") : this.sourceBefore(">"));
    }

    @Override
    public Tree visitSummary(SummaryTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@summary"));
        List<Javadoc> summary = this.convertMultiline(node.getSummary());
        List paddedSummary = ListUtils.flatMap(summary, (i, sum) -> {
            if (i == summary.size() - 1) {
                if (sum instanceof Javadoc.Text) {
                    Javadoc.Text text = (Javadoc.Text)sum;
                    return ListUtils.concat((Object)text.withText(text.getText()), this.endBrace());
                }
                return ListUtils.concat((Object)sum, this.endBrace());
            }
            return sum;
        });
        return new Javadoc.Summary(Tree.randomId(), Markers.EMPTY, paddedSummary, this.endBrace());
    }

    @Override
    public Tree visitVersion(VersionTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@version"));
        return new Javadoc.Version(Tree.randomId(), Markers.EMPTY, this.convertMultiline(node.getBody()));
    }

    @Override
    public Tree visitText(TextTree node, List<Javadoc> body) {
        throw new UnsupportedOperationException("Anywhere text can occur, we need to call the visitText override that returns a list of Javadoc elements.");
    }

    public List<Javadoc> visitText(String node) {
        ArrayList<Javadoc> texts = new ArrayList<Javadoc>();
        if (!node.isEmpty() && Character.isWhitespace(node.charAt(0)) && !Character.isWhitespace(this.source.charAt(this.cursor))) {
            node = node.stripLeading();
        }
        char[] textArr = node.toCharArray();
        StringBuilder text = new StringBuilder();
        for (char c : textArr) {
            ++this.cursor;
            if (c == '\n') {
                if (text.length() > 0) {
                    texts.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, text.toString()));
                    text = new StringBuilder();
                }
                Javadoc.LineBreak lineBreak = this.lineBreaks.remove(this.cursor);
                assert (lineBreak != null);
                texts.add((Javadoc)lineBreak);
                continue;
            }
            text.append(c);
        }
        if (text.length() > 0) {
            texts.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, text.toString()));
        }
        return texts;
    }

    @Override
    public Tree visitThrows(ThrowsTree node, List<Javadoc> body) {
        boolean throwsKeyword = this.source.startsWith("@throws", this.cursor);
        this.sourceBefore(throwsKeyword ? "@throws" : "@exception");
        List<Javadoc> spaceBeforeExceptionName = this.whitespaceBefore();
        return new Javadoc.Throws(Tree.randomId(), Markers.EMPTY, throwsKeyword, spaceBeforeExceptionName, this.visitReference(node.getExceptionName(), body), this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitUnknownBlockTag(UnknownBlockTagTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@" + node.getTagName()));
        return new Javadoc.UnknownBlock(Tree.randomId(), Markers.EMPTY, node.getTagName(), this.convertMultiline(node.getContent()));
    }

    @Override
    public Tree visitUnknownInlineTag(UnknownInlineTagTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@" + node.getTagName()));
        return new Javadoc.UnknownInline(Tree.randomId(), Markers.EMPTY, node.getTagName(), this.convertMultiline(node.getContent()), this.endBrace());
    }

    @Override
    public Tree visitUses(UsesTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("@uses"));
        return new Javadoc.Uses(Tree.randomId(), Markers.EMPTY, this.whitespaceBefore(), this.visitReference(node.getServiceType(), body), this.convertMultiline(node.getDescription()));
    }

    @Override
    public Tree visitValue(ValueTree node, List<Javadoc> body) {
        body.addAll(this.sourceBefore("{@value"));
        return new Javadoc.InlinedValue(Tree.randomId(), Markers.EMPTY, this.whitespaceBefore(), node.getReference() == null ? null : this.visitReference(node.getReference(), body), this.endBrace());
    }

    private String sourceBeforeAsString(String delim) {
        if (this.cursor >= this.source.length()) {
            return "";
        }
        int endIndex = this.source.indexOf(delim, this.cursor);
        if (endIndex < 0) {
            throw new IllegalStateException("Expected to be able to find " + delim);
        }
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor = endIndex + delim.length();
        return prefix;
    }

    private List<Javadoc> sourceBefore(String delim) {
        if (this.cursor >= this.source.length()) {
            return Collections.emptyList();
        }
        int endIndex = this.source.indexOf(delim, this.cursor);
        if (endIndex < 0) {
            throw new IllegalStateException("Expected to be able to find " + delim);
        }
        List<Javadoc> before = this.whitespaceBefore();
        this.cursor += delim.length();
        return before;
    }

    private String whitespaceBeforeAsString() {
        int i;
        if (this.cursor >= this.source.length()) {
            return "";
        }
        for (i = this.cursor; i < this.source.length() && Character.isWhitespace(this.source.charAt(i)); ++i) {
        }
        String fmt = this.source.substring(this.cursor, i);
        this.cursor = i;
        return fmt;
    }

    private List<Javadoc> whitespaceBefore() {
        Javadoc.LineBreak lineBreak;
        if (this.cursor >= this.source.length()) {
            return Collections.emptyList();
        }
        ArrayList<Javadoc> whitespace = new ArrayList<Javadoc>();
        while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
            ++this.cursor;
            whitespace.add((Javadoc)lineBreak);
        }
        StringBuilder space = new StringBuilder();
        while (this.cursor < this.source.length() && Character.isWhitespace(this.source.charAt(this.cursor))) {
            char c = this.source.charAt(this.cursor);
            if (c == '\n') {
                if (space.length() > 0) {
                    whitespace.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, space.toString()));
                }
                space = new StringBuilder();
                lineBreak = this.lineBreaks.remove(this.cursor + 1);
                assert (lineBreak != null);
                whitespace.add((Javadoc)lineBreak);
            } else {
                space.append(c);
            }
            ++this.cursor;
        }
        if (space.length() > 0) {
            whitespace.add((Javadoc)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, space.toString()));
        }
        return whitespace;
    }

    private List<Javadoc> endBrace() {
        if (this.cursor < this.source.length()) {
            int tempCursor = this.cursor;
            List end = this.whitespaceBefore();
            if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == '}') {
                end = ListUtils.concat(end, (Object)new Javadoc.Text(Tree.randomId(), Markers.EMPTY, "}"));
                ++this.cursor;
                return end;
            }
            this.cursor = tempCursor;
        }
        return Collections.emptyList();
    }

    private List<Javadoc> convertMultiline(List<? extends DocTree> dts) {
        Javadoc.LineBreak lineBreak;
        ArrayList<Javadoc> js = new ArrayList<Javadoc>(dts.size());
        while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
            ++this.cursor;
            js.add((Javadoc)lineBreak);
        }
        for (int i = 0; i < dts.size(); ++i) {
            DocTree dt = dts.get(i);
            if (i > 0 && dt instanceof DCTree.DCText) {
                js.addAll(this.visitText(((DCTree.DCText)dt).getBody()));
                continue;
            }
            while ((lineBreak = this.lineBreaks.remove(this.cursor + 1)) != null) {
                ++this.cursor;
                js.add((Javadoc)lineBreak);
            }
            js.addAll(this.whitespaceBefore());
            if (dt instanceof DCTree.DCText) {
                js.addAll(this.visitText(((DCTree.DCText)dt).getBody()));
                continue;
            }
            js.add((Javadoc)this.scan(dt, Collections.emptyList()));
        }
        return js;
    }

    private List<Javadoc> lineBreaksInMultilineJReference() {
        List linebreakIndexes = this.lineBreaks.keySet().stream().filter(o -> o <= this.cursor).collect(Collectors.toList());
        List<Javadoc> referenceLineBreaks = linebreakIndexes.stream().sorted().map(this.lineBreaks::get).collect(Collectors.toList());
        for (Integer key : linebreakIndexes) {
            this.lineBreaks.remove(key);
        }
        return referenceLineBreaks;
    }

    class JavaVisitor
    extends TreeScanner<J, Space> {
        JavaVisitor() {
        }

        @Override
        public J visitMemberSelect(MemberSelectTree node, Space fmt) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)node;
            Expression selected = (Expression)this.scan(fieldAccess.selected, Space.EMPTY);
            ReloadableJava17JavadocVisitor.this.sourceBefore(".");
            ReloadableJava17JavadocVisitor.this.cursor += fieldAccess.name.toString().length();
            return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, selected, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, fieldAccess.name.toString(), null, null)), ReloadableJava17JavadocVisitor.this.typeMapping.type(node));
        }

        @Override
        public J visitIdentifier(com.sun.source.tree.IdentifierTree node, Space fmt) {
            String name = node.getName().toString();
            ReloadableJava17JavadocVisitor.this.cursor += name.length();
            JavaType type = ReloadableJava17JavadocVisitor.this.typeMapping.type(node);
            return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, name, type, null);
        }

        @Override
        public J visitPrimitiveType(PrimitiveTypeTree node, Space fmt) {
            JCTree.JCPrimitiveTypeTree primitiveType = (JCTree.JCPrimitiveTypeTree)node;
            String name = primitiveType.toString();
            ReloadableJava17JavadocVisitor.this.cursor += name.length();
            return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, name, (JavaType)ReloadableJava17JavadocVisitor.this.typeMapping.primitive(primitiveType.typetag), null);
        }

        @Override
        public J visitParameterizedType(ParameterizedTypeTree node, Space fmt) {
            NameTree id = (NameTree)ReloadableJava17JavadocVisitor.this.javaVisitor.scan(node.getType(), Space.EMPTY);
            ArrayList<JRightPadded> expressions = new ArrayList<JRightPadded>(node.getTypeArguments().size());
            ++ReloadableJava17JavadocVisitor.this.cursor;
            int argsSize = node.getTypeArguments().size();
            for (int i = 0; i < argsSize; ++i) {
                Space space = Space.build((String)ReloadableJava17JavadocVisitor.this.whitespaceBeforeAsString(), Collections.emptyList());
                JRightPadded expression = JRightPadded.build((Object)((Expression)ReloadableJava17JavadocVisitor.this.javaVisitor.scan(node.getTypeArguments().get(i), space)));
                Space after = i == argsSize - 1 ? Space.build((String)ReloadableJava17JavadocVisitor.this.sourceBeforeAsString(">"), Collections.emptyList()) : Space.build((String)ReloadableJava17JavadocVisitor.this.sourceBeforeAsString(","), Collections.emptyList());
                expression = expression.withAfter(after);
                expressions.add(expression);
            }
            return new J.ParameterizedType(Tree.randomId(), fmt, Markers.EMPTY, id, JContainer.build(expressions));
        }
    }
}

