/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.marker;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import org.openrewrite.marker.Marker;

public final class AssemblyReferencesMarker
implements Marker {
    private final UUID id;

    @Generated
    public AssemblyReferencesMarker(UUID id) {
        this.id = id;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof AssemblyReferencesMarker;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "AssemblyReferencesMarker(id=" + this.getId() + ")";
    }

    @Generated
    public AssemblyReferencesMarker withId(UUID id) {
        return this.id == id ? this : new AssemblyReferencesMarker(id);
    }

    public static final class AssemblyReference {
        private final byte[] assembly;
        private final String fileName;
        @Nullable
        private final String packageName;
        @Nullable
        private final String packageVersion;

        public void writeToFolder(String directory) throws IOException {
            Path dirPath = Paths.get(directory, new String[0]);
            Files.createDirectories(dirPath, new FileAttribute[0]);
            Path filePath = dirPath.resolve(this.fileName);
            Files.write(filePath, this.assembly, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }

        @Generated
        public AssemblyReference(byte[] assembly, String fileName, @Nullable String packageName, @Nullable String packageVersion) {
            this.assembly = assembly;
            this.fileName = fileName;
            this.packageName = packageName;
            this.packageVersion = packageVersion;
        }

        @Generated
        public byte[] getAssembly() {
            return this.assembly;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Nullable
        @Generated
        public String getPackageName() {
            return this.packageName;
        }

        @Nullable
        @Generated
        public String getPackageVersion() {
            return this.packageVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssemblyReference)) {
                return false;
            }
            AssemblyReference other = (AssemblyReference)o;
            if (!Arrays.equals(this.getAssembly(), other.getAssembly())) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$packageVersion = this.getPackageVersion();
            String other$packageVersion = other.getPackageVersion();
            return !(this$packageVersion == null ? other$packageVersion != null : !this$packageVersion.equals(other$packageVersion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getAssembly());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $packageVersion = this.getPackageVersion();
            result = result * 59 + ($packageVersion == null ? 43 : $packageVersion.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssemblyReferencesMarker.AssemblyReference(assembly=" + Arrays.toString(this.getAssembly()) + ", fileName=" + this.getFileName() + ", packageName=" + this.getPackageName() + ", packageVersion=" + this.getPackageVersion() + ")";
        }

        @Generated
        public AssemblyReference withAssembly(byte[] assembly) {
            return this.assembly == assembly ? this : new AssemblyReference(assembly, this.fileName, this.packageName, this.packageVersion);
        }

        @Generated
        public AssemblyReference withFileName(String fileName) {
            return this.fileName == fileName ? this : new AssemblyReference(this.assembly, fileName, this.packageName, this.packageVersion);
        }

        @Generated
        public AssemblyReference withPackageName(@Nullable String packageName) {
            return this.packageName == packageName ? this : new AssemblyReference(this.assembly, this.fileName, packageName, this.packageVersion);
        }

        @Generated
        public AssemblyReference withPackageVersion(@Nullable String packageVersion) {
            return this.packageVersion == packageVersion ? this : new AssemblyReference(this.assembly, this.fileName, this.packageName, packageVersion);
        }
    }
}

