/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class MockitoJUnitToMockitoExtension
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 `MockitoJUnit` to JUnit Jupiter `MockitoExtension`";
    }

    public String getDescription() {
        return "Replaces `MockitoJUnit` rules with `MockitoExtension`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.junit.MockitoTestRule", Boolean.valueOf(false)), new UsesType("org.mockito.junit.MockitoRule", Boolean.valueOf(false))}), (TreeVisitor)new MockitoRuleToMockitoExtensionVisitor());
    }

    public static class MockitoRuleToMockitoExtensionVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String MOCKITO_RULE_INVOCATION_KEY = "mockitoRuleInvocation";
        private static final String MOCKITO_TEST_RULE_INVOCATION_KEY = "mockitoTestRuleInvocation";
        private static final String STRICTNESS_KEY = "strictness";
        private static final String EXTEND_WITH_MOCKITO_EXTENSION = "@org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)";
        private static final String RUN_WITH_MOCKITO_JUNIT_RUNNER = "@org.junit.runner.RunWith(org.mockito.runners.MockitoJUnitRunner.class)";

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Set mockitoFields = FindFieldsOfType.find((J)cd, (String)"org.mockito.junit.MockitoRule");
            mockitoFields.addAll(FindFieldsOfType.find((J)cd, (String)"org.mockito.junit.MockitoTestRule"));
            if (!mockitoFields.isEmpty()) {
                ArrayList statements = new ArrayList(cd.getBody().getStatements());
                statements.removeAll(mockitoFields);
                cd = cd.withBody(cd.getBody().withStatements(statements));
                this.maybeRemoveImport("org.mockito.junit.MockitoRule");
                this.maybeRemoveImport("org.mockito.junit.MockitoTestRule");
                this.maybeRemoveImport("org.junit.Rule");
                this.maybeRemoveImport("org.mockito.junit.MockitoJUnit");
                this.maybeRemoveImport("org.mockito.quality.Strictness");
                if (classDecl.getBody().getStatements().size() != cd.getBody().getStatements().size() && FindAnnotations.find((J)classDecl.withBody(null), (String)RUN_WITH_MOCKITO_JUNIT_RUNNER).isEmpty() && FindAnnotations.find((J)classDecl.withBody(null), (String)EXTEND_WITH_MOCKITO_EXTENSION).isEmpty()) {
                    String strictness = (String)this.getCursor().pollMessage(STRICTNESS_KEY);
                    cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@ExtendWith(MockitoExtension.class)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9", "mockito-junit-jupiter-3.12"})).imports(new String[]{"org.junit.jupiter.api.extension.ExtendWith", "org.mockito.junit.jupiter.MockitoExtension"}).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    this.maybeAddImport("org.junit.jupiter.api.extension.ExtendWith");
                    this.maybeAddImport("org.mockito.junit.jupiter.MockitoExtension");
                    if (strictness == null) {
                        strictness = "Strictness.WARN";
                    }
                    if (!strictness.contains("STRICT_STUBS")) {
                        cd = (J.ClassDeclaration)JavaTemplate.builder((String)("@MockitoSettings(strictness = " + strictness + ")")).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9", "mockito-junit-jupiter-3.12"})).imports(new String[]{"org.mockito.junit.jupiter.MockitoSettings", "org.mockito.quality.Strictness"}).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                        this.maybeAddImport("org.mockito.junit.jupiter.MockitoSettings", false);
                        this.maybeAddImport("org.mockito.quality.Strictness", false);
                    }
                }
            }
            return cd;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null) {
                String key = null;
                if (TypeUtils.isOfClassType((JavaType)method.getMethodType().getDeclaringType(), (String)"org.mockito.junit.MockitoRule")) {
                    key = MOCKITO_RULE_INVOCATION_KEY;
                } else if (TypeUtils.isOfClassType((JavaType)method.getMethodType().getDeclaringType(), (String)"org.mockito.junit.MockitoTestRule")) {
                    key = MOCKITO_TEST_RULE_INVOCATION_KEY;
                }
                if (key != null) {
                    this.getCursor().putMessageOnFirstEnclosing(J.MethodDeclaration.class, key, (Object)method);
                    String strictness = null;
                    switch (method.getSimpleName()) {
                        case "strictness": {
                            strictness = ((Expression)method.getArguments().get(0)).toString();
                            break;
                        }
                        case "silent": {
                            strictness = "Strictness.LENIENT";
                        }
                    }
                    if (strictness != null) {
                        strictness = strictness.startsWith("Strictness.") ? strictness : "Strictness." + strictness;
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, STRICTNESS_KEY, (Object)strictness);
                    }
                }
            }
            return method;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(methodDecl, (Object)ctx);
            J.MethodInvocation mockitoRuleInvocation = (J.MethodInvocation)this.getCursor().pollMessage(MOCKITO_RULE_INVOCATION_KEY);
            J.MethodInvocation mockitoTestRuleInvocation = (J.MethodInvocation)this.getCursor().pollMessage(MOCKITO_TEST_RULE_INVOCATION_KEY);
            if ((mockitoRuleInvocation != null || mockitoTestRuleInvocation != null) && m.getBody() != null) {
                List filteredStatements = m.getBody().getStatements().stream().filter(it -> !MockitoRuleToMockitoExtensionVisitor.isTargetMethodInvocation(it)).collect(Collectors.toList());
                m = m.withBody((J.Block)new AutoFormatVisitor().visit((Tree)m.getBody().withStatements(filteredStatements), (Object)ctx, this.getCursor()));
            }
            return m;
        }

        private static boolean isTargetMethodInvocation(Statement statement) {
            if (!(statement instanceof J.MethodInvocation)) {
                return false;
            }
            J.MethodInvocation m = (J.MethodInvocation)statement;
            if (m.getMethodType() == null) {
                return false;
            }
            return TypeUtils.isOfClassType((JavaType)m.getMethodType().getDeclaringType(), (String)"org.mockito.junit.MockitoRule") || TypeUtils.isOfClassType((JavaType)m.getMethodType().getDeclaringType(), (String)"org.mockito.junit.MockitoTestRule");
        }
    }
}

