/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class JUnitAssertThrowsToAssertExceptionType
extends Recipe {
    public String getDisplayName() {
        return "JUnit AssertThrows to AssertJ exceptionType";
    }

    public String getDescription() {
        return "Convert `JUnit#AssertThrows` to `AssertJ#assertThatExceptionOfType` to allow for chained assertions on the thrown exception.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.junit.jupiter.api.Assertions assertThrows(..)"), (TreeVisitor)new AssertExceptionTypeVisitor());
    }

    private static class AssertExceptionTypeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JavaParser.Builder<?, ?> assertionsParser;
        private static final MethodMatcher ASSERT_THROWS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertThrows(..)");
        private static final JavaType THROWING_CALLABLE_TYPE = JavaType.buildType((String)"org.assertj.core.api.ThrowableAssert.ThrowingCallable");

        private AssertExceptionTypeVisitor() {
        }

        private JavaParser.Builder<?, ?> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"});
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            Object executable;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (ASSERT_THROWS_MATCHER.matches((MethodCall)mi) && mi.getArguments().size() == 2 && this.getCursor().getParentTreeCursor().getValue() instanceof J.Block && (executable = (executable = (J)mi.getArguments().get(1)) instanceof J.Lambda ? ((J.Lambda)executable).withType(THROWING_CALLABLE_TYPE) : (executable instanceof J.MemberReference ? ((J.MemberReference)executable).withType(THROWING_CALLABLE_TYPE) : null)) != null) {
                mi = (J.MethodInvocation)JavaTemplate.builder((String)"assertThatExceptionOfType(#{any(java.lang.Class)}).isThrownBy(#{any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(this.assertionsParser(ctx)).staticImports(new String[]{"org.assertj.core.api.AssertionsForClassTypes.assertThatExceptionOfType"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), executable});
                this.maybeAddImport("org.assertj.core.api.AssertionsForClassTypes", "assertThatExceptionOfType", false);
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            }
            return mi;
        }
    }
}

