/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.testing.hamcrest.HamcrestMatcherToAssertJ;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class HamcrestIsMatcherToAssertJ
extends Recipe {
    static final MethodMatcher IS_OBJECT_MATCHER = new MethodMatcher("org.hamcrest.Matchers is(..)");

    public String getDisplayName() {
        return "Migrate Hamcrest `is(Object)` to AssertJ";
    }

    public String getDescription() {
        return "Migrate Hamcrest `is(Object)` to AssertJ `Assertions.assertThat(..)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(IS_OBJECT_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                List arguments = methodInvocation.getArguments();
                String replacement = 2 <= arguments.size() && TypeUtils.asArray((JavaType)((Expression)arguments.get(arguments.size() - 2)).getType()) != null ? "containsExactly" : "isEqualTo";
                this.doAfterVisit(new HamcrestMatcherToAssertJ("is", replacement).getVisitor());
                return super.visitMethodInvocation(methodInvocation, (Object)ctx);
            }
        });
    }
}

