/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitAssertTrueToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertTrue` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertTrue()` to AssertJ's `assertThat().isTrue()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(false)), (TreeVisitor)new AssertTrueToAssertThatVisitor());
    }

    public static class AssertTrueToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JavaParser.Builder<?, ?> assertionsParser;
        private static final MethodMatcher JUNIT_ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(boolean, ..)");

        private JavaParser.Builder<?, ?> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"});
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_TRUE.matches((MethodCall)method)) {
                return method;
            }
            List args = method.getArguments();
            Expression actual = (Expression)args.get(0);
            if (args.size() == 1) {
                method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(boolean)}).isTrue();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual});
            } else {
                Expression message = (Expression)args.get(1);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder((String)"assertThat(#{any(boolean)}).as(#{any(String)}).isTrue();") : JavaTemplate.builder((String)"assertThat(#{any(boolean)}).as(#{any(java.util.function.Supplier)}).isTrue();");
                method = (J.MethodInvocation)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message});
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            return method;
        }
    }
}

