/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.NeedBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class NeedBraces
extends Recipe {
    public String getDisplayName() {
        return "Fix missing braces";
    }

    public String getDescription() {
        return "Adds missing braces around code such as single-line `if`, `for`, `while`, and `do-while` block bodies.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-121");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new NeedBracesVisitor();
    }

    private static class NeedBracesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        NeedBracesStyle needBracesStyle;

        private NeedBracesVisitor() {
        }

        private static <T extends Statement> J.Block buildBlock(T element) {
            return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)false), element instanceof J.Empty ? Collections.emptyList() : Collections.singletonList(JRightPadded.build(element)), Space.EMPTY);
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                this.needBracesStyle = cu.getStyle(NeedBracesStyle.class) == null ? Checkstyle.needBracesStyle() : (NeedBracesStyle)cu.getStyle(NeedBracesStyle.class);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J.If visitIf(J.If iff, ExecutionContext ctx) {
            J.If elem = super.visitIf(iff, (Object)ctx);
            boolean hasAllowableBodyType = elem.getThenPart() instanceof J.Block;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getThenPart());
                elem = (J.If)this.maybeAutoFormat((J)elem, (J)elem.withThenPart((Statement)b), ctx);
            }
            return elem;
        }

        public J.If.Else visitElse(J.If.Else else_, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.If.Else elem = super.visitElse(else_, (Object)ctx);
            boolean bl = hasAllowableBodyType = elem.getBody() instanceof J.Block || elem.getBody() instanceof J.If;
            if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.If.Else)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.WhileLoop elem = super.visitWhileLoop(whileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.WhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.DoWhileLoop elem = super.visitDoWhileLoop(doWhileLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.DoWhileLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
            boolean hasAllowableBodyType;
            J.ForLoop elem = super.visitForLoop(forLoop, (Object)ctx);
            boolean bl = this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() ? elem.getBody() instanceof J.Block || elem.getBody() instanceof J.Empty : (hasAllowableBodyType = elem.getBody() instanceof J.Block);
            if (!this.needBracesStyle.getAllowEmptyLoopBody().booleanValue() && elem.getBody() instanceof J.Empty) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            } else if (!this.needBracesStyle.getAllowSingleLineStatement().booleanValue() && !hasAllowableBodyType) {
                J.Block b = NeedBracesVisitor.buildBlock(elem.getBody());
                elem = (J.ForLoop)this.maybeAutoFormat((J)elem, (J)elem.withBody((Statement)b), ctx);
            }
            return elem;
        }
    }
}

