/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.style.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructorVisitor<P>
extends JavaIsoVisitor<P> {
    private static final EnumSet<J.ClassDeclaration.Kind.Type> EXCLUDE_CLASS_TYPES = EnumSet.of(J.ClassDeclaration.Kind.Type.Interface, J.ClassDeclaration.Kind.Type.Record);
    private final UtilityClassMatcher utilityClassMatcher;

    public HideUtilityClassConstructorVisitor(HideUtilityClassConstructorStyle style) {
        this.utilityClassMatcher = new UtilityClassMatcher(style.getIgnoreIfAnnotatedBy());
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        if (!EXCLUDE_CLASS_TYPES.contains(c.getKind()) && !c.hasModifier(J.Modifier.Type.Abstract) && this.utilityClassMatcher.isRefactorableUtilityClass(this.getCursor())) {
            c = (J.ClassDeclaration)new UtilityClassWithImplicitDefaultConstructorVisitor().visit((Tree)c, p, this.getCursor().getParentOrThrow());
            c = (J.ClassDeclaration)new UtilityClassWithExposedConstructorInspectionVisitor(c).visit((Tree)c, p, this.getCursor().getParentOrThrow());
        }
        return c;
    }

    private final class UtilityClassMatcher {
        private final Collection<AnnotationMatcher> ignorableAnnotations;

        private UtilityClassMatcher(Collection<String> ignorableAnnotations) {
            this.ignorableAnnotations = new ArrayList<AnnotationMatcher>(ignorableAnnotations.size());
            for (String ignorableAnnotation : ignorableAnnotations) {
                this.ignorableAnnotations.add(new AnnotationMatcher(ignorableAnnotation));
            }
        }

        boolean hasIgnorableAnnotation(Cursor cursor) {
            AnnotationService service = (AnnotationService)HideUtilityClassConstructorVisitor.this.service(AnnotationService.class);
            for (AnnotationMatcher ignorableAnn : this.ignorableAnnotations) {
                if (!service.matches(cursor, ignorableAnn)) continue;
                return true;
            }
            return false;
        }

        boolean hasMainMethod(J.ClassDeclaration c) {
            if (c.getType() == null) {
                return false;
            }
            for (Statement statement : c.getBody().getStatements()) {
                J.MethodDeclaration md;
                if (!(statement instanceof J.MethodDeclaration) || (md = (J.MethodDeclaration)statement).isConstructor() || !md.hasModifier(J.Modifier.Type.Public) || !md.hasModifier(J.Modifier.Type.Static) || md.getReturnTypeExpression() == null || !JavaType.Primitive.Void.equals((Object)md.getReturnTypeExpression().getType()) || !new MethodMatcher(c.getType().getFullyQualifiedName() + " main(String[])").matches(md, c)) continue;
                return true;
            }
            return false;
        }

        boolean hasImplicitDefaultConstructor(J.ClassDeclaration c) {
            for (Statement statement : c.getBody().getStatements()) {
                J.MethodDeclaration methodDeclaration;
                if (!(statement instanceof J.MethodDeclaration) || !(methodDeclaration = (J.MethodDeclaration)statement).isConstructor()) continue;
                return false;
            }
            return true;
        }

        boolean isRefactorableUtilityClass(Cursor cursor) {
            J.ClassDeclaration c = (J.ClassDeclaration)cursor.getValue();
            return this.isUtilityClass(c) && !this.hasIgnorableAnnotation(cursor) && !this.hasMainMethod(c);
        }

        boolean isUtilityClass(J.ClassDeclaration c) {
            if (c.getImplements() != null || c.getExtends() != null) {
                return false;
            }
            int staticMethodCount = this.countStaticMethods(c);
            if (staticMethodCount < 0) {
                return false;
            }
            int staticFieldCount = this.countStaticFields(c);
            if (staticFieldCount < 0) {
                return false;
            }
            return staticMethodCount != 0 || staticFieldCount != 0;
        }

        private int countStaticFields(J.ClassDeclaration classDeclaration) {
            int count = 0;
            for (Statement statement : classDeclaration.getBody().getStatements()) {
                if (!(statement instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations field = (J.VariableDeclarations)statement;
                if (!field.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (field.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }

        private int countStaticMethods(J.ClassDeclaration classDeclaration) {
            int count = 0;
            for (Statement statement : classDeclaration.getBody().getStatements()) {
                J.MethodDeclaration method;
                if (!(statement instanceof J.MethodDeclaration) || (method = (J.MethodDeclaration)statement).isConstructor()) continue;
                if (!method.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (method.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }
    }

    private class UtilityClassWithImplicitDefaultConstructorVisitor
    extends JavaIsoVisitor<P> {
        private UtilityClassWithImplicitDefaultConstructorVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            if (HideUtilityClassConstructorVisitor.this.utilityClassMatcher.hasImplicitDefaultConstructor(classDecl) && !J.ClassDeclaration.Kind.Type.Enum.equals((Object)classDecl.getKind())) {
                classDecl = (J.ClassDeclaration)JavaTemplate.builder((String)"private #{}() {}").contextSensitive().build().apply(this.getCursor(), classDecl.getBody().getCoordinates().lastStatement(), new Object[]{classDecl.getSimpleName()});
            }
            return classDecl;
        }
    }

    private static class UtilityClassWithExposedConstructorInspectionVisitor<P>
    extends JavaIsoVisitor<P> {
        private final J.ClassDeclaration utilityClass;

        public UtilityClassWithExposedConstructorInspectionVisitor(J.ClassDeclaration utilityClass) {
            this.utilityClass = utilityClass;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            return classDecl == this.utilityClass ? super.visitClassDeclaration(classDecl, p) : classDecl;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, p);
            if (md.getMethodType() == null || !md.isConstructor() || md.hasModifier(J.Modifier.Type.Private) || md.hasModifier(J.Modifier.Type.Protected) || md.getMethodType().getDeclaringType().getKind().equals((Object)JavaType.FullyQualified.Kind.Enum)) {
                return md;
            }
            ChangeMethodAccessLevelVisitor changeMethodAccessLevelVisitor = new ChangeMethodAccessLevelVisitor(new MethodMatcher(method), J.Modifier.Type.Private);
            md = (J.MethodDeclaration)changeMethodAccessLevelVisitor.visit((Tree)md, p, this.getCursor().getParentOrThrow());
            assert (md != null);
            return md;
        }
    }
}

