/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs.table;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class NodeProjects
extends DataTable<Row> {
    public NodeProjects(Recipe recipe) {
        super(recipe, "Node.js projects", "Summary information about Node.js projects.");
    }

    public static final class Row {
        @Column(displayName="Name", description="The name of the package.")
        private final String name;
        @Column(displayName="Version", description="The version of the package.")
        private final String version;
        @Column(displayName="Has `package-lock.json`", description="Whether a lockfile is committed or not.")
        private final boolean hasPackageLock;

        @ConstructorProperties(value={"name", "version", "hasPackageLock"})
        @Generated
        public Row(String name, String version, boolean hasPackageLock) {
            this.name = name;
            this.version = version;
            this.hasPackageLock = hasPackageLock;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean isHasPackageLock() {
            return this.hasPackageLock;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.isHasPackageLock() != other.isHasPackageLock()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasPackageLock() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "NodeProjects.Row(name=" + this.getName() + ", version=" + this.getVersion() + ", hasPackageLock=" + this.isHasPackageLock() + ")";
        }
    }
}

