/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

public class ExplicitRecordImport
extends Recipe {
    public String getDisplayName() {
        return "Add explicit import for `Record` classes";
    }

    public String getDescription() {
        return "Add explicit import for `Record` classes when upgrading past Java 14+, to avoid conflicts with `java.lang.Record`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("*..Record", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (javaSourceFile != null) {
                    for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                        JavaType.FullyQualified ref;
                        if (!(type instanceof JavaType.FullyQualified) || !"Record".equals((ref = (JavaType.FullyQualified)type).getClassName()) || ref.getPackageName().startsWith("java.lang")) continue;
                        this.maybeAddImport(ref.getFullyQualifiedName());
                    }
                }
                return cu;
            }
        });
    }
}

