/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import java.util.Set;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class AnnotateTypesVisitor
extends JavaIsoVisitor<Set<String>> {
    private final String annotationToBeAdded;
    private final AnnotationMatcher annotationMatcher;
    private final JavaTemplate template;

    public AnnotateTypesVisitor(String annotationToBeAdded) {
        this.annotationToBeAdded = annotationToBeAdded;
        String[] split = this.annotationToBeAdded.split("\\.");
        String className = split[split.length - 1];
        String packageName = this.annotationToBeAdded.substring(0, this.annotationToBeAdded.lastIndexOf("."));
        this.annotationMatcher = new AnnotationMatcher("@" + this.annotationToBeAdded);
        String interfaceAsString = String.format("package %s\npublic @interface %s {}", packageName, className);
        this.template = JavaTemplate.builder((String)("@" + className)).imports(new String[]{this.annotationToBeAdded}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{interfaceAsString})).build();
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<String> injectedTypes) {
        J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, injectedTypes);
        if (cd.getType() != null && injectedTypes.contains(cd.getType().getFullyQualifiedName())) {
            if (cd.getLeadingAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)this.annotationMatcher).matches(arg_0))) {
                this.maybeAddImport(this.annotationToBeAdded);
                cd = (J.ClassDeclaration)this.template.apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                cd = (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)cd, (J)cd.getName(), injectedTypes, this.getCursor());
            }
        }
        return cd;
    }
}

