/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;

public final class UpdateManagedBeanToNamed
extends Recipe {
    private final String displayName = "Update Faces `@ManagedBean` to use CDI `@Named`";
    private final String description = "Faces ManagedBean was deprecated in JSF 2.3 (EE8) and removed in Jakarta Faces 4.0 (EE10). Replace `@ManagedBean` with `@Named` for CDI-based bean management.";
    private final Set<String> tags = new HashSet<String>(Arrays.asList("jakarta", "faces", "jsf"));
    private static final AnnotationMatcher MANAGED_BEAN_MATCHER = new AnnotationMatcher("*.faces.bean.ManagedBean");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Preconditions.Check((TreeVisitor)new UsesType("*.faces.bean.ManagedBean", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                Optional annotated = new Annotated.Matcher(MANAGED_BEAN_MATCHER).get(this.getCursor());
                if (annotated.isPresent()) {
                    this.maybeRemoveImport("javax.faces.bean.ManagedBean");
                    this.maybeRemoveImport("jakarta.faces.bean.ManagedBean");
                    this.maybeAddImport("jakarta.inject.Named");
                    String beanName = annotated.flatMap(a -> a.getDefaultAttribute("name")).map(name -> (String)name.getValue(String.class)).orElse(null);
                    if (beanName != null) {
                        return (J.Annotation)JavaTemplate.builder((String)"@Named(\"#{}\")").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.inject-api-2.0.1"})).imports(new String[]{"jakarta.inject.Named"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[]{beanName});
                    }
                    return (J.Annotation)JavaTemplate.builder((String)"@Named").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.inject-api-2.0.1"})).imports(new String[]{"jakarta.inject.Named"}).build().apply(this.getCursor(), annotation.getCoordinates().replace(), new Object[0]);
                }
                return annotation;
            }
        });
    }

    @Generated
    public UpdateManagedBeanToNamed() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateManagedBeanToNamed(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateManagedBeanToNamed)) {
            return false;
        }
        UpdateManagedBeanToNamed other = (UpdateManagedBeanToNamed)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateManagedBeanToNamed;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

