/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

abstract class AbstractNoGuavaImmutableOf
extends Recipe {
    private final String guavaType;
    private final String javaType;
    @Option(displayName="Whether to convert return type (the default value is false).", description="converting the return type from Guava Type to Java Type The default value is false.", example="true", required=false)
    @Nullable Boolean convertReturnType;
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(10L);

    AbstractNoGuavaImmutableOf(String guavaType, String javaType) {
        this.guavaType = guavaType;
        this.javaType = javaType;
    }

    AbstractNoGuavaImmutableOf(String guavaType, String javaType, @Nullable Boolean convertReturnType) {
        this.guavaType = guavaType;
        this.javaType = javaType;
        this.convertReturnType = convertReturnType;
    }

    private String getShortType(String fullyQualifiedType) {
        return fullyQualifiedType.substring(this.javaType.lastIndexOf(".") + 1);
    }

    public String getDisplayName() {
        return "Prefer `" + this.getShortType(this.javaType) + ".of(..)` in Java 9 or higher";
    }

    public String getDescription() {
        return "Replaces `" + this.getShortType(this.guavaType) + ".of(..)` if the returned type is immediately down-cast.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesType(this.guavaType, Boolean.valueOf(false))});
        final MethodMatcher IMMUTABLE_MATCHER = new MethodMatcher(this.guavaType + " of(..)");
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Object[] templateArguments;
                String template;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!IMMUTABLE_MATCHER.matches((MethodCall)mi) || !this.isParentTypeDownCast((MethodCall)mi)) {
                    return mi;
                }
                this.maybeRemoveImport(AbstractNoGuavaImmutableOf.this.guavaType);
                this.maybeAddImport(AbstractNoGuavaImmutableOf.this.javaType);
                List methodArguments = mi.getArguments();
                if (methodArguments.isEmpty() || methodArguments.get(0) instanceof J.Empty) {
                    template = AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType) + ".of()";
                    templateArguments = new Object[]{};
                } else if ("com.google.common.collect.ImmutableMap".equals(AbstractNoGuavaImmutableOf.this.guavaType)) {
                    template = AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType) + ".of(#{any()}, #{any()})";
                    templateArguments = new Object[]{methodArguments.get(0), methodArguments.get(1)};
                } else {
                    template = AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType) + ".of(#{any()})";
                    templateArguments = new Object[]{methodArguments.get(0)};
                }
                J.MethodInvocation m = (J.MethodInvocation)JavaTemplate.builder((String)template).imports(new String[]{AbstractNoGuavaImmutableOf.this.javaType}).build().apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments);
                m = m.getPadding().withArguments(mi.getPadding().getArguments());
                JavaType.Method newType = (JavaType.Method)this.visitType((JavaType)mi.getMethodType(), ctx);
                m = m.withMethodType(newType).withName(m.getName().withType((JavaType)newType)).withPrefix(mi.getPrefix());
                return super.visitMethodInvocation(m, (Object)ctx);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (Boolean.TRUE.equals(AbstractNoGuavaImmutableOf.this.convertReturnType) && multiVariable != mv && TypeUtils.isOfClassType((JavaType)mv.getType(), (String)AbstractNoGuavaImmutableOf.this.guavaType)) {
                    JavaType newType = JavaType.buildType((String)AbstractNoGuavaImmutableOf.this.javaType);
                    mv = mv.withTypeExpression(mv.getTypeExpression() == null ? null : this.createNewTypeExpression(mv.getTypeExpression(), newType));
                    mv = mv.withVariables(ListUtils.map((List)mv.getVariables(), variable -> {
                        JavaType.FullyQualified varType = TypeUtils.asFullyQualified((JavaType)variable.getType());
                        if (varType != null && !varType.equals(newType)) {
                            return variable.withType(newType).withName(variable.getName().withType(newType));
                        }
                        return variable;
                    }));
                }
                return mv;
            }

            private TypeTree createNewTypeExpression(TypeTree typeTree, JavaType newType) {
                if (typeTree instanceof J.ParameterizedType) {
                    J.ParameterizedType parameterizedType = (J.ParameterizedType)typeTree;
                    ArrayList jRightPaddedList = new ArrayList();
                    parameterizedType.getTypeParameters().forEach(expression -> {
                        if (expression instanceof J.ParameterizedType && TypeUtils.isOfClassType((JavaType)expression.getType(), (String)AbstractNoGuavaImmutableOf.this.guavaType)) {
                            jRightPaddedList.add(JRightPadded.build((Object)((J.ParameterizedType)this.createNewTypeExpression((TypeTree)expression, newType))));
                        } else {
                            jRightPaddedList.add(JRightPadded.build((Object)expression));
                        }
                    });
                    J.Identifier clazz = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType), null, null);
                    return parameterizedType.withClazz((NameTree)clazz).withType(newType).getPadding().withTypeParameters(JContainer.build(jRightPaddedList));
                }
                return new J.Identifier(typeTree.getId(), typeTree.getPrefix(), Markers.EMPTY, Collections.emptyList(), AbstractNoGuavaImmutableOf.this.getShortType(AbstractNoGuavaImmutableOf.this.javaType), newType, null);
            }

            private boolean isParentTypeDownCast(MethodCall immutableMethod) {
                J parent = (J)this.getCursor().dropParentUntil(J.class::isInstance).getValue();
                boolean isParentTypeDownCast = false;
                if (parent instanceof J.VariableDeclarations.NamedVariable) {
                    isParentTypeDownCast = this.isParentTypeMatched(((J.VariableDeclarations.NamedVariable)parent).getType());
                } else if (parent instanceof J.Assignment) {
                    J.Assignment a = (J.Assignment)parent;
                    if (a.getVariable() instanceof J.Identifier && ((J.Identifier)a.getVariable()).getFieldType() != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(((J.Identifier)a.getVariable()).getFieldType().getType());
                    } else if (a.getVariable() instanceof J.FieldAccess) {
                        isParentTypeDownCast = this.isParentTypeMatched(a.getVariable().getType());
                    }
                } else if (parent instanceof J.Return) {
                    TypeTree returnType;
                    J j = (J)this.getCursor().dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.CompilationUnit).getValue();
                    if (j instanceof J.MethodDeclaration && (returnType = ((J.MethodDeclaration)j).getReturnTypeExpression()) != null) {
                        isParentTypeDownCast = this.isParentTypeMatched(returnType.getType());
                    }
                } else if (parent instanceof J.MethodInvocation) {
                    J.MethodInvocation m = (J.MethodInvocation)parent;
                    int index = m.getArguments().indexOf(immutableMethod);
                    if (m.getMethodType() != null) {
                        isParentTypeDownCast = index != -1 && !m.getMethodType().getParameterTypes().isEmpty() ? this.isParentTypeMatched((JavaType)m.getMethodType().getParameterTypes().get(index)) : !TypeUtils.isOfClassType((JavaType)m.getMethodType().getReturnType(), (String)AbstractNoGuavaImmutableOf.this.guavaType);
                    }
                } else if (parent instanceof J.NewClass) {
                    J.NewClass c = (J.NewClass)parent;
                    int index = 0;
                    if (c.getConstructorType() != null) {
                        Expression argument;
                        Iterator iterator = c.getArguments().iterator();
                        while (iterator.hasNext() && !IMMUTABLE_MATCHER.matches(argument = (Expression)iterator.next())) {
                            ++index;
                        }
                        if (c.getConstructorType() != null) {
                            isParentTypeDownCast = this.isParentTypeMatched((JavaType)c.getConstructorType().getParameterTypes().get(index));
                        }
                    }
                } else if (parent instanceof J.NewArray) {
                    J.NewArray a = (J.NewArray)parent;
                    JavaType arrayType = a.getType();
                    while (arrayType instanceof JavaType.Array) {
                        arrayType = ((JavaType.Array)arrayType).getElemType();
                    }
                    isParentTypeDownCast = this.isParentTypeMatched(arrayType);
                }
                return isParentTypeDownCast;
            }

            private boolean isParentTypeMatched(@Nullable JavaType type) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                return TypeUtils.isOfClassType((JavaType)fq, (String)AbstractNoGuavaImmutableOf.this.javaType) || Boolean.TRUE.equals(AbstractNoGuavaImmutableOf.this.convertReturnType) && TypeUtils.isOfClassType((JavaType)fq, (String)AbstractNoGuavaImmutableOf.this.guavaType) || TypeUtils.isOfClassType((JavaType)fq, (String)"java.lang.Object");
            }
        });
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

