/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class UseEnumSetOf
extends Recipe {
    private static final MethodMatcher SET_OF = new MethodMatcher("java.util.Set of(..)", true);
    private static final String METHOD_TYPE = "java.util.EnumSet";
    @Option(displayName="Convert empty `Set.of()` to `EnumSet.noneOf()`", description="When true, converts `Set.of()` with no arguments to `EnumSet.noneOf()`. Default true.", example="true", required=false)
    private final @Nullable Boolean convertEmptySet;
    private final String displayName = "Prefer `EnumSet of(..)`";
    private final String description = "Prefer `EnumSet of(..)` instead of using `Set of(..)` when the arguments are enums in Java 9 or higher.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SET_OF)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                Cursor parent;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if (SET_OF.matches((MethodCall)mi) && mi.getType() instanceof JavaType.Parameterized && !TypeUtils.isOfClassType((JavaType)mi.getType(), (String)UseEnumSetOf.METHOD_TYPE) && this.convertEmptySet(mi) && !((parent = this.getCursor().dropParentUntil(is -> is instanceof J.Assignment || is instanceof J.VariableDeclarations || is instanceof J.Block)).getValue() instanceof J.Block)) {
                    JavaType type;
                    JavaType javaType = type = parent.getValue() instanceof J.Assignment ? ((J.Assignment)parent.getValue()).getType() : ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parent.getValue()).getVariables().get(0)).getType();
                    if (this.isAssignmentSetOfEnum(type)) {
                        this.maybeAddImport(UseEnumSetOf.METHOD_TYPE);
                        List args = mi.getArguments();
                        if (this.isArrayParameter(args)) {
                            return mi;
                        }
                        if (args.get(0) instanceof J.Empty) {
                            JavaType firstTypeParameter = (JavaType)((JavaType.Parameterized)type).getTypeParameters().get(0);
                            JavaType.ShallowClass shallowClass = JavaType.ShallowClass.build((String)firstTypeParameter.toString());
                            return (J.MethodInvocation)JavaTemplate.builder((String)("EnumSet.noneOf(" + shallowClass.getClassName() + ".class)")).contextSensitive().imports(new String[]{UseEnumSetOf.METHOD_TYPE}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[0]);
                        }
                        StringJoiner setOf = new StringJoiner(", ", "EnumSet.of(", ")");
                        args.forEach(o -> setOf.add("#{any()}"));
                        return (J.MethodInvocation)JavaTemplate.builder((String)setOf.toString()).contextSensitive().imports(new String[]{UseEnumSetOf.METHOD_TYPE}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args.toArray());
                    }
                }
                return mi;
            }

            private boolean convertEmptySet(J.MethodInvocation mi) {
                if (UseEnumSetOf.this.convertEmptySet == null || UseEnumSetOf.this.convertEmptySet.booleanValue()) {
                    return true;
                }
                return !mi.getArguments().isEmpty() && !(mi.getArguments().get(0) instanceof J.Empty);
            }

            private boolean isAssignmentSetOfEnum(@Nullable JavaType type) {
                JavaType.Parameterized parameterized;
                if (type instanceof JavaType.Parameterized && TypeUtils.isOfClassType((JavaType)(parameterized = (JavaType.Parameterized)type).getType(), (String)"java.util.Set")) {
                    return ((JavaType.Parameterized)type).getTypeParameters().stream().filter(JavaType.Class.class::isInstance).map(JavaType.Class.class::cast).anyMatch(o -> o.getKind() == JavaType.FullyQualified.Kind.Enum);
                }
                return false;
            }

            private boolean isArrayParameter(List<Expression> args) {
                if (args.size() != 1) {
                    return false;
                }
                JavaType type = args.get(0).getType();
                return TypeUtils.asArray((JavaType)type) != null;
            }
        });
    }

    @ConstructorProperties(value={"convertEmptySet"})
    @Generated
    public UseEnumSetOf(@Nullable Boolean convertEmptySet) {
        this.convertEmptySet = convertEmptySet;
    }

    @Generated
    public @Nullable Boolean getConvertEmptySet() {
        return this.convertEmptySet;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseEnumSetOf(convertEmptySet=" + this.getConvertEmptySet() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseEnumSetOf)) {
            return false;
        }
        UseEnumSetOf other = (UseEnumSetOf)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$convertEmptySet = this.getConvertEmptySet();
        Boolean other$convertEmptySet = other.getConvertEmptySet();
        if (this$convertEmptySet == null ? other$convertEmptySet != null : !((Object)this$convertEmptySet).equals(other$convertEmptySet)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseEnumSetOf;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $convertEmptySet = this.getConvertEmptySet();
        result = result * 59 + ($convertEmptySet == null ? 43 : ((Object)$convertEmptySet).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

