/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.table.DtoDataUses;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public final class FindDataUsedOnDto
extends Recipe {
    private final transient DtoDataUses dtoDataUses = new DtoDataUses(this);
    @Option(displayName="DTO type", description="The fully qualified name of the DTO.", example="com.example.dto.*")
    private final String dtoType;
    private final String displayName = "Find data used on DTOs";
    private final String description = "Find data elements used on DTOs. This is useful to provide information where data over-fetching may be a problem.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dtoFields = new MethodMatcher(this.dtoType + " get*()");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (methodDeclaration != null && dtoFields.matches((MethodCall)method)) {
                    FindDataUsedOnDto.this.dtoDataUses.insertRow(ctx, new DtoDataUses.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), methodDeclaration.getSimpleName(), StringUtils.uncapitalize((String)method.getSimpleName().replaceAll("^get", ""))));
                    return (J.MethodInvocation)SearchResult.found((Tree)method);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    @ConstructorProperties(value={"dtoType"})
    @Generated
    public FindDataUsedOnDto(String dtoType) {
        this.dtoType = dtoType;
    }

    @Generated
    public DtoDataUses getDtoDataUses() {
        return this.dtoDataUses;
    }

    @Generated
    public String getDtoType() {
        return this.dtoType;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDataUsedOnDto(dtoDataUses=" + (Object)((Object)this.getDtoDataUses()) + ", dtoType=" + this.getDtoType() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDataUsedOnDto)) {
            return false;
        }
        FindDataUsedOnDto other = (FindDataUsedOnDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$dtoType = this.getDtoType();
        String other$dtoType = other.getDtoType();
        if (this$dtoType == null ? other$dtoType != null : !this$dtoType.equals(other$dtoType)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDataUsedOnDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dtoType = this.getDtoType();
        result = result * 59 + ($dtoType == null ? 43 : $dtoType.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

