/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class URLConstructorsToNewURI
extends Recipe {
    private static final String URI_FQN = "java.net.URI";
    private static final String URL_FQN = "java.net.URL";
    private static final MethodMatcher methodMatcherThreeArg = new MethodMatcher("java.net.URL <constructor>(java.lang.String, java.lang.String, java.lang.String)");
    private static final MethodMatcher methodMatcherFourArg = new MethodMatcher("java.net.URL <constructor>(java.lang.String, java.lang.String, int, java.lang.String)");
    final String displayName = "Convert `new URL(String, ..)` to `new URI(String, ..).toURL()`";
    final String description = "Converts `new URL(String, ..)` constructors to `new URI(String, ..).toURL()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(URL_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitNewClass(J.NewClass nc, ExecutionContext ctx) {
                if (methodMatcherThreeArg.matches((MethodCall)nc)) {
                    JavaTemplate template = JavaTemplate.builder((String)"new URI(#{any(String)}, null, #{any(String)}, -1, #{any(String)}, null, null).toURL()").imports(new String[]{URLConstructorsToNewURI.URI_FQN, URLConstructorsToNewURI.URL_FQN}).contextSensitive().javaParser(JavaParser.fromJavaVersion()).build();
                    this.maybeAddImport(URLConstructorsToNewURI.URI_FQN);
                    return template.apply(this.getCursor(), nc.getCoordinates().replace(), new Object[]{nc.getArguments().get(0), nc.getArguments().get(1), nc.getArguments().get(2)});
                }
                if (methodMatcherFourArg.matches((MethodCall)nc)) {
                    JavaTemplate template = JavaTemplate.builder((String)"new URI(#{any(String)}, null, #{any(String)}, #{any(int)}, #{any(String)}, null, null).toURL()").imports(new String[]{URLConstructorsToNewURI.URI_FQN, URLConstructorsToNewURI.URL_FQN}).contextSensitive().javaParser(JavaParser.fromJavaVersion()).build();
                    this.maybeAddImport(URLConstructorsToNewURI.URI_FQN);
                    return template.apply(this.getCursor(), nc.getCoordinates().replace(), new Object[]{nc.getArguments().get(0), nc.getArguments().get(1), nc.getArguments().get(2), nc.getArguments().get(3)});
                }
                return super.visitNewClass(nc, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

