/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Comparator;
import lombok.AccessLevel;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class UseNoArgsConstructor
extends Recipe {
    private final String displayName = "Use `@NoArgsConstructor` where applicable";
    private final String description = "Prefer the Lombok `@NoArgsConstructor` annotation over explicitly written out constructors.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (method.isConstructor() && !method.getMarkers().findFirst(CompactConstructor.class).isPresent() && method.getParameters().get(0) instanceof J.Empty && method.getBody() != null && method.getBody().getStatements().isEmpty()) {
                    final J.ClassDeclaration enclosing = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                    final AccessLevel accessLevel = LombokUtils.getAccessLevel(method);
                    this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                            if (TypeUtils.isOfType((JavaType)classDecl.getType(), (JavaType)enclosing.getType())) {
                                String template = "@NoArgsConstructor" + (accessLevel == AccessLevel.PUBLIC ? "" : "(access = AccessLevel." + accessLevel.name() + ")");
                                this.maybeAddImport("lombok.AccessLevel");
                                this.maybeAddImport("lombok.NoArgsConstructor");
                                return (J.ClassDeclaration)JavaTemplate.builder((String)template).imports(new String[]{"lombok.*"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"lombok"})).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                            }
                            return super.visitClassDeclaration(classDecl, (Object)ctx);
                        }
                    });
                    return null;
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }
        };
    }

    @Generated
    public UseNoArgsConstructor() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseNoArgsConstructor(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseNoArgsConstructor)) {
            return false;
        }
        UseNoArgsConstructor other = (UseNoArgsConstructor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseNoArgsConstructor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

