/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class StringFormatted
extends Recipe {
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(String, ..)");
    @Option(displayName="Add parentheses around the first argument", description="Add parentheses around the first argument if it is not a simple expression. Default true; if false no change will be made. ", required=false)
    private final @Nullable Boolean addParentheses;
    private final String displayName = "Prefer `String.formatted(Object...)`";
    private final String description = "Prefer `String.formatted(Object...)` over `String.format(String, Object...)` in Java 17 or higher.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesMethod(STRING_FORMAT)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                methodInvocation = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if (!STRING_FORMAT.matches((MethodCall)methodInvocation) || methodInvocation.getMethodType() == null) {
                    return methodInvocation;
                }
                List arguments = methodInvocation.getArguments();
                boolean wrapperNeeded = this.wrapperNeeded((Expression)arguments.get(0));
                if (Boolean.FALSE.equals(StringFormatted.this.addParentheses) && wrapperNeeded) {
                    return methodInvocation;
                }
                this.maybeRemoveImport("java.lang.String.format");
                J.MethodInvocation mi = methodInvocation.withName(methodInvocation.getName().withSimpleName("formatted"));
                mi = mi.withMethodType((JavaType.Method)methodInvocation.getMethodType().getDeclaringType().getMethods().stream().filter(it -> "formatted".equals(it.getName())).findAny().orElse(null));
                if (mi.getName().getType() != null) {
                    mi = mi.withName(mi.getName().withType((JavaType)mi.getMethodType()));
                }
                mi = mi.withSelect((Expression)(wrapperNeeded ? new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)((Expression)arguments.get(0)))) : (Expression)((Expression)arguments.get(0)).withPrefix(Space.EMPTY)));
                if ((mi = mi.withArguments(arguments.subList(1, arguments.size()))).getArguments().isEmpty()) {
                    mi = mi.withArguments(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)));
                }
                return this.maybeAutoFormat((J)methodInvocation, (J)mi, ctx);
            }

            private boolean wrapperNeeded(Expression expression) {
                return !(expression instanceof J.Identifier) && !(expression instanceof J.Literal) && !(expression instanceof J.MethodInvocation) && !(expression instanceof J.FieldAccess);
            }
        });
    }

    @ConstructorProperties(value={"addParentheses"})
    @Generated
    public StringFormatted(@Nullable Boolean addParentheses) {
        this.addParentheses = addParentheses;
    }

    @Generated
    public @Nullable Boolean getAddParentheses() {
        return this.addParentheses;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @NonNull
    @Generated
    public String toString() {
        return "StringFormatted(addParentheses=" + this.getAddParentheses() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringFormatted)) {
            return false;
        }
        StringFormatted other = (StringFormatted)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addParentheses = this.getAddParentheses();
        Boolean other$addParentheses = other.getAddParentheses();
        if (this$addParentheses == null ? other$addParentheses != null : !((Object)this$addParentheses).equals(other$addParentheses)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        return !(this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof StringFormatted;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addParentheses = this.getAddParentheses();
        result = result * 59 + ($addParentheses == null ? 43 : ((Object)$addParentheses).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        return result;
    }
}

