/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AddMissingMethodImplementation
extends Recipe {
    @Option(displayName="Fully qualified class name", description="A fully qualified class being implemented with missing method.", example="com.yourorg.FooBar")
    private final String fullyQualifiedClassName;
    @Option(displayName="Method pattern", description="A method pattern for matching required method definition.", example="*..* hello(..)")
    private final String methodPattern;
    @Option(displayName="Method template", description="Template of method to add", example="public String hello() { return \\\"Hello from #{}!\\\"; }")
    private final String methodTemplateString;
    private final String displayName = "Adds missing method implementations";
    private final String description = "Check for missing methods required by interfaces and adds them.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.fullyQualifiedClassName, Boolean.valueOf(true)), (TreeVisitor)new ClassImplementationVisitor());
    }

    @ConstructorProperties(value={"fullyQualifiedClassName", "methodPattern", "methodTemplateString"})
    @Generated
    public AddMissingMethodImplementation(String fullyQualifiedClassName, String methodPattern, String methodTemplateString) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
        this.methodPattern = methodPattern;
        this.methodTemplateString = methodTemplateString;
    }

    @Generated
    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getMethodTemplateString() {
        return this.methodTemplateString;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddMissingMethodImplementation(fullyQualifiedClassName=" + this.getFullyQualifiedClassName() + ", methodPattern=" + this.getMethodPattern() + ", methodTemplateString=" + this.getMethodTemplateString() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMissingMethodImplementation)) {
            return false;
        }
        AddMissingMethodImplementation other = (AddMissingMethodImplementation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedClassName = this.getFullyQualifiedClassName();
        String other$fullyQualifiedClassName = other.getFullyQualifiedClassName();
        if (this$fullyQualifiedClassName == null ? other$fullyQualifiedClassName != null : !this$fullyQualifiedClassName.equals(other$fullyQualifiedClassName)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$methodTemplateString = this.getMethodTemplateString();
        String other$methodTemplateString = other.getMethodTemplateString();
        if (this$methodTemplateString == null ? other$methodTemplateString != null : !this$methodTemplateString.equals(other$methodTemplateString)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMissingMethodImplementation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedClassName = this.getFullyQualifiedClassName();
        result = result * 59 + ($fullyQualifiedClassName == null ? 43 : $fullyQualifiedClassName.hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $methodTemplateString = this.getMethodTemplateString();
        result = result * 59 + ($methodTemplateString == null ? 43 : $methodTemplateString.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public class ClassImplementationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public ClassImplementationVisitor() {
            this.methodMatcher = new MethodMatcher(AddMissingMethodImplementation.this.methodPattern, true);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cs, ExecutionContext ctx) {
            J.ClassDeclaration classDecl = super.visitClassDeclaration(cs, (Object)ctx);
            if (classDecl.hasModifier(J.Modifier.Type.Abstract) || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                return classDecl;
            }
            if (!TypeUtils.isAssignableTo((String)AddMissingMethodImplementation.this.fullyQualifiedClassName, (JavaType)classDecl.getType())) {
                return classDecl;
            }
            if (classDecl.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).anyMatch(methodDeclaration -> this.methodMatcher.matches(methodDeclaration, classDecl))) {
                return classDecl;
            }
            return classDecl.withBody((J.Block)JavaTemplate.builder((String)AddMissingMethodImplementation.this.methodTemplateString).build().apply(new Cursor(this.getCursor(), (Object)classDecl.getBody()), classDecl.getBody().getCoordinates().lastStatement(), new Object[0]));
        }
    }
}

