/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class RemoveEmbeddableId
extends ScanningRecipe<Accumulator> {
    public String getDisplayName() {
        return "`@Embeddable` classes cannot have an `@Id` annotation when referenced by an `@EmbeddedId` annotation";
    }

    public String getDescription() {
        return "According to the Java Persistence API (JPA) specification, if an entity defines an attribute with an `@EmbeddedId` annotation, the embeddable class cannot contain an attribute with an `@Id` annotation. If both the `@EmbeddedId` annotation and the `@Id` annotation are defined, OpenJPA ignores the `@Id` annotation, whereas EclipseLink throws an exception.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return Preconditions.check((TreeVisitor)new UsesType("javax.persistence.EmbeddedId", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                if (!FindAnnotations.find((J)cd, (String)"@javax.persistence.Entity").isEmpty()) {
                    return super.visitClassDeclaration(cd, (Object)ctx);
                }
                return cd;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (FindAnnotations.find((J)multiVariable, (String)"@javax.persistence.EmbeddedId").isEmpty()) {
                    return multiVariable;
                }
                JavaType type = multiVariable.getType();
                if (type != null) {
                    acc.addClass(type);
                }
                return multiVariable;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Embeddable", Boolean.valueOf(true)), new UsesType("javax.persistence.Id", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!FindAnnotations.find((J)classDecl, (String)"@javax.persistence.Embeddable").isEmpty() && acc.isEmbeddableClass((JavaType)classDecl.getType())) {
                    classDecl = new RemoveAnnotation("javax.persistence.Id").getVisitor().visitClassDeclaration(classDecl, ctx);
                    this.maybeRemoveImport("javax.persistence.Id");
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        });
    }

    public static class Accumulator {
        private final Set<JavaType> definedEmbeddableClasses = new HashSet<JavaType>();

        public void addClass(JavaType type) {
            this.definedEmbeddableClasses.add(type);
        }

        public boolean isEmbeddableClass(@Nullable JavaType type) {
            return this.definedEmbeddableClasses.stream().anyMatch(emb -> type.equals(emb) || type.isAssignableFrom(Pattern.compile(((JavaType.Class)emb).getFullyQualifiedName())));
        }
    }
}

