/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class UpdateSdkMan
extends Recipe {
    @Option(displayName="Java version", description="The Java version to update to.", required=false, example="17")
    private final @Nullable String newVersion;
    @Option(displayName="Distribution", description="The JVM distribution to use.", required=false, example="tem")
    private final @Nullable String newDistribution;

    public String getDisplayName() {
        return "Update SDKMan Java version";
    }

    public String getDescription() {
        return "Update the SDKMAN JDK version in the `.sdkmanrc` file. Given a major release (e.g., 17), the recipe will update the current distribution to the current default SDKMAN version of the specified major release. The distribution option can be used to specify a specific JVM distribution. Note that these must correspond to valid SDKMAN distributions.";
    }

    public Validated<Object> validate(ExecutionContext ctx) {
        return super.validate(ctx).and(Validated.required((String)"newVersion", (Object)this.newVersion).or(Validated.required((String)"newDistribution", (Object)this.newDistribution)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert((SourceFile)sourceFile);
                Pattern pattern = Pattern.compile("java=(.*?)([.a-z]*-.*)");
                Matcher matcher = pattern.matcher(plainText.getText());
                if (matcher.find()) {
                    String ver = UpdateSdkMan.this.newVersion == null ? matcher.group(1) : UpdateSdkMan.this.newVersion;
                    String dist = UpdateSdkMan.this.newDistribution == null ? matcher.group(2) : "-" + UpdateSdkMan.this.newDistribution;
                    String newBasis = ver + dist;
                    Pattern majorPattern = Pattern.compile("^" + ver + "[.-].*");
                    LatestRelease releaseComparator = new LatestRelease(dist);
                    String idealCandidate = this.readSdkmanJavaCandidates().stream().filter(candidate -> majorPattern.matcher((CharSequence)candidate).matches()).filter(candidate -> releaseComparator.isValid(newBasis, candidate)).max((Comparator<String>)releaseComparator).orElse(null);
                    if (idealCandidate != null && !this.isRequestedDowngrade(matcher.group(1) + dist, idealCandidate, dist)) {
                        return plainText.withText(matcher.replaceFirst("java=" + idealCandidate));
                    }
                }
                return sourceFile;
            }

            private boolean isRequestedDowngrade(String currentVersionWithNewDist, String requestedVersionWithDist, String dist) {
                return new LatestRelease(dist).compare(null, currentVersionWithNewDist, requestedVersionWithDist) > 0;
            }

            /*
             * Exception decompiling
             */
            private List<String> readSdkmanJavaCandidates() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        return Preconditions.check((Recipe)new FindSourceFiles(".sdkmanrc"), (TreeVisitor)visitor);
    }

    @ConstructorProperties(value={"newVersion", "newDistribution"})
    @Generated
    public UpdateSdkMan(@Nullable String newVersion, @Nullable String newDistribution) {
        this.newVersion = newVersion;
        this.newDistribution = newDistribution;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getNewDistribution() {
        return this.newDistribution;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpdateSdkMan(newVersion=" + this.getNewVersion() + ", newDistribution=" + this.getNewDistribution() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateSdkMan)) {
            return false;
        }
        UpdateSdkMan other = (UpdateSdkMan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$newDistribution = this.getNewDistribution();
        String other$newDistribution = other.getNewDistribution();
        return !(this$newDistribution == null ? other$newDistribution != null : !this$newDistribution.equals(other$newDistribution));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateSdkMan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $newDistribution = this.getNewDistribution();
        result = result * 59 + ($newDistribution == null ? 43 : $newDistribution.hashCode());
        return result;
    }
}

