/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.beans.ConstructorProperties;
import java.util.Comparator;
import lombok.AccessLevel;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

final class FieldAnnotator
extends JavaIsoVisitor<ExecutionContext> {
    private final Class<?> annotation;
    private final JavaType field;
    private final AccessLevel accessLevel;

    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
        for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
            if (variable.getName().getFieldType() != this.field) continue;
            this.maybeAddImport(this.annotation.getName());
            this.maybeAddImport("lombok.AccessLevel");
            String suffix = this.accessLevel == AccessLevel.PUBLIC ? "" : String.format("(AccessLevel.%s)", this.accessLevel.name());
            return (J.VariableDeclarations)JavaTemplate.builder((String)("@" + this.annotation.getSimpleName() + suffix)).imports(new String[]{this.annotation.getName(), "lombok.AccessLevel"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"lombok"})).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
        }
        return multiVariable;
    }

    @ConstructorProperties(value={"annotation", "field", "accessLevel"})
    @Generated
    public FieldAnnotator(Class<?> annotation, JavaType field, AccessLevel accessLevel) {
        this.annotation = annotation;
        this.field = field;
        this.accessLevel = accessLevel;
    }

    @Generated
    public Class<?> getAnnotation() {
        return this.annotation;
    }

    @Generated
    public JavaType getField() {
        return this.field;
    }

    @Generated
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FieldAnnotator(annotation=" + this.getAnnotation() + ", field=" + this.getField() + ", accessLevel=" + this.getAccessLevel() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldAnnotator)) {
            return false;
        }
        FieldAnnotator other = (FieldAnnotator)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Class<?> this$annotation = this.getAnnotation();
        Class<?> other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        JavaType this$field = this.getField();
        JavaType other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        AccessLevel this$accessLevel = this.getAccessLevel();
        AccessLevel other$accessLevel = other.getAccessLevel();
        return !(this$accessLevel == null ? other$accessLevel != null : !this$accessLevel.equals(other$accessLevel));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FieldAnnotator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
        JavaType $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        AccessLevel $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : $accessLevel.hashCode());
        return result;
    }
}

