/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.SwitchExpressionYieldToArrow;
import org.openrewrite.java.migrate.lang.SwitchUtils;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.InlineVariable;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class SwitchCaseAssignmentsToSwitchExpression
extends Recipe {
    public String getDisplayName() {
        return "Convert assigning Switch statements to Switch expressions";
    }

    public String getDescription() {
        return "Switch statements for which each case is assigning a value to the same variable can be converted to a switch expression that returns the value of the variable. This is only applicable for Java 17 and later.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), Preconditions.not((TreeVisitor)new KotlinFileChecker()), Preconditions.not((TreeVisitor)new GroovyFileChecker())});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block originalBlock, ExecutionContext ctx) {
                J.Block block = super.visitBlock(originalBlock, (Object)ctx);
                AtomicReference<@Nullable V> originalSwitch = new AtomicReference();
                int lastIndex = block.getStatements().size() - 1;
                return block.withStatements(ListUtils.map((List)block.getStatements(), (index, statement) -> {
                    if (statement == originalSwitch.getAndSet(null)) {
                        this.doAfterVisit(new InlineVariable().getVisitor());
                        this.doAfterVisit(new SwitchExpressionYieldToArrow().getVisitor());
                        return null;
                    }
                    if (index < lastIndex && statement instanceof J.VariableDeclarations && ((J.VariableDeclarations)statement).getVariables().size() == 1 && !this.canHaveSideEffects(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)statement).getVariables().get(0)).getInitializer()) && block.getStatements().get(index + 1) instanceof J.Switch) {
                        J.VariableDeclarations.NamedVariable originalVariable;
                        J.VariableDeclarations vd = (J.VariableDeclarations)statement;
                        J.Switch nextStatementSwitch = (J.Switch)block.getStatements().get(index + 1);
                        J.SwitchExpression newSwitchExpression = this.buildNewSwitchExpression(nextStatementSwitch, originalVariable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0));
                        if (newSwitchExpression != null) {
                            originalSwitch.set(nextStatementSwitch);
                            return (Statement)vd.withVariables(Collections.singletonList(originalVariable.getPadding().withInitializer(JLeftPadded.build((Object)newSwitchExpression).withBefore(Space.SINGLE_SPACE)))).withComments(ListUtils.concatAll((List)vd.getComments(), (List)nextStatementSwitch.getComments()));
                        }
                    }
                    return statement;
                }));
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.SwitchExpression buildNewSwitchExpression(J.Switch originalSwitch, J.VariableDeclarations.NamedVariable originalVariable) {
                J.Identifier originalVariableId = originalVariable.getName();
                AtomicBoolean isQualified = new AtomicBoolean(true);
                AtomicBoolean isDefaultCaseAbsent = new AtomicBoolean(true);
                AtomicBoolean isUsingArrows = new AtomicBoolean(true);
                AtomicBoolean isLastCaseEmpty = new AtomicBoolean(false);
                List updatedCases = ListUtils.map((List)originalSwitch.getCases().getStatements(), (index, s) -> {
                    if (!isQualified.get()) {
                        return null;
                    }
                    J.Case caseItem = (J.Case)s;
                    if (caseItem.getCaseLabels().get(0) instanceof J.Identifier && "default".equals(((J.Identifier)caseItem.getCaseLabels().get(0)).getSimpleName())) {
                        isDefaultCaseAbsent.set(false);
                    }
                    if (caseItem.getBody() != null) {
                        J.Assignment assignment;
                        J caseBody = caseItem.getBody();
                        if (caseBody instanceof J.Block && ((J.Block)caseBody).getStatements().size() == 1) {
                            caseBody = (J)((J.Block)caseBody).getStatements().get(0);
                        }
                        if ((assignment = this.extractAssignmentOfVariable(caseBody, originalVariableId)) != null) {
                            return caseItem.withBody((J)assignment.getAssignment());
                        }
                    } else {
                        isUsingArrows.set(false);
                        boolean isLastCase = index + 1 == originalSwitch.getCases().getStatements().size();
                        List caseStatements = caseItem.getStatements();
                        if (caseStatements.isEmpty()) {
                            if (isLastCase) {
                                isLastCaseEmpty.set(true);
                            }
                            return caseItem;
                        }
                        J.Assignment assignment = this.extractAssignmentFromColonCase(caseStatements, isLastCase, originalVariableId);
                        if (assignment != null) {
                            J.Yield yieldStatement = new J.Yield(Tree.randomId(), assignment.getPrefix().withWhitespace(" "), Markers.EMPTY, false, assignment.getAssignment());
                            return caseItem.withStatements(Collections.singletonList(yieldStatement));
                        }
                    }
                    isQualified.set(false);
                    return null;
                });
                if (!isQualified.get()) {
                    return null;
                }
                boolean shouldAddDefaultCase = isDefaultCaseAbsent.get() && !SwitchUtils.coversAllPossibleValues(originalSwitch);
                Expression originalInitializer = originalVariable.getInitializer();
                if (originalInitializer == null && shouldAddDefaultCase || isLastCaseEmpty.get() && !shouldAddDefaultCase) {
                    return null;
                }
                if (shouldAddDefaultCase) {
                    updatedCases.add(this.createDefaultCase(originalSwitch, (Expression)originalInitializer.withPrefix(Space.SINGLE_SPACE), isUsingArrows.get()));
                }
                return new J.SwitchExpression(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, originalSwitch.getSelector(), originalSwitch.getCases().withStatements(updatedCases), originalVariable.getType());
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Assignment extractAssignmentFromColonCase(List<Statement> caseStatements, boolean isLastCase, J.Identifier variableId) {
                if (caseStatements.size() == 1 && caseStatements.get(0) instanceof J.Block) {
                    caseStatements = ((J.Block)caseStatements.get(0)).getStatements();
                }
                if (caseStatements.size() == 2 && caseStatements.get(1) instanceof J.Break || caseStatements.size() == 1 && isLastCase) {
                    return this.extractAssignmentOfVariable((J)caseStatements.get(0), variableId);
                }
                return null;
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Assignment extractAssignmentOfVariable(J maybeAssignment, J.Identifier variableId) {
                J.Identifier variable;
                J.Assignment assignment;
                if (maybeAssignment instanceof J.Assignment && (assignment = (J.Assignment)maybeAssignment).getVariable() instanceof J.Identifier && SemanticallyEqual.areEqual((J)(variable = (J.Identifier)assignment.getVariable()), (J)variableId) && !this.containsIdentifier(variableId, assignment.getAssignment())) {
                    return assignment;
                }
                return null;
            }

            private J.Case createDefaultCase(J.Switch originalSwitch, Expression returnedExpression, boolean arrow) {
                J.Switch switchStatement = (J.Switch)JavaTemplate.apply((String)("switch(1) { default" + (arrow ? " ->" : ": yield") + " #{any()}; }"), (Cursor)new Cursor(this.getCursor(), (Object)originalSwitch), (JavaCoordinates)originalSwitch.getCoordinates().replace(), (Object[])new Object[]{returnedExpression});
                return (J.Case)switchStatement.getCases().getStatements().get(0);
            }

            private boolean containsIdentifier(final J.Identifier identifier, Expression expression) {
                return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.Identifier visitIdentifier(J.Identifier id, AtomicBoolean found) {
                        if (SemanticallyEqual.areEqual((J)id, (J)identifier)) {
                            found.set(true);
                            return id;
                        }
                        return super.visitIdentifier(id, (Object)found);
                    }
                }.reduce((Tree)expression, (Object)new AtomicBoolean())).get();
            }

            private boolean canHaveSideEffects(@Nullable Expression expression) {
                if (expression == null) {
                    return false;
                }
                return ((AtomicBoolean)new JavaIsoVisitor<AtomicBoolean>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean found) {
                        found.set(true);
                        return super.visitAssignment(assignment, (Object)found);
                    }

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean found) {
                        found.set(true);
                        return method;
                    }

                    public J.NewClass visitNewClass(J.NewClass newClass, AtomicBoolean found) {
                        found.set(true);
                        return newClass;
                    }

                    public J.Unary visitUnary(J.Unary unary, AtomicBoolean found) {
                        found.set(true);
                        return super.visitUnary(unary, (Object)found);
                    }

                    private boolean isToStringImplicitlyCalled(Expression a, Expression b) {
                        if (TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)a.getType()) && TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)b.getType())) {
                            return false;
                        }
                        if (b.getType() == null) {
                            return true;
                        }
                        return a.getType() == JavaType.Primitive.String && !(b.getType() instanceof JavaType.Primitive) && !b.getType().toString().startsWith("java.lang") && !TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)b.getType());
                    }

                    public J.Binary visitBinary(J.Binary binary, AtomicBoolean found) {
                        if (this.isToStringImplicitlyCalled(binary.getLeft(), binary.getRight()) || this.isToStringImplicitlyCalled(binary.getRight(), binary.getLeft())) {
                            found.set(true);
                            return binary;
                        }
                        return super.visitBinary(binary, (Object)found);
                    }
                }.reduce((Tree)expression, (Object)new AtomicBoolean())).get();
            }
        });
    }

    @Generated
    public SwitchCaseAssignmentsToSwitchExpression() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "SwitchCaseAssignmentsToSwitchExpression()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchCaseAssignmentsToSwitchExpression)) {
            return false;
        }
        SwitchCaseAssignmentsToSwitchExpression other = (SwitchCaseAssignmentsToSwitchExpression)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SwitchCaseAssignmentsToSwitchExpression;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

