/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import fj.data.Option;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.joda.JodaTimeFlowSpec;
import org.openrewrite.java.migrate.joda.JodaTimeRecipe;
import org.openrewrite.java.migrate.joda.JodaTimeVisitor;
import org.openrewrite.java.migrate.joda.SafeCheckMarker;
import org.openrewrite.java.migrate.joda.ScopeAwareVisitor;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;

class JodaTimeScanner
extends ScopeAwareVisitor {
    private final JodaTimeRecipe.Accumulator acc;
    private final Map<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>> varDependencies = new HashMap<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>>();
    private final Map<JavaType, Set<String>> unsafeVarsByType = new HashMap<JavaType, Set<String>>();
    private final Map<JavaType.Method, Set<J.VariableDeclarations.NamedVariable>> methodReferencedVars = new HashMap<JavaType.Method, Set<J.VariableDeclarations.NamedVariable>>();
    private final Map<JavaType.Method, Set<UnresolvedVar>> methodUnresolvedReferencedVars = new HashMap<JavaType.Method, Set<UnresolvedVar>>();

    public JodaTimeScanner(JodaTimeRecipe.Accumulator acc) {
        super(new LinkedList<ScopeAwareVisitor.VariablesInScope>());
        this.acc = acc;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
        super.visitCompilationUnit(cu, (Object)ctx);
        HashSet<J.VariableDeclarations.NamedVariable> allReachable = new HashSet<J.VariableDeclarations.NamedVariable>();
        for (J.VariableDeclarations.NamedVariable var : this.acc.getUnsafeVars()) {
            this.dfs(var, allReachable);
        }
        this.acc.getUnsafeVars().addAll(allReachable);
        HashSet unsafeMethods = new HashSet();
        this.acc.getSafeMethodMap().forEach((method, isSafe) -> {
            if (!isSafe.booleanValue()) {
                unsafeMethods.add(method);
                return;
            }
            HashSet intersection = new HashSet(this.methodReferencedVars.getOrDefault(method, Collections.emptySet()));
            intersection.retainAll(this.acc.getUnsafeVars());
            if (!intersection.isEmpty()) {
                unsafeMethods.add(method);
            }
        });
        for (JavaType.Method method2 : unsafeMethods) {
            this.acc.getSafeMethodMap().put(method2, false);
            this.acc.getUnsafeVars().addAll(this.methodReferencedVars.getOrDefault(method2, Collections.emptySet()));
        }
        return cu;
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
        if (!variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitVariable(variable, (Object)ctx);
        }
        if (this.isClassVar(variable)) {
            this.acc.getUnsafeVars().add(variable);
            return variable;
        }
        if (!(variable = (J.VariableDeclarations.NamedVariable)super.visitVariable(variable, (Object)ctx)).getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return variable;
        }
        boolean isMethodParam = this.getCursor().getParentTreeCursor().getParentTreeCursor().getValue() instanceof J.MethodDeclaration;
        Cursor cursor = null;
        if (isMethodParam) {
            cursor = this.getCursor();
        } else if (variable.getInitializer() != null) {
            cursor = new Cursor(this.getCursor(), (Object)variable.getInitializer());
        }
        if (cursor == null) {
            return variable;
        }
        List<Expression> sinks = this.findSinks(cursor);
        Cursor currentScope = this.getCurrentScope();
        new AddSafeCheckMarker(sinks).visit((Tree)currentScope.getValue(), ctx, currentScope.getParentOrThrow());
        this.processMarkersOnExpression(sinks, variable);
        return variable;
    }

    public J visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
        Expression var = assignment.getVariable();
        if (!JodaTimeScanner.isJodaExpr(var) || !(var instanceof J.Identifier)) {
            return super.visitAssignment(assignment, (Object)ctx);
        }
        J.Identifier ident = (J.Identifier)var;
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(ident.getSimpleName());
        if (!mayBeVar.isPresent()) {
            return super.visitAssignment(assignment, (Object)ctx);
        }
        J.VariableDeclarations.NamedVariable variable = mayBeVar.get();
        Cursor varScope = this.findScope(variable);
        List<Expression> sinks = this.findSinks(new Cursor(this.getCursor(), (Object)assignment.getAssignment()));
        new AddSafeCheckMarker(sinks).visit((Tree)varScope.getValue(), ctx, varScope.getParentOrThrow());
        this.processMarkersOnExpression(sinks, variable);
        return super.visitAssignment(assignment, (Object)ctx);
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        this.acc.getVarTable().addVars(method);
        this.unsafeVarsByType.getOrDefault(method.getMethodType(), Collections.emptySet()).forEach(varName -> {
            J.VariableDeclarations.NamedVariable var = this.acc.getVarTable().getVarByName((JavaType)method.getMethodType(), (String)varName);
            if (var != null) {
                this.acc.getUnsafeVars().add(var);
            }
        });
        Set<UnresolvedVar> unresolvedVars = this.methodUnresolvedReferencedVars.remove(method.getMethodType());
        if (unresolvedVars != null) {
            unresolvedVars.forEach(var -> {
                J.VariableDeclarations.NamedVariable namedVar = this.acc.getVarTable().getVarByName(var.getDeclaringType(), var.getVarName());
                if (namedVar != null) {
                    this.methodReferencedVars.computeIfAbsent(method.getMethodType(), k -> new HashSet()).add(namedVar);
                }
            });
        }
        return super.visitMethodDeclaration(method, (Object)ctx);
    }

    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.Assignment assignment;
        if (!JodaTimeScanner.isJodaExpr((Expression)method) || method.getMethodType().getDeclaringType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitMethodInvocation(method, (Object)ctx);
        }
        Cursor boundary = JodaTimeScanner.findBoundaryCursorForJodaExpr(this.getCursor());
        J j = (J)new JodaTimeVisitor(new JodaTimeRecipe.Accumulator(), false, this.scopes).visit((Tree)boundary.getValue(), ctx, boundary.getParentTreeCursor());
        boolean isSafe = j != boundary.getValue();
        this.acc.getSafeMethodMap().compute(method.getMethodType(), (k, v) -> v == null ? isSafe : v != false && isSafe);
        J parent = (J)boundary.getParentTreeCursor().getValue();
        if (parent instanceof J.VariableDeclarations.NamedVariable) {
            this.methodReferencedVars.computeIfAbsent(method.getMethodType(), k -> new HashSet()).add((J.VariableDeclarations.NamedVariable)parent);
        }
        if (parent instanceof J.Assignment && (assignment = (J.Assignment)parent).getVariable() instanceof J.Identifier) {
            J.Identifier ident = (J.Identifier)assignment.getVariable();
            this.findVarInScope(ident.getSimpleName()).map(var -> this.methodReferencedVars.computeIfAbsent(method.getMethodType(), k -> new HashSet()).add(var));
        }
        if (parent instanceof MethodCall) {
            MethodCall parentMethod = (MethodCall)parent;
            int argPos = parentMethod.getArguments().indexOf(boundary.getValue());
            if (argPos == -1) {
                return method;
            }
            String paramName = (String)parentMethod.getMethodType().getParameterNames().get(argPos);
            J.VariableDeclarations.NamedVariable var2 = this.acc.getVarTable().getVarByName((JavaType)parentMethod.getMethodType(), paramName);
            if (var2 != null) {
                this.methodReferencedVars.computeIfAbsent(method.getMethodType(), k -> new HashSet()).add(var2);
            } else {
                this.methodUnresolvedReferencedVars.computeIfAbsent(method.getMethodType(), k -> new HashSet()).add(new UnresolvedVar((JavaType)parentMethod.getMethodType(), paramName));
            }
        }
        return method;
    }

    public J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
        if (_return.getExpression() == null) {
            return _return;
        }
        Expression expr = _return.getExpression();
        if (!JodaTimeScanner.isJodaExpr(expr)) {
            return _return;
        }
        J methodOrLambda = (J)this.getCursor().dropParentUntil(j -> j instanceof J.MethodDeclaration || j instanceof J.Lambda).getValue();
        if (methodOrLambda instanceof J.Lambda) {
            return _return;
        }
        J.MethodDeclaration method = (J.MethodDeclaration)methodOrLambda;
        Expression updatedExpr = (Expression)new JodaTimeVisitor(this.acc, true, this.scopes).visit((Tree)expr, ctx, this.getCursor().getParentTreeCursor());
        boolean isSafe = !JodaTimeScanner.isJodaExpr(updatedExpr);
        this.addReferencedVars(expr, method.getMethodType());
        this.acc.getSafeMethodMap().compute(method.getMethodType(), (k, v) -> v == null ? isSafe : v != false && isSafe);
        if (!isSafe) {
            this.acc.getUnsafeVars().addAll((Collection<J.VariableDeclarations.NamedVariable>)this.methodReferencedVars.get(method.getMethodType()));
        }
        return _return;
    }

    private void processMarkersOnExpression(List<Expression> expressions, J.VariableDeclarations.NamedVariable var) {
        for (Expression expr : expressions) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (!mayBeMarker.isPresent()) continue;
            SafeCheckMarker marker = (SafeCheckMarker)mayBeMarker.get();
            if (!marker.isSafe()) {
                this.acc.getUnsafeVars().add(var);
            }
            if (marker.getReferences().isEmpty()) continue;
            this.varDependencies.compute(var, (k, v) -> v == null ? new HashSet() : v).addAll(marker.getReferences());
            for (J.VariableDeclarations.NamedVariable ref : marker.getReferences()) {
                this.varDependencies.compute(ref, (k, v) -> v == null ? new HashSet() : v).add(var);
            }
        }
    }

    private static Cursor findBoundaryCursorForJodaExpr(Cursor cursor) {
        while (cursor.getValue() instanceof Expression && JodaTimeScanner.isJodaExpr((Expression)cursor.getValue())) {
            Cursor parent = cursor.getParentTreeCursor();
            if (parent.getValue() instanceof J && !(parent.getValue() instanceof Expression)) {
                return cursor;
            }
            cursor = parent;
        }
        return cursor;
    }

    private static boolean isJodaExpr(Expression expression) {
        return expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN);
    }

    private List<Expression> findSinks(Cursor cursor) {
        Option mayBeSinks = Dataflow.startingAt((Cursor)cursor).findSinks((DataFlowSpec)new JodaTimeFlowSpec());
        if (mayBeSinks.isNone()) {
            return Collections.emptyList();
        }
        return ((SinkFlowSummary)mayBeSinks.some()).getExpressionSinks();
    }

    private boolean isClassVar(J.VariableDeclarations.NamedVariable variable) {
        return variable.getVariableType().getOwner() instanceof JavaType.Class;
    }

    private void dfs(J.VariableDeclarations.NamedVariable root, Set<J.VariableDeclarations.NamedVariable> visited) {
        if (visited.contains(root)) {
            return;
        }
        visited.add(root);
        for (J.VariableDeclarations.NamedVariable dep : this.varDependencies.getOrDefault(root, Collections.emptySet())) {
            this.dfs(dep, visited);
        }
    }

    private void addReferencedVars(Expression expr, JavaType.Method method) {
        HashSet<@Nullable E> referencedVars = new HashSet();
        new FindVarReferences().visit((Tree)expr, referencedVars, this.getCursor().getParentTreeCursor());
        referencedVars.remove(null);
        this.methodReferencedVars.computeIfAbsent(method, k -> new HashSet()).addAll(referencedVars);
    }

    @Generated
    public JodaTimeRecipe.Accumulator getAcc() {
        return this.acc;
    }

    private class AddSafeCheckMarker
    extends JavaIsoVisitor<ExecutionContext> {
        @NonNull
        private List<Expression> expressions;

        public Expression visitExpression(Expression expression, ExecutionContext ctx) {
            Optional<Cursor> mayBeArgCursor;
            int index = this.expressions.indexOf(expression);
            if (index == -1) {
                return super.visitExpression(expression, (Object)ctx);
            }
            SafeCheckMarker marker = this.getMarker(expression, ctx);
            if (!marker.isSafe() && (mayBeArgCursor = this.findArgumentExprCursor()).isPresent()) {
                MethodCall parentMethod = (MethodCall)mayBeArgCursor.get().getParentTreeCursor().getValue();
                int argPos = parentMethod.getArguments().indexOf(mayBeArgCursor.get().getValue());
                String paramName = (String)parentMethod.getMethodType().getParameterNames().get(argPos);
                JodaTimeScanner.this.unsafeVarsByType.computeIfAbsent(parentMethod.getMethodType(), k -> new HashSet()).add(paramName);
            }
            Expression withMarker = (Expression)expression.withMarkers(expression.getMarkers().addIfAbsent((Marker)marker));
            this.expressions.set(index, withMarker);
            return withMarker;
        }

        private SafeCheckMarker getMarker(Expression expr, ExecutionContext ctx) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (mayBeMarker.isPresent()) {
                return (SafeCheckMarker)mayBeMarker.get();
            }
            Cursor boundary = JodaTimeScanner.findBoundaryCursorForJodaExpr(this.getCursor());
            boolean isSafe = true;
            if (boundary.getParentTreeCursor().getValue() instanceof J.Return) {
                isSafe = boundary.dropParentUntil(j -> j instanceof J.MethodDeclaration || j instanceof J.Lambda).getValue() instanceof J.MethodDeclaration;
            }
            Expression boundaryExpr = (Expression)boundary.getValue();
            J j2 = (J)new JodaTimeVisitor(new JodaTimeRecipe.Accumulator(), false, JodaTimeScanner.this.scopes).visit((Tree)boundaryExpr, ctx, boundary.getParentTreeCursor());
            HashSet<// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations.NamedVariable> referencedVars = new HashSet<J.VariableDeclarations.NamedVariable>();
            new FindVarReferences().visit((Tree)expr, referencedVars, this.getCursor().getParentTreeCursor());
            AtomicBoolean hasJodaType = new AtomicBoolean();
            new HasJodaType().visit((Tree)j2, hasJodaType);
            isSafe = isSafe && !hasJodaType.get() && !referencedVars.contains(null);
            referencedVars.remove(null);
            return new SafeCheckMarker(UUID.randomUUID(), isSafe, referencedVars);
        }

        private Optional<Cursor> findArgumentExprCursor() {
            Cursor cursor = this.getCursor();
            while (cursor.getValue() instanceof Expression && JodaTimeScanner.isJodaExpr((Expression)cursor.getValue())) {
                Cursor parentCursor = cursor.getParentTreeCursor();
                if (parentCursor.getValue() instanceof MethodCall && ((MethodCall)parentCursor.getValue()).getArguments().contains(cursor.getValue())) {
                    return Optional.of(cursor);
                }
                cursor = parentCursor;
            }
            return Optional.empty();
        }

        @ConstructorProperties(value={"expressions"})
        @Generated
        public AddSafeCheckMarker(List<Expression> expressions) {
            if (expressions == null) {
                throw new NullPointerException("expressions is marked non-null but is null");
            }
            this.expressions = expressions;
        }
    }

    private static final class UnresolvedVar {
        private final JavaType declaringType;
        private final String varName;

        @ConstructorProperties(value={"declaringType", "varName"})
        @Generated
        public UnresolvedVar(JavaType declaringType, String varName) {
            this.declaringType = declaringType;
            this.varName = varName;
        }

        @Generated
        public JavaType getDeclaringType() {
            return this.declaringType;
        }

        @Generated
        public String getVarName() {
            return this.varName;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnresolvedVar)) {
                return false;
            }
            UnresolvedVar other = (UnresolvedVar)o;
            JavaType this$declaringType = this.getDeclaringType();
            JavaType other$declaringType = other.getDeclaringType();
            if (this$declaringType == null ? other$declaringType != null : !this$declaringType.equals(other$declaringType)) {
                return false;
            }
            String this$varName = this.getVarName();
            String other$varName = other.getVarName();
            return !(this$varName == null ? other$varName != null : !this$varName.equals(other$varName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $declaringType = this.getDeclaringType();
            result = result * 59 + ($declaringType == null ? 43 : $declaringType.hashCode());
            String $varName = this.getVarName();
            result = result * 59 + ($varName == null ? 43 : $varName.hashCode());
            return result;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "JodaTimeScanner.UnresolvedVar(declaringType=" + this.getDeclaringType() + ", varName=" + this.getVarName() + ")";
        }
    }

    private class FindVarReferences
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private FindVarReferences() {
        }

        public J.Identifier visitIdentifier(J.Identifier ident, Set<// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.VariableDeclarations.NamedVariable> vars) {
            if (!JodaTimeScanner.isJodaExpr((Expression)ident) || ident.getFieldType() == null) {
                return ident;
            }
            if (ident.getFieldType().getOwner() instanceof JavaType.Class) {
                vars.add(null);
            }
            JodaTimeScanner.this.findVarInScope(ident.getSimpleName()).ifPresent(vars::add);
            return ident;
        }
    }

    private static class HasJodaType
    extends JavaIsoVisitor<AtomicBoolean> {
        private HasJodaType() {
        }

        public Expression visitExpression(Expression expression, AtomicBoolean hasJodaType) {
            if (hasJodaType.get()) {
                return expression;
            }
            if (expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
                hasJodaType.set(true);
            }
            return super.visitExpression(expression, (Object)hasJodaType);
        }
    }
}

