/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.beans.ConstructorProperties;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

public final class LombokValueToRecord
extends ScanningRecipe<Map<String, Set<String>>> {
    private static final AnnotationMatcher LOMBOK_VALUE_MATCHER = new AnnotationMatcher("@lombok.Value()");
    private static final AnnotationMatcher LOMBOK_BUILDER_MATCHER = new AnnotationMatcher("@lombok.Builder()");
    @Option(displayName="Add a `toString()` implementation matching Lombok", description="When set the `toString` format from Lombok is used in the migrated record.", required=false)
    @Nullable
    private final Boolean useExactToString;

    public String getDisplayName() {
        return "Convert `@lombok.Value` class to Record";
    }

    public String getDescription() {
        return "Convert Lombok `@Value` annotated classes to standard Java Records.";
    }

    public Set<String> getTags() {
        return Collections.singleton("lombok");
    }

    public Map<String, Set<String>> getInitialValue(ExecutionContext ctx) {
        return new ConcurrentHashMap<String, Set<String>>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Map<String, Set<String>> acc) {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesType("lombok.Value", Boolean.valueOf(false))});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new ScannerVisitor(acc));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Map<String, Set<String>> recordTypesToMembers) {
        return new LombokValueToRecordVisitor(this.useExactToString, recordTypesToMembers);
    }

    private static Stream<J.VariableDeclarations> findAllClassFields(J.ClassDeclaration cd) {
        return cd.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast);
    }

    private static Set<String> getMemberVariableNames(List<J.VariableDeclarations> memberVariables) {
        return memberVariables.stream().map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).map(J.VariableDeclarations.NamedVariable::getSimpleName).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    @ConstructorProperties(value={"useExactToString"})
    @Generated
    public LombokValueToRecord(@Nullable Boolean useExactToString) {
        this.useExactToString = useExactToString;
    }

    @Nullable
    @Generated
    public Boolean getUseExactToString() {
        return this.useExactToString;
    }

    @NonNull
    @Generated
    public String toString() {
        return "LombokValueToRecord(useExactToString=" + this.getUseExactToString() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LombokValueToRecord)) {
            return false;
        }
        LombokValueToRecord other = (LombokValueToRecord)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useExactToString = this.getUseExactToString();
        Boolean other$useExactToString = other.getUseExactToString();
        return !(this$useExactToString == null ? other$useExactToString != null : !((Object)this$useExactToString).equals(other$useExactToString));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof LombokValueToRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useExactToString = this.getUseExactToString();
        result = result * 59 + ($useExactToString == null ? 43 : ((Object)$useExactToString).hashCode());
        return result;
    }

    private static class ScannerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Set<String>> acc;

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (!this.isRelevantClass(cd)) {
                return cd;
            }
            List<J.VariableDeclarations> memberVariables = LombokValueToRecord.findAllClassFields(cd).collect(Collectors.toList());
            if (this.hasMemberVariableAssignments(memberVariables)) {
                return cd;
            }
            assert (cd.getType() != null) : "Class type must not be null";
            Set memberVariableNames = LombokValueToRecord.getMemberVariableNames(memberVariables);
            if (this.implementsConflictingInterfaces(cd, memberVariableNames)) {
                return cd;
            }
            this.acc.putIfAbsent(cd.getType().getFullyQualifiedName(), memberVariableNames);
            return cd;
        }

        private boolean isRelevantClass(J.ClassDeclaration classDeclaration) {
            List allAnnotations = classDeclaration.getAllAnnotations();
            return classDeclaration.getType() != null && !J.ClassDeclaration.Kind.Type.Record.equals((Object)classDeclaration.getKind()) && ScannerVisitor.hasMatchingAnnotations(classDeclaration) && !this.hasGenericTypeParameter(classDeclaration) && classDeclaration.getBody().getStatements().stream().allMatch(this::isRecordCompatibleField) && !this.hasIncompatibleModifier(classDeclaration);
        }

        private static Predicate<J.Annotation> matchAnnotationWithNoArguments(AnnotationMatcher matcher) {
            return ann -> matcher.matches(ann) && (ann.getArguments() == null || ann.getArguments().isEmpty());
        }

        private static boolean hasMatchingAnnotations(J.ClassDeclaration classDeclaration) {
            List allAnnotations = classDeclaration.getAllAnnotations();
            if (allAnnotations.stream().anyMatch(ScannerVisitor.matchAnnotationWithNoArguments(LOMBOK_VALUE_MATCHER))) {
                return allAnnotations.stream().allMatch(ScannerVisitor.matchAnnotationWithNoArguments(LOMBOK_VALUE_MATCHER).or(ScannerVisitor.matchAnnotationWithNoArguments(LOMBOK_BUILDER_MATCHER)));
            }
            return false;
        }

        private boolean implementsConflictingInterfaces(J.ClassDeclaration classDeclaration, Set<String> memberVariableNames) {
            List classDeclarationImplements = classDeclaration.getImplements();
            if (classDeclarationImplements == null) {
                return false;
            }
            return classDeclarationImplements.stream().anyMatch(implemented -> {
                JavaType type = implemented.getType();
                if (type instanceof JavaType.FullyQualified) {
                    return ScannerVisitor.isConflictingInterface((JavaType.FullyQualified)type, memberVariableNames);
                }
                return false;
            });
        }

        private static boolean isConflictingInterface(JavaType.FullyQualified implemented, Set<String> memberVariableNames) {
            boolean hasConflictingMethod = implemented.getMethods().stream().map(JavaType.Method::getName).map(x$0 -> LombokValueToRecordVisitor.getterMethodNameToFluentMethodName(x$0)).anyMatch(memberVariableNames::contains);
            if (hasConflictingMethod) {
                return true;
            }
            List superInterfaces = implemented.getInterfaces();
            if (superInterfaces != null) {
                return superInterfaces.stream().anyMatch(i -> ScannerVisitor.isConflictingInterface(i, memberVariableNames));
            }
            return false;
        }

        private boolean hasGenericTypeParameter(J.ClassDeclaration classDeclaration) {
            List typeParameters = classDeclaration.getTypeParameters();
            return typeParameters != null && !typeParameters.isEmpty();
        }

        private boolean hasIncompatibleModifier(J.ClassDeclaration classDeclaration) {
            Object parentValue;
            return this.getCursor().getParent() != null && ((parentValue = this.getCursor().getParent().getValue()) instanceof J.ClassDeclaration || parentValue instanceof JRightPadded && ((JRightPadded)parentValue).getElement() instanceof J.ClassDeclaration) && classDeclaration.getModifiers().stream().noneMatch(mod -> mod.getType() == J.Modifier.Type.Static);
        }

        private boolean isRecordCompatibleField(Statement statement) {
            if (!(statement instanceof J.VariableDeclarations)) {
                return false;
            }
            J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)statement;
            if (variableDeclarations.getModifiers().stream().anyMatch(modifier -> modifier.getType() == J.Modifier.Type.Static)) {
                return false;
            }
            return variableDeclarations.getAllAnnotations().isEmpty();
        }

        private boolean hasMemberVariableAssignments(List<J.VariableDeclarations> memberVariables) {
            return memberVariables.stream().map(J.VariableDeclarations::getVariables).flatMap(Collection::stream).map(J.VariableDeclarations.NamedVariable::getInitializer).anyMatch(Objects::nonNull);
        }

        @ConstructorProperties(value={"acc"})
        @Generated
        public ScannerVisitor(Map<String, Set<String>> acc) {
            this.acc = acc;
        }
    }

    private static class LombokValueToRecordVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaTemplate TO_STRING_TEMPLATE = JavaTemplate.builder((String)"@Override public String toString() { return \"#{}(\" +\n#{}\n\")\"; }").contextSensitive().build();
        private static final String TO_STRING_MEMBER_LINE_PATTERN = "\"%s=\" + %s +";
        private static final String TO_STRING_MEMBER_DELIMITER = "\", \" +\n";
        private static final String STANDARD_GETTER_PREFIX = "get";
        @Nullable
        private final Boolean useExactToString;
        private final Map<String, Set<String>> recordTypeToMembers;

        public LombokValueToRecordVisitor(@Nullable Boolean useExactToString, Map<String, Set<String>> recordTypeToMembers) {
            this.useExactToString = useExactToString;
            this.recordTypeToMembers = recordTypeToMembers;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation methodInvocation = super.visitMethodInvocation(method, (Object)ctx);
            if (!this.isMethodInvocationOnRecordTypeClassMember(methodInvocation)) {
                return methodInvocation;
            }
            J.Identifier methodName = methodInvocation.getName();
            return methodInvocation.withName(methodName.withSimpleName(LombokValueToRecordVisitor.getterMethodNameToFluentMethodName(methodName.getSimpleName())));
        }

        private boolean isMethodInvocationOnRecordTypeClassMember(J.MethodInvocation methodInvocation) {
            Expression expression = methodInvocation.getSelect();
            if (!LombokValueToRecordVisitor.isClassExpression(expression)) {
                return false;
            }
            JavaType.Class classType = (JavaType.Class)expression.getType();
            if (classType == null) {
                return false;
            }
            String methodName = methodInvocation.getName().getSimpleName();
            String classFqn = classType.getFullyQualifiedName();
            return this.recordTypeToMembers.containsKey(classFqn) && methodName.startsWith(STANDARD_GETTER_PREFIX) && this.recordTypeToMembers.get(classFqn).contains(LombokValueToRecordVisitor.getterMethodNameToFluentMethodName(methodName));
        }

        private static boolean isClassExpression(@Nullable Expression expression) {
            return expression != null && expression.getType() instanceof JavaType.Class;
        }

        private static String getterMethodNameToFluentMethodName(String methodName) {
            StringBuilder fluentMethodName = new StringBuilder(methodName.replace(STANDARD_GETTER_PREFIX, ""));
            if (fluentMethodName.length() == 0) {
                return "";
            }
            char firstMemberChar = fluentMethodName.charAt(0);
            fluentMethodName.setCharAt(0, Character.toLowerCase(firstMemberChar));
            return fluentMethodName.toString();
        }

        private static List<Statement> mapToConstructorArguments(List<J.VariableDeclarations> memberVariables) {
            return memberVariables.stream().map(it -> it.withModifiers(Collections.emptyList()).withVariables(it.getVariables())).map(Statement.class::cast).collect(Collectors.toList());
        }

        private J.ClassDeclaration addExactToStringMethod(J.ClassDeclaration classDeclaration, List<J.VariableDeclarations> memberVariables) {
            return classDeclaration.withBody((J.Block)TO_STRING_TEMPLATE.apply(new Cursor(this.getCursor(), (Object)classDeclaration.getBody()), classDeclaration.getBody().getCoordinates().lastStatement(), new Object[]{classDeclaration.getSimpleName(), LombokValueToRecordVisitor.memberVariablesToString(LombokValueToRecord.getMemberVariableNames(memberVariables))}));
        }

        private static String memberVariablesToString(Set<String> memberVariables) {
            return memberVariables.stream().map(member -> String.format(TO_STRING_MEMBER_LINE_PATTERN, member, member)).collect(Collectors.joining(TO_STRING_MEMBER_DELIMITER));
        }

        private static JavaType.Class buildRecordType(J.ClassDeclaration classDeclaration) {
            assert (classDeclaration.getType() != null) : "Class type must not be null";
            String className = classDeclaration.getType().getFullyQualifiedName();
            return JavaType.ShallowClass.build((String)className).withKind(JavaType.FullyQualified.Kind.Record);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
            J.ClassDeclaration classDeclaration = super.visitClassDeclaration(cd, (Object)ctx);
            JavaType.FullyQualified classType = classDeclaration.getType();
            if (classType == null || !this.recordTypeToMembers.containsKey(classType.getFullyQualifiedName())) {
                return classDeclaration;
            }
            List<J.VariableDeclarations> memberVariables = LombokValueToRecord.findAllClassFields(classDeclaration).collect(Collectors.toList());
            ArrayList bodyStatements = new ArrayList(classDeclaration.getBody().getStatements());
            bodyStatements.removeAll(memberVariables);
            classDeclaration = new RemoveAnnotationVisitor(LOMBOK_VALUE_MATCHER).visitClassDeclaration(classDeclaration, ctx);
            this.maybeRemoveImport("lombok.Value");
            classDeclaration = classDeclaration.withKind(J.ClassDeclaration.Kind.Type.Record).withModifiers(ListUtils.map((List)classDeclaration.getModifiers(), modifier -> {
                J.Modifier.Type type = modifier.getType();
                if (type == J.Modifier.Type.Static || type == J.Modifier.Type.Final) {
                    return null;
                }
                return modifier;
            })).withType((JavaType)LombokValueToRecordVisitor.buildRecordType(classDeclaration)).withBody(classDeclaration.getBody().withStatements(bodyStatements)).withPrimaryConstructor(LombokValueToRecordVisitor.mapToConstructorArguments(memberVariables));
            if (this.useExactToString != null && this.useExactToString.booleanValue()) {
                classDeclaration = this.addExactToStringMethod(classDeclaration, memberVariables);
            }
            return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)classDeclaration, ctx);
        }
    }
}

