/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationAttribute;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseJoinColumnForMapping
extends Recipe {
    private final String JOIN_COLUMN = "javax.persistence.JoinColumn";
    private final String COLUMN = "javax.persistence.Column";

    public String getDisplayName() {
        return "`@JoinColumn` annotations must be used with relationship mappings";
    }

    public String getDescription() {
        return "In OpenJPA, when a relationship attribute has either a `@OneToOne` or a `@ManyToOne` annotation with a `@Column` annotation, the `@Column` annotation is treated as a `@JoinColumn` annotation. EclipseLink throws an exception that indicates that the entity class must use `@JoinColumn` instead of `@Column` to map a relationship attribute.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), new UsesType("javax.persistence.Column", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.OneToOne", Boolean.valueOf(true)), new UsesType("javax.persistence.ManyToOne", Boolean.valueOf(true))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (FindAnnotations.find((J)multiVariable, (String)"javax.persistence.Column").isEmpty() || FindAnnotations.find((J)multiVariable, (String)"javax.persistence.OneToOne").isEmpty() && FindAnnotations.find((J)multiVariable, (String)"javax.persistence.ManyToOne").isEmpty()) {
                    return multiVariable;
                }
                this.maybeRemoveImport("javax.persistence.Column");
                this.maybeAddImport("javax.persistence.JoinColumn");
                J.VariableDeclarations joinColumn = (J.VariableDeclarations)new ChangeType("javax.persistence.Column", "javax.persistence.JoinColumn", Boolean.valueOf(false)).getVisitor().visit((Tree)multiVariable, (Object)ctx);
                joinColumn = (J.VariableDeclarations)new RemoveAnnotationAttribute("javax.persistence.JoinColumn", "length").getVisitor().visit((Tree)joinColumn, (Object)ctx);
                joinColumn = (J.VariableDeclarations)new RemoveAnnotationAttribute("javax.persistence.JoinColumn", "precision").getVisitor().visit((Tree)joinColumn, (Object)ctx);
                joinColumn = (J.VariableDeclarations)new RemoveAnnotationAttribute("javax.persistence.JoinColumn", "scale").getVisitor().visit((Tree)joinColumn, (Object)ctx);
                return joinColumn;
            }
        });
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseJoinColumnForMapping)) {
            return false;
        }
        UseJoinColumnForMapping other = (UseJoinColumnForMapping)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$JOIN_COLUMN = this.JOIN_COLUMN;
        String other$JOIN_COLUMN = other.JOIN_COLUMN;
        if (this$JOIN_COLUMN == null ? other$JOIN_COLUMN != null : !this$JOIN_COLUMN.equals(other$JOIN_COLUMN)) {
            return false;
        }
        String this$COLUMN = this.COLUMN;
        String other$COLUMN = other.COLUMN;
        return !(this$COLUMN == null ? other$COLUMN != null : !this$COLUMN.equals(other$COLUMN));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UseJoinColumnForMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $JOIN_COLUMN = this.JOIN_COLUMN;
        result = result * 59 + ($JOIN_COLUMN == null ? 43 : $JOIN_COLUMN.hashCode());
        String $COLUMN = this.COLUMN;
        result = result * 59 + ($COLUMN == null ? 43 : $COLUMN.hashCode());
        return result;
    }
}

