/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.maven.shared;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.shared.utils.StringUtils;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.AbstractRefasterJavaVisitor;
import org.openrewrite.java.migrate.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class MavenSharedStringUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`MavenSharedStringUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.java.migrate.maven.shared.MavenSharedStringUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbbreviateRecipe(), new CapitalizeRecipe(), new DefaultStringRecipe(), new DefaultStringFallbackRecipe(), new DeleteWhitespaceRecipe(), new EqualsIgnoreCaseRecipe(), new EqualsRecipe(), new LowercaseRecipe(), new ReplaceRecipe(), new ReverseRecipe(), new SplitRecipe(), new StripRecipe(), new TrimRecipe(), new UppercaseRecipe()});
    }

    private static class AbbreviateRecipe
    extends Recipe {
        private AbbreviateRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Abbreviate`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Abbreviate {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s1, @Matches(value = RepeatableArgumentMatcher.class)\n    int width) {\n        return StringUtils.abbreviate(s1, width);\n    }\n    \n    @AfterTemplate\n    String after(String s, int width) {\n        return (s.length() <= width ? s : s.substring(0, width - 3) + \"...\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", (s1, width) -> StringUtils.abbreviate((String)s1, (int)width)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, width) -> s.length() <= width ? s : s.substring(0, width - 3) + "...").build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils abbreviate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class CapitalizeRecipe
    extends Recipe {
        private CapitalizeRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Capitalize`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\n@SuppressWarnings(value = \"ConstantValue\")\nprivate static class Capitalize {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.capitalise(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null || s.isEmpty() ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.capitalise((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null || s.isEmpty() ? s : Character.toTitleCase(s.charAt(0)) + s.substring(1)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils capitalise(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class DefaultStringRecipe
    extends Recipe {
        private DefaultStringRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.DefaultString`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DefaultString {\n    \n    @BeforeTemplate\n    String before(String s) {\n        return StringUtils.defaultString(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return Objects.toString(s, \"\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.defaultString((Object)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> Objects.toString(s, "")).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils defaultString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class DefaultStringFallbackRecipe
    extends Recipe {
        private DefaultStringFallbackRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.DefaultStringFallback`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DefaultStringFallback {\n    \n    @BeforeTemplate\n    String before(String s, String nullDefault) {\n        return StringUtils.defaultString(s, nullDefault);\n    }\n    \n    @AfterTemplate\n    String after(String s, String nullDefault) {\n        return Objects.toString(s, nullDefault);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, nullDefault) -> StringUtils.defaultString((Object)s, (String)nullDefault)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, nullDefault) -> Objects.toString(s, nullDefault)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils defaultString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class DeleteWhitespaceRecipe
    extends Recipe {
        private DeleteWhitespaceRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.DeleteWhitespace`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class DeleteWhitespace {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.deleteWhitespace(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return s.replaceAll(\"\\s+\", \"\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.deleteWhitespace((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s.replaceAll("\\s+", "")).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils deleteWhitespace(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class EqualsIgnoreCaseRecipe
    extends Recipe {
        private EqualsIgnoreCaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.EqualsIgnoreCase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class EqualsIgnoreCase {\n    \n    @BeforeTemplate\n    boolean before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s, @Matches(value = RepeatableArgumentMatcher.class)\n    String other) {\n        return StringUtils.equalsIgnoreCase(s, other);\n    }\n    \n    @AfterTemplate\n    boolean after(String s, String other) {\n        return (s == null ? other == null : s.equalsIgnoreCase(other));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equalsIgnoreCase((String)s, (String)other)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, other) -> s == null ? other == null : s.equalsIgnoreCase((String)other)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils equalsIgnoreCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class EqualsRecipe
    extends Recipe {
        private EqualsRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Equals`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Equals {\n    \n    @BeforeTemplate\n    boolean before(String s, String other) {\n        return StringUtils.equals(s, other);\n    }\n    \n    @AfterTemplate\n    boolean after(String s, String other) {\n        return Objects.equals(s, other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, other) -> StringUtils.equals((String)s, (String)other)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, other) -> Objects.equals(s, other)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils equals(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class LowercaseRecipe
    extends Recipe {
        private LowercaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Lowercase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Lowercase {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.lowerCase(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.toLowerCase());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.lowerCase((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toLowerCase()).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils lowerCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class ReplaceRecipe
    extends Recipe {
        private ReplaceRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Replace`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Replace {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s, @Matches(value = RepeatableArgumentMatcher.class)\n    String search, @Matches(value = RepeatableArgumentMatcher.class)\n    String replacement) {\n        return StringUtils.replace(s, search, replacement);\n    }\n    \n    @AfterTemplate\n    String after(String s, String search, String replacement) {\n        return (s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace(search, replacement));\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", (s, search, replacement) -> StringUtils.replace((String)s, (String)search, (String)replacement)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", (s, search, replacement) -> s == null || s.isEmpty() || search == null || search.isEmpty() || replacement == null ? s : s.replace((CharSequence)search, (CharSequence)replacement)).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(2))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(1), matcher.parameter(2), matcher.parameter(0), matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils replace(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class ReverseRecipe
    extends Recipe {
        private ReverseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Reverse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Reverse {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.reverse(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : new StringBuffer(s).reverse().toString());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.reverse((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : new StringBuffer((String)s).reverse().toString()).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils reverse(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class SplitRecipe
    extends Recipe {
        private SplitRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Split`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Split {\n    \n    @BeforeTemplate\n    String[] before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.split(s);\n    }\n    \n    @AfterTemplate\n    String[] after(String s) {\n        return s.split(\"\\s+\");\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.split((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s.split("\\s+")).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils split(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class StripRecipe
    extends Recipe {
        private StripRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Strip`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Strip {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.strip(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.strip((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils strip(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class TrimRecipe
    extends Recipe {
        private TrimRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Trim`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Trim {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.trim(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.trim());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.trim((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.trim()).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils trim(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    private static class UppercaseRecipe
    extends Recipe {
        private UppercaseRecipe() {
        }

        public String getDisplayName() {
            return "Refaster template `MavenSharedStringUtils.Uppercase`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nprivate static class Uppercase {\n    \n    @BeforeTemplate\n    String before(@Matches(value = RepeatableArgumentMatcher.class)\n    String s) {\n        return StringUtils.upperCase(s);\n    }\n    \n    @AfterTemplate\n    String after(String s) {\n        return (s == null ? null : s.toUpperCase());\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> StringUtils.upperCase((String)s)).build());
                Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> s == null ? null : s.toUpperCase()).build());

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                    if (matcher.find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                        return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(0)}), this.getCursor(), ctx);
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.maven.shared.utils.StringUtils upperCase(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

