/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.AbstractRefasterJavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseStringIsEmptyRecipe
extends Recipe {
    public String getDisplayName() {
        return "Refaster template `UseStringIsEmpty`";
    }

    public String getDescription() {
        return "Recipe created for the following Refaster template:\n```java\npublic class UseStringIsEmpty {\n    \n    @BeforeTemplate\n    boolean before(String s) {\n        return s.length() > 0;\n    }\n    \n    @AfterTemplate\n    boolean after(String s) {\n        return !s.isEmpty();\n    }\n}\n```\n.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            Supplier<JavaTemplate> before = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"before", s -> s.length() > 0).build());
            Supplier<JavaTemplate> after = this.memoize(() -> JavaTemplate.compile((JavaVisitor)this, (String)"after", s -> !s.isEmpty()).build());

            public J visitBinary(J.Binary elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.matcher(this.before, this.getCursor());
                if (matcher.find()) {
                    return this.embed(this.apply(this.after, this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx);
                }
                return super.visitBinary(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)new UsesMethod("java.lang.String length(..)"), (TreeVisitor)javaVisitor);
    }
}

