/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.lang;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class IsNotEmptyToJdk
extends Recipe {
    public String getDisplayName() {
        return "Replace any StringUtils#isEmpty(String) and #isNotEmpty(String)";
    }

    public String getDescription() {
        return "Replace any `StringUtils#isEmpty(String)` and `#isNotEmpty(String)` with `s == null || s.isEmpty()` and `s != null && !s.isEmpty()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("apache", "commons"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(false)), new UsesType("org.apache.maven.shared.utils.StringUtils", Boolean.valueOf(false)), new UsesType("org.codehaus.plexus.util.StringUtils", Boolean.valueOf(false))});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher isEmptyMatcher = new MethodMatcher("*..StringUtils isEmpty(..)");
            private final MethodMatcher isNotEmptyMatcher = new MethodMatcher("*..StringUtils isNotEmpty(..)");
            private final JavaTemplate isEmptyReplacement = JavaTemplate.compile((JavaVisitor)this, (String)"IsEmpty", s -> s == null || s.isEmpty()).build();
            private final JavaTemplate isNotEmptyReplacement = JavaTemplate.compile((JavaVisitor)this, (String)"IsNotEmpty", s -> s != null && !s.isEmpty()).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J j = super.visitMethodInvocation(method, (Object)ctx);
                if (!(j instanceof J.MethodInvocation)) {
                    return j;
                }
                J.MethodInvocation mi = (J.MethodInvocation)j;
                Expression arg = (Expression)mi.getArguments().get(0);
                if (!(arg instanceof J.Identifier) && !(arg instanceof J.FieldAccess)) {
                    return j;
                }
                JavaTemplate replacementTemplate = this.getReplacementTemplate(mi);
                if (replacementTemplate != null) {
                    this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                    this.maybeRemoveImport("org.apache.maven.shared.utils.StringUtils");
                    this.maybeRemoveImport("org.codehaus.plexus.util.StringUtils");
                    this.doAfterVisit((TreeVisitor)new UnnecessaryParenthesesVisitor());
                    return replacementTemplate.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{arg, arg});
                }
                return mi;
            }

            @Nullable
            private JavaTemplate getReplacementTemplate(J.MethodInvocation mi) {
                if (this.isEmptyMatcher.matches((MethodCall)mi)) {
                    return this.isEmptyReplacement;
                }
                if (this.isNotEmptyMatcher.matches((MethodCall)mi)) {
                    return this.isNotEmptyReplacement;
                }
                return null;
            }
        });
    }
}

