/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class UseVarForGenericsConstructors
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to Generic Constructors";
    }

    public String getDescription() {
        return "Apply `var` to generics variables initialized by constructor calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsVisitor());
    }

    static final class UseVarForGenericsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaTemplate template = JavaTemplate.builder((String)"var #{} = #{any()}").javaParser(JavaParser.fromJavaVersion()).build();

        UseVarForGenericsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
            List<JavaType> leftTypes = this.extractParameters(variable.getVariableType());
            List<JavaType> rightTypes = this.extractParameters(variable.getInitializer());
            if (rightTypes == null || leftTypes.isEmpty() && rightTypes.isEmpty()) {
                return vd;
            }
            return this.transformToVar(vd, leftTypes, rightTypes);
        }

        @Nullable
        private List<JavaType> extractParameters(@Nullable Expression initializer) {
            TypeTree clazz;
            if (initializer instanceof J.NewClass && (clazz = ((J.NewClass)initializer).getClazz()) instanceof J.ParameterizedType) {
                List typeParameters = ((J.ParameterizedType)clazz).getTypeParameters();
                if (typeParameters != null) {
                    return typeParameters.stream().map(Expression::getType).filter(Objects::nonNull).collect(Collectors.toList());
                }
                return new ArrayList<JavaType>();
            }
            return null;
        }

        private List<JavaType> extractParameters(@Nullable JavaType.Variable variableType) {
            if (variableType != null && variableType.getType() instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)variableType.getType()).getTypeParameters();
            }
            return new ArrayList<JavaType>();
        }

        private J.VariableDeclarations transformToVar(J.VariableDeclarations vd, List<JavaType> leftTypes, List<JavaType> rightTypes) {
            TypeTree resultingTypeExpression;
            boolean resultHasTypeExpression;
            boolean hasModifiers;
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            String simpleName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName();
            if (rightTypes.isEmpty() && !leftTypes.isEmpty()) {
                List typeArgument = leftTypes.stream().map(t -> new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, ((JavaType.Class)t).getClassName(), t, null)).collect(Collectors.toList());
                J.ParameterizedType typedInitializerClazz = ((J.ParameterizedType)((J.NewClass)initializer).getClazz()).withTypeParameters(typeArgument);
                initializer = ((J.NewClass)initializer).withClazz((TypeTree)typedInitializerClazz);
            }
            J.VariableDeclarations result = ((J.VariableDeclarations)this.template.apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{simpleName, initializer})).withPrefix(vd.getPrefix());
            List modifiers = vd.getModifiers();
            boolean bl = hasModifiers = !modifiers.isEmpty();
            if (hasModifiers) {
                result = result.withModifiers(modifiers);
            }
            boolean bl2 = resultHasTypeExpression = (resultingTypeExpression = result.getTypeExpression()) != null;
            if (resultHasTypeExpression) {
                result = result.withTypeExpression((TypeTree)resultingTypeExpression.withPrefix(vd.getTypeExpression().getPrefix()));
            }
            return result;
        }
    }
}

