/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaDirectExecutor
extends Recipe {
    private static final MethodMatcher DIRECT_EXECUTOR = new MethodMatcher("com.google.common.util.concurrent.MoreExecutors directExecutor()");

    public String getDisplayName() {
        return "Prefer `Runnable::run`";
    }

    public String getDescription() {
        return "`Executor` is a SAM-compatible interface, so `Runnable::run` is just as succinct as `MoreExecutors.directExecutor()` but without the third-party library requirement.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(DIRECT_EXECUTOR);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"Runnable::run").imports(new String[]{"java.lang.Runnable"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (DIRECT_EXECUTOR.matches(method)) {
                    this.maybeRemoveImport("com.google.common.util.concurrent.MoreExecutors");
                    return method.withTemplate((SourceTemplate)this.template, method.getCoordinates().replace(), new Object[0]);
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }
}

