/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.template.SourceTemplate;

public class OptionalNotEmptyToIsPresent
extends Recipe {
    private static final String JAVA_UTIL_OPTIONAL_IS_EMPTY = "java.util.Optional isEmpty()";

    public String getDisplayName() {
        return "Prefer `Optional.isPresent()`";
    }

    public String getDescription() {
        return "Prefer `Optional.isPresent()` instead of using `!Optional.isEmpty()` in Java 11 or higher.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(11), new UsesMethod(JAVA_UTIL_OPTIONAL_IS_EMPTY)});
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher optionalIsPresentMatcher = new MethodMatcher(JAVA_UTIL_OPTIONAL_IS_EMPTY);
        return new JavaVisitor<ExecutionContext>(){

            public Statement visitStatement(Statement s, ExecutionContext p) {
                J.MethodInvocation methodInvocation;
                Expression expression;
                J.Unary unary;
                Statement statement = (Statement)super.visitStatement(s, (Object)p);
                if (statement instanceof J.Unary && (unary = (J.Unary)statement).getOperator() == J.Unary.Type.Not && (expression = unary.getExpression()) instanceof J.MethodInvocation && optionalIsPresentMatcher.matches(methodInvocation = (J.MethodInvocation)expression)) {
                    return (Statement)statement.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any()}.isPresent()").build(), statement.getCoordinates().replace(), new Object[]{methodInvocation.getSelect()});
                }
                return statement;
            }
        };
    }
}

