/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class StringFormatted
extends Recipe {
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(String, ..)");

    public String getDisplayName() {
        return "Replace `String#format(String, Object...)` with `String#formatted(Object...)`";
    }

    public String getDescription() {
        return "Call `String#formatted(Object...)` on first argument to `String#format(String, Object...)`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(17), new UsesMethod(STRING_FORMAT)});
    }

    protected StringFormattedVisitor getVisitor() {
        return new StringFormattedVisitor();
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    private static class StringFormattedVisitor
    extends JavaVisitor<ExecutionContext> {
        private StringFormattedVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext p) {
            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)p);
            if (!STRING_FORMAT.matches(mi)) {
                return mi;
            }
            List arguments = mi.getArguments();
            String template = String.format(StringFormattedVisitor.wrapperNotNeeded((Expression)arguments.get(0)) ? "#{any(java.lang.String)}.formatted(%s)" : "(#{any(java.lang.String)}).formatted(%s)", String.join((CharSequence)", ", Collections.nCopies(arguments.size() - 1, "#{any()}")));
            this.maybeRemoveImport("java.lang.String.format");
            mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((StringFormattedVisitor)this).getCursor(), (String)template).javaParser(() -> JavaParser.fromJavaVersion().build()).build(), mi.getCoordinates().replace(), arguments.toArray());
            if (arguments.size() > 1) {
                arguments.remove(0);
                mi = (J.MethodInvocation)this.maybeAutoFormat((J)mi, (J)mi.withArguments(ListUtils.map((List)mi.getArguments(), (a, b) -> (Expression)b.withPrefix(((Expression)arguments.get((int)a)).getPrefix()))), p);
            }
            return mi;
        }

        private static boolean wrapperNotNeeded(Expression expression) {
            return expression instanceof J.Identifier || expression instanceof J.Literal || expression instanceof J.MethodInvocation;
        }
    }
}

