/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class NoGuavaAtomicsNewReference
extends Recipe {
    private static final MethodMatcher NEW_ATOMIC_REFERENCE = new MethodMatcher("com.google.common.util.concurrent.Atomics newReference(..)");

    public String getDisplayName() {
        return "Use `new AtomicReference<>()` instead of Guava";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new UsesMethod(NEW_ATOMIC_REFERENCE);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate newAtomicReference = JavaTemplate.builder(() -> (this).getCursor(), (String)"new AtomicReference<>()").imports(new String[]{"java.util.concurrent.atomic.AtomicReference"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (NEW_ATOMIC_REFERENCE.matches(method)) {
                    this.maybeRemoveImport("com.google.common.util.concurrent.Atomics");
                    this.maybeAddImport("java.util.concurrent.atomic.AtomicReference");
                    return ((J.NewClass)method.withTemplate((SourceTemplate)this.newAtomicReference, method.getCoordinates().replace(), new Object[0])).withArguments(method.getArguments());
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }
}

