/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.logging;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class MigrateLoggerGlobalToGetGlobal
extends Recipe {
    public String getDisplayName() {
        return "Use `Logger#getGlobal()`";
    }

    public String getDescription() {
        return "The preferred way to get the global logger object is via the call `Logger#getGlobal()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("java.util.logging.Logger");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MigrateLoggerGlobalToGetGlobalVisitor();
    }

    private static class MigrateLoggerGlobalToGetGlobalVisitor
    extends JavaVisitor<ExecutionContext> {
        private MigrateLoggerGlobalToGetGlobalVisitor() {
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J j = super.visitFieldAccess(fieldAccess, (Object)ctx);
            J.FieldAccess asFieldAccess = (J.FieldAccess)j;
            if (TypeUtils.isOfClassType((JavaType)asFieldAccess.getTarget().getType(), (String)"java.util.logging.Logger") && asFieldAccess.getSimpleName().equals("global")) {
                j = new J.MethodInvocation(Tree.randomId(), asFieldAccess.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)asFieldAccess.getTarget()), null, asFieldAccess.getName().withName("getGlobal"), JContainer.build(Collections.emptyList()), TypeUtils.asMethod((JavaType)asFieldAccess.getTarget().getType()));
            }
            return j;
        }
    }
}

