/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.MethodCall;

public class LoggersNamedForEnclosingClass
extends Recipe {
    private static final MethodMatcher LOGGERFACTORY_GETLOGGER = new MethodMatcher("org.slf4j.LoggerFactory getLogger(Class)");

    public String getDisplayName() {
        return "Loggers should be named for their enclosing classes";
    }

    public String getDescription() {
        return "Ensure `LoggerFactory#getLogger(Class)` is called with the enclosing class as argument.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public Set<String> getTags() {
        return new HashSet<String>(Arrays.asList("RSPEC-S3416", "logging", "slf4j"));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.slf4j.LoggerFactory", null), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext ctx) {
                        return javadoc;
                    }
                };
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                String argumentClazzName;
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!LOGGERFACTORY_GETLOGGER.matches((MethodCall)mi)) {
                    return mi;
                }
                J.ClassDeclaration firstEnclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (firstEnclosingClass == null) {
                    return mi;
                }
                String enclosingClazzName = firstEnclosingClass.getSimpleName() + ".class";
                Expression firstArgument = (Expression)mi.getArguments().get(0);
                if (firstArgument instanceof J.FieldAccess ? (argumentClazzName = ((J.FieldAccess)firstArgument).toString()).endsWith(".class") && !enclosingClazzName.equals(argumentClazzName) : firstArgument instanceof J.MethodInvocation && "getClass".equals(((J.MethodInvocation)firstArgument).getName().toString()) && firstEnclosingClass.hasModifier(J.Modifier.Type.Final)) {
                    return this.replaceMethodArgument(mi, enclosingClazzName);
                }
                return mi;
            }

            private J.MethodInvocation replaceMethodArgument(J.MethodInvocation mi, String enclosingClazzName) {
                return (J.MethodInvocation)JavaTemplate.builder((String)"#{}").contextSensitive().build().apply(this.getCursor(), mi.getCoordinates().replaceArguments(), new Object[]{enclosingClazzName});
            }
        });
    }
}

