/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.maven.ChangeDependencyGroupIdAndArtifactId;

public class ChangeDependency
extends Recipe {
    @Option(displayName="Old group ID", description="The old group ID to replace. The group ID is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="org.openrewrite.recipe")
    String oldGroupId;
    @Option(displayName="Old artifact ID", description="The old artifact ID to replace. The artifact ID is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'. Supports glob expressions.", example="rewrite-testing-frameworks")
    String oldArtifactId;
    @Option(displayName="New group ID", description="The new group ID to use. Defaults to the existing group ID.", example="corp.internal.openrewrite.recipe", required=false)
    @Nullable String newGroupId;
    @Option(displayName="New artifact ID", description="The new artifact ID to use. Defaults to the existing artifact ID.", example="rewrite-testing-frameworks", required=false)
    @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable String versionPattern;
    @Option(displayName="Override managed version", description="If the new dependency has a managed version, this flag can be used to explicitly set the version on the dependency. The default for this flag is `false`.", required=false)
    @Nullable Boolean overrideManagedVersion;
    @Option(displayName="Update dependency management", description="Also update the dependency management section. The default for this flag is `true`.", required=false)
    @Nullable Boolean changeManagedDependency;
    final String displayName = "Change Gradle or Maven dependency";
    final String description = "Change the group ID, artifact ID, and/or the version of a specified Gradle or Maven dependency.";

    public Validated<Object> validate(ExecutionContext ctx) {
        return super.validate(ctx).and(new org.openrewrite.gradle.ChangeDependency(this.oldGroupId, this.oldArtifactId, this.newGroupId, this.newArtifactId, this.newVersion, this.versionPattern, this.overrideManagedVersion, this.changeManagedDependency).validate()).and(new ChangeDependencyGroupIdAndArtifactId(this.oldGroupId, this.oldArtifactId, this.newGroupId, this.newArtifactId, this.newVersion, this.versionPattern, this.overrideManagedVersion, this.changeManagedDependency).validate());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){
            final TreeVisitor<?, ExecutionContext> mavenVisitor;
            final TreeVisitor<?, ExecutionContext> gradleVisitor;
            {
                this.mavenVisitor = new ChangeDependencyGroupIdAndArtifactId(ChangeDependency.this.oldGroupId, ChangeDependency.this.oldArtifactId, ChangeDependency.this.newGroupId, ChangeDependency.this.newArtifactId, ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ChangeDependency.this.overrideManagedVersion, ChangeDependency.this.changeManagedDependency).getVisitor();
                this.gradleVisitor = new org.openrewrite.gradle.ChangeDependency(ChangeDependency.this.oldGroupId, ChangeDependency.this.oldArtifactId, ChangeDependency.this.newGroupId, ChangeDependency.this.newArtifactId, ChangeDependency.this.newVersion, ChangeDependency.this.versionPattern, ChangeDependency.this.overrideManagedVersion, Boolean.valueOf(true)).getVisitor();
            }

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return this.mavenVisitor.isAcceptable(sourceFile, (Object)ctx) || this.gradleVisitor.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile s = (SourceFile)tree;
                if (this.gradleVisitor.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.gradleVisitor.visitNonNull((Tree)s, (Object)ctx);
                } else if (this.mavenVisitor.isAcceptable(s, (Object)ctx)) {
                    s = (SourceFile)this.mavenVisitor.visitNonNull((Tree)s, (Object)ctx);
                }
                return s;
            }
        };
    }

    @ConstructorProperties(value={"oldGroupId", "oldArtifactId", "newGroupId", "newArtifactId", "newVersion", "versionPattern", "overrideManagedVersion", "changeManagedDependency"})
    @Generated
    public ChangeDependency(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion, @Nullable Boolean changeManagedDependency) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.changeManagedDependency = changeManagedDependency;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependency)) {
            return false;
        }
        ChangeDependency other = (ChangeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        Boolean this$changeManagedDependency = this.getChangeManagedDependency();
        Boolean other$changeManagedDependency = other.getChangeManagedDependency();
        if (this$changeManagedDependency == null ? other$changeManagedDependency != null : !((Object)this$changeManagedDependency).equals(other$changeManagedDependency)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        Boolean $changeManagedDependency = this.getChangeManagedDependency();
        result = result * 59 + ($changeManagedDependency == null ? 43 : ((Object)$changeManagedDependency).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Generated
    public @Nullable Boolean getChangeManagedDependency() {
        return this.changeManagedDependency;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

