/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.dependencies.RemoveDependency;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;

public final class RemoveRedundantDependencies
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Group ID", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION` of the parent dependency. This can be a glob expression.", example="com.fasterxml.jackson.core")
    private final String groupId;
    @Option(displayName="Artifact ID", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION` of the parent dependency. This can be a glob expression.", example="jackson-databind")
    private final String artifactId;
    private final String displayName = "Remove redundant explicit dependencies";
    private final String description = "Remove explicit dependencies that are already provided transitively by a specified dependency. This recipe downloads and resolves the parent dependency's POM to determine its true transitive dependencies, allowing it to detect redundancies even when both dependencies are explicitly declared.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashMap<String, Map<String, Set<ResolvedGroupArtifactVersion>>>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                tree.getMarkers().findFirst(GradleProject.class).ifPresent(gradle -> {
                    String projectId = gradle.getGroup() + ":" + gradle.getName();
                    MavenPomDownloader downloader = new MavenPomDownloader(ctx);
                    for (GradleDependencyConfiguration conf : gradle.getConfigurations()) {
                        for (ResolvedDependency dep : conf.getResolved()) {
                            if (!dep.isDirect() || !StringUtils.matchesGlob((String)dep.getGroupId(), (String)RemoveRedundantDependencies.this.groupId) || !StringUtils.matchesGlob((String)dep.getArtifactId(), (String)RemoveRedundantDependencies.this.artifactId)) continue;
                            Set transitives = acc.transitivesByProjectAndScope.computeIfAbsent(projectId, k -> new HashMap()).computeIfAbsent(conf.getName(), k -> new HashSet());
                            this.resolveTransitivesFromPom(dep.getGav(), dep.getEffectiveExclusions(), gradle.getMavenRepositories(), downloader, ctx, transitives);
                        }
                    }
                });
                tree.getMarkers().findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    String projectId = maven.getPom().getGroupId() + ":" + maven.getPom().getArtifactId();
                    MavenPomDownloader downloader = new MavenPomDownloader(ctx);
                    for (Map.Entry entry : maven.getDependencies().entrySet()) {
                        Scope depScope = (Scope)entry.getKey();
                        for (ResolvedDependency dep : (List)entry.getValue()) {
                            if (!dep.isDirect() || !StringUtils.matchesGlob((String)dep.getGroupId(), (String)RemoveRedundantDependencies.this.groupId) || !StringUtils.matchesGlob((String)dep.getArtifactId(), (String)RemoveRedundantDependencies.this.artifactId)) continue;
                            Set transitives = acc.transitivesByProjectAndScope.computeIfAbsent(projectId, k -> new HashMap()).computeIfAbsent(depScope.name().toLowerCase(), k -> new HashSet());
                            this.resolveTransitivesFromPom(dep.getGav(), dep.getEffectiveExclusions(), maven.getPom().getRepositories(), downloader, ctx, transitives);
                        }
                    }
                });
                return tree;
            }

            private void resolveTransitivesFromPom(ResolvedGroupArtifactVersion gav, List<GroupArtifact> effectiveExclusions, List<MavenRepository> repositories, MavenPomDownloader downloader, ExecutionContext ctx, Set<ResolvedGroupArtifactVersion> transitives) {
                try {
                    ArrayList<MavenRepository> effectiveRepos = new ArrayList<MavenRepository>(repositories);
                    if (effectiveRepos.stream().noneMatch(r -> r.getUri().contains("repo.maven.apache.org") || r.getUri().contains("repo1.maven.org"))) {
                        effectiveRepos.add(MavenRepository.MAVEN_CENTRAL);
                    }
                    Pom pom = downloader.download(gav.asGroupArtifactVersion(), null, null, effectiveRepos);
                    ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), downloader, effectiveRepos, ctx);
                    ResolvedPom patchedPom = this.applyExclusions(resolvedPom, effectiveExclusions);
                    List resolved = patchedPom.resolveDependencies(Scope.Compile, downloader, ctx);
                    for (ResolvedDependency dep : resolved) {
                        this.collectAllDependencies(dep, transitives);
                    }
                }
                catch (MavenDownloadingException | MavenDownloadingExceptions throwable) {
                    // empty catch block
                }
            }

            private ResolvedPom applyExclusions(ResolvedPom resolvedPom, List<GroupArtifact> effectiveExclusions) {
                ResolvedPom patchedPom = resolvedPom.withRequested(resolvedPom.getRequested().withDependencies(ListUtils.filter((List)resolvedPom.getRequested().getDependencies(), d -> effectiveExclusions.stream().noneMatch(e -> e.getGroupId().equals(d.getGroupId()) && e.getArtifactId().equals(d.getArtifactId())))));
                patchedPom.getRequestedDependencies().removeIf(d -> effectiveExclusions.stream().anyMatch(e -> e.getGroupId().equals(d.getGroupId()) && e.getArtifactId().equals(d.getArtifactId())));
                return patchedPom;
            }

            private void collectAllDependencies(ResolvedDependency dep, Set<ResolvedGroupArtifactVersion> transitives) {
                if (transitives.add(dep.getGav())) {
                    for (ResolvedDependency transitive : dep.getDependencies()) {
                        this.collectAllDependencies(transitive, transitives);
                    }
                }
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sf;
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile result = sf = (SourceFile)tree;
                Optional gradleOpt = sf.getMarkers().findFirst(GradleProject.class);
                if (gradleOpt.isPresent()) {
                    GradleProject gradle = (GradleProject)gradleOpt.get();
                    String projectId = gradle.getGroup() + ":" + gradle.getName();
                    Map<String, Set<ResolvedGroupArtifactVersion>> scopeToTransitives = acc.transitivesByProjectAndScope.getOrDefault(projectId, Collections.emptyMap());
                    for (GradleDependencyConfiguration conf : gradle.getConfigurations()) {
                        Set<ResolvedGroupArtifactVersion> transitives = this.getCompatibleTransitives(scopeToTransitives, conf.getName(), true);
                        if (transitives.isEmpty()) continue;
                        for (ResolvedDependency dep : conf.getResolved()) {
                            if (!dep.isDirect() || !this.doesNotMatchArguments(dep) || !this.isInTransitives(dep, transitives)) continue;
                            result = new RemoveDependency(dep.getGroupId(), dep.getArtifactId(), null, null, null).getVisitor().visit((Tree)result, (Object)ctx);
                        }
                    }
                    return result;
                }
                Optional mavenOpt = sf.getMarkers().findFirst(MavenResolutionResult.class);
                if (mavenOpt.isPresent()) {
                    MavenResolutionResult maven = (MavenResolutionResult)mavenOpt.get();
                    String projectId = maven.getPom().getGroupId() + ":" + maven.getPom().getArtifactId();
                    Map<String, Set<ResolvedGroupArtifactVersion>> scopeToTransitives = acc.transitivesByProjectAndScope.getOrDefault(projectId, Collections.emptyMap());
                    for (Map.Entry entry : maven.getDependencies().entrySet()) {
                        String scope = ((Scope)entry.getKey()).name().toLowerCase();
                        Set<ResolvedGroupArtifactVersion> transitives = this.getCompatibleTransitives(scopeToTransitives, scope, false);
                        if (transitives.isEmpty()) continue;
                        for (ResolvedDependency dep : (List)entry.getValue()) {
                            if (!dep.isDirect() || !this.doesNotMatchArguments(dep) || !this.isInTransitives(dep, transitives)) continue;
                            result = new RemoveDependency(dep.getGroupId(), dep.getArtifactId(), null, null, scope).getVisitor().visit((Tree)result, (Object)ctx);
                        }
                    }
                    return result;
                }
                return tree;
            }

            private boolean doesNotMatchArguments(ResolvedDependency dep) {
                return !StringUtils.matchesGlob((String)dep.getGroupId(), (String)RemoveRedundantDependencies.this.groupId) || !StringUtils.matchesGlob((String)dep.getArtifactId(), (String)RemoveRedundantDependencies.this.artifactId);
            }

            private boolean isInTransitives(ResolvedDependency dep, Set<ResolvedGroupArtifactVersion> transitives) {
                for (ResolvedGroupArtifactVersion transitive : transitives) {
                    if (!dep.getGroupId().equals(transitive.getGroupId()) || !dep.getArtifactId().equals(transitive.getArtifactId()) || !dep.getVersion().equals(transitive.getVersion())) continue;
                    return true;
                }
                return false;
            }

            private Set<ResolvedGroupArtifactVersion> getCompatibleTransitives(Map<String, Set<ResolvedGroupArtifactVersion>> scopeToTransitives, String targetScope, boolean isGradle) {
                HashSet<ResolvedGroupArtifactVersion> result = new HashSet<ResolvedGroupArtifactVersion>();
                Set<ResolvedGroupArtifactVersion> sameScope = scopeToTransitives.get(targetScope);
                if (sameScope != null) {
                    result.addAll(sameScope);
                }
                List<String> broaderScopes = isGradle ? this.getBroaderGradleScopes(targetScope) : this.getBroaderMavenScopes(targetScope);
                for (String broader : broaderScopes) {
                    Set<ResolvedGroupArtifactVersion> broaderTransitives = scopeToTransitives.get(broader);
                    if (broaderTransitives == null) continue;
                    result.addAll(broaderTransitives);
                }
                return result;
            }

            private List<String> getBroaderGradleScopes(String scope) {
                switch (scope.toLowerCase()) {
                    case "runtimeonly": 
                    case "runtimeclasspath": {
                        return Arrays.asList("implementation", "api");
                    }
                    case "implementation": {
                        return Collections.singletonList("api");
                    }
                    case "testimplementation": 
                    case "testruntimeonly": {
                        return Arrays.asList("implementation", "api", "testImplementation");
                    }
                }
                return Collections.emptyList();
            }

            private List<String> getBroaderMavenScopes(String scope) {
                switch (scope.toLowerCase()) {
                    case "runtime": {
                        return Collections.singletonList("compile");
                    }
                    case "provided": {
                        return Arrays.asList("compile", "runtime");
                    }
                    case "test": {
                        return Arrays.asList("compile", "runtime", "provided");
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId"})
    @Generated
    public RemoveRedundantDependencies(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "RemoveRedundantDependencies(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantDependencies)) {
            return false;
        }
        RemoveRedundantDependencies other = (RemoveRedundantDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveRedundantDependencies;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> transitivesByProjectAndScope;

        @ConstructorProperties(value={"transitivesByProjectAndScope"})
        @Generated
        public Accumulator(Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> transitivesByProjectAndScope) {
            this.transitivesByProjectAndScope = transitivesByProjectAndScope;
        }

        @Generated
        public Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> getTransitivesByProjectAndScope() {
            return this.transitivesByProjectAndScope;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> this$transitivesByProjectAndScope = this.getTransitivesByProjectAndScope();
            Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> other$transitivesByProjectAndScope = other.getTransitivesByProjectAndScope();
            return !(this$transitivesByProjectAndScope == null ? other$transitivesByProjectAndScope != null : !((Object)this$transitivesByProjectAndScope).equals(other$transitivesByProjectAndScope));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Map<String, Set<ResolvedGroupArtifactVersion>>> $transitivesByProjectAndScope = this.getTransitivesByProjectAndScope();
            result = result * 59 + ($transitivesByProjectAndScope == null ? 43 : ((Object)$transitivesByProjectAndScope).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RemoveRedundantDependencies.Accumulator(transitivesByProjectAndScope=" + this.getTransitivesByProjectAndScope() + ")";
        }
    }
}

