/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.dependencies.table.DependencyListReport;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public final class DependencyList
extends Recipe {
    private final transient DependencyListReport report = new DependencyListReport(this);
    @Option(displayName="Scope", description="The scope of the dependencies to include in the report.", valid={"Compile", "Runtime", "TestRuntime"}, example="Compile")
    private final Scope scope;
    @Option(displayName="Include transitive dependencies", description="Whether or not to include transitive dependencies in the report. Defaults to including only direct dependencies.", example="true")
    private final boolean includeTransitive;
    private final transient Set<GroupArtifactVersion> seenGradleProjects = new HashSet<GroupArtifactVersion>();

    public String getDisplayName() {
        return "Dependency report";
    }

    public String getDescription() {
        return "Emits a data table detailing all Gradle and Maven dependencies.This recipe makes no changes to any source file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Markers m = tree.getMarkers();
                HashSet seen = new HashSet();
                m.findFirst(GradleProject.class).filter(gradle -> DependencyList.this.seenGradleProjects.add(new GroupArtifactVersion(gradle.getGroup(), gradle.getName(), gradle.getVersion()))).ifPresent(gradle -> {
                    GradleDependencyConfiguration conf = gradle.getConfiguration(DependencyList.this.scope.asGradleConfigurationName());
                    if (conf != null) {
                        for (ResolvedDependency dep : conf.getResolved()) {
                            DependencyList.this.insertDependency(ctx, gradle, (Set<ResolvedGroupArtifactVersion>)seen, dep, true);
                        }
                    }
                });
                m.findFirst(MavenResolutionResult.class).ifPresent(maven -> {
                    for (ResolvedDependency dep : (List)maven.getDependencies().get(DependencyList.this.scope.asMavenScope())) {
                        DependencyList.this.insertDependency(ctx, maven, (Set<ResolvedGroupArtifactVersion>)seen, dep, true);
                    }
                });
                return tree;
            }
        };
    }

    private void insertDependency(ExecutionContext ctx, GradleProject gradle, Set<ResolvedGroupArtifactVersion> seen, ResolvedDependency dep, boolean direct) {
        if (!seen.add(dep.getGav())) {
            return;
        }
        this.report.insertRow(ctx, new DependencyListReport.Row("Gradle", gradle.getGroup(), gradle.getName(), gradle.getVersion(), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, gradle, seen, transitive, false);
            }
        }
    }

    private void insertDependency(ExecutionContext ctx, MavenResolutionResult maven, Set<ResolvedGroupArtifactVersion> seen, ResolvedDependency dep, boolean direct) {
        if (!seen.add(dep.getGav())) {
            return;
        }
        this.report.insertRow(ctx, new DependencyListReport.Row("Maven", maven.getPom().getGroupId(), maven.getPom().getArtifactId(), maven.getPom().getVersion(), dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), direct));
        if (this.includeTransitive) {
            for (ResolvedDependency transitive : dep.getDependencies()) {
                this.insertDependency(ctx, maven, seen, transitive, false);
            }
        }
    }

    @ConstructorProperties(value={"scope", "includeTransitive"})
    @Generated
    public DependencyList(Scope scope, boolean includeTransitive) {
        this.scope = scope;
        this.includeTransitive = includeTransitive;
    }

    @Generated
    public DependencyListReport getReport() {
        return this.report;
    }

    @Generated
    public Scope getScope() {
        return this.scope;
    }

    @Generated
    public boolean isIncludeTransitive() {
        return this.includeTransitive;
    }

    @Generated
    public Set<GroupArtifactVersion> getSeenGradleProjects() {
        return this.seenGradleProjects;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyList(report=" + (Object)((Object)this.getReport()) + ", scope=" + (Object)((Object)this.getScope()) + ", includeTransitive=" + this.isIncludeTransitive() + ", seenGradleProjects=" + this.getSeenGradleProjects() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyList)) {
            return false;
        }
        DependencyList other = (DependencyList)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeTransitive() != other.isIncludeTransitive()) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeTransitive() ? 79 : 97);
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        return result;
    }

    public static enum Scope {
        Compile,
        Runtime,
        TestRuntime;


        public org.openrewrite.maven.tree.Scope asMavenScope() {
            switch (this) {
                case Compile: {
                    return org.openrewrite.maven.tree.Scope.Compile;
                }
                case Runtime: {
                    return org.openrewrite.maven.tree.Scope.Runtime;
                }
                case TestRuntime: {
                    return org.openrewrite.maven.tree.Scope.Test;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }

        public String asGradleConfigurationName() {
            switch (this) {
                case Compile: {
                    return "compileClasspath";
                }
                case Runtime: {
                    return "runtimeClasspath";
                }
                case TestRuntime: {
                    return "testRuntimeClasspath";
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }
    }
}

