/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class GradleDependencyConfigurationErrors
extends DataTable<Row> {
    public GradleDependencyConfigurationErrors(Recipe recipe) {
        super(recipe, "Gradle dependency configuration errors", "Records Gradle dependency configurations which failed to resolve during parsing. Partial success/failure is common, a failure in this list does not mean that every dependency failed to resolve.");
    }

    public static final class Row {
        @Column(displayName="Project path", description="The path of the project which contains the dependency configuration.")
        private final String projectPath;
        @Column(displayName="Configuration name", description="The name of the dependency configuration which failed to resolve.")
        private final String configurationName;
        @Column(displayName="Exception type", description="The type of exception encountered when attempting to resolve the dependency configuration.")
        private final String exceptionType;
        @Column(displayName="Error message", description="The error message encountered when attempting to resolve the dependency configuration.")
        private final String exceptionMessage;

        @ConstructorProperties(value={"projectPath", "configurationName", "exceptionType", "exceptionMessage"})
        public Row(String projectPath, String configurationName, String exceptionType, String exceptionMessage) {
            this.projectPath = projectPath;
            this.configurationName = configurationName;
            this.exceptionType = exceptionType;
            this.exceptionMessage = exceptionMessage;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public String getConfigurationName() {
            return this.configurationName;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$projectPath = this.getProjectPath();
            String other$projectPath = other.getProjectPath();
            if (this$projectPath == null ? other$projectPath != null : !this$projectPath.equals(other$projectPath)) {
                return false;
            }
            String this$configurationName = this.getConfigurationName();
            String other$configurationName = other.getConfigurationName();
            if (this$configurationName == null ? other$configurationName != null : !this$configurationName.equals(other$configurationName)) {
                return false;
            }
            String this$exceptionType = this.getExceptionType();
            String other$exceptionType = other.getExceptionType();
            if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
                return false;
            }
            String this$exceptionMessage = this.getExceptionMessage();
            String other$exceptionMessage = other.getExceptionMessage();
            return !(this$exceptionMessage == null ? other$exceptionMessage != null : !this$exceptionMessage.equals(other$exceptionMessage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $projectPath = this.getProjectPath();
            result = result * 59 + ($projectPath == null ? 43 : $projectPath.hashCode());
            String $configurationName = this.getConfigurationName();
            result = result * 59 + ($configurationName == null ? 43 : $configurationName.hashCode());
            String $exceptionType = this.getExceptionType();
            result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
            String $exceptionMessage = this.getExceptionMessage();
            result = result * 59 + ($exceptionMessage == null ? 43 : $exceptionMessage.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "GradleDependencyConfigurationErrors.Row(projectPath=" + this.getProjectPath() + ", configurationName=" + this.getConfigurationName() + ", exceptionType=" + this.getExceptionType() + ", exceptionMessage=" + this.getExceptionMessage() + ")";
        }
    }
}

