/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class LicenseReport
extends DataTable<Row> {
    public LicenseReport(Recipe recipe) {
        super(recipe, "License report", "Contains a license report of third-party dependencies.");
    }

    public static final class Row {
        @Column(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.")
        private final String groupId;
        @Column(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`.")
        private final String artifactId;
        @Column(displayName="Version", description="The resolved version.")
        private final String version;
        @Column(displayName="License name", description="The actual name of the license as written in the third-party dependency.")
        private final String licenseName;
        @Column(displayName="License type", description="The license in use, based on the category of license inferred from the name.")
        private final String licenseType;

        @ConstructorProperties(value={"groupId", "artifactId", "version", "licenseName", "licenseType"})
        @Generated
        public Row(String groupId, String artifactId, String version, String licenseName, String licenseType) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.licenseName = licenseName;
            this.licenseType = licenseType;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getLicenseName() {
            return this.licenseName;
        }

        @Generated
        public String getLicenseType() {
            return this.licenseType;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$licenseName = this.getLicenseName();
            String other$licenseName = other.getLicenseName();
            if (this$licenseName == null ? other$licenseName != null : !this$licenseName.equals(other$licenseName)) {
                return false;
            }
            String this$licenseType = this.getLicenseType();
            String other$licenseType = other.getLicenseType();
            return !(this$licenseType == null ? other$licenseType != null : !this$licenseType.equals(other$licenseType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $licenseName = this.getLicenseName();
            result = result * 59 + ($licenseName == null ? 43 : $licenseName.hashCode());
            String $licenseType = this.getLicenseType();
            result = result * 59 + ($licenseType == null ? 43 : $licenseType.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "LicenseReport.Row(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", licenseName=" + this.getLicenseName() + ", licenseType=" + this.getLicenseType() + ")";
        }
    }
}

