/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PathUtils;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.Sbom;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.xml.SemanticallyEqual;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class SoftwareBillOfMaterials
extends ScanningRecipe<Accumulator> {
    private static final XmlMapper xmlMapper = (XmlMapper)new XmlMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).enable(SerializationFeature.INDENT_OUTPUT);

    public String getDisplayName() {
        return "Software bill of materials";
    }

    public String getDescription() {
        return "Produces a software bill of materials (SBOM) for a project. An SBOM is a complete list of all dependencies used in a project, including transitive dependencies. The produced SBOM is in the [CycloneDX](https://cyclonedx.org/) XML format. Supports Gradle and Maven. Places a file named sbom.xml adjacent to the Gradle or Maven build file.";
    }

    public Set<String> getTags() {
        return Collections.singleton("CycloneDX");
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(Tree tree, ExecutionContext executionContext) {
                SourceFile s = (SourceFile)tree;
                if (s.getSourcePath().toString().endsWith("sbom.xml")) {
                    acc.existingSboms.add(s.getSourcePath());
                    return tree;
                }
                s.getMarkers().getMarkers().stream().filter(marker -> marker instanceof GradleProject || marker instanceof MavenResolutionResult).forEach(e -> {
                    String sbomPathString = PathUtils.separatorsToUnix((String)s.getSourcePath().toString());
                    sbomPathString = sbomPathString.substring(0, sbomPathString.lastIndexOf("/") + 1) + "sbom.xml";
                    Path sbomPath = Paths.get(sbomPathString, new String[0]);
                    acc2.sbomPaths.add(sbomPath);
                    acc2.sbomPathToDependencyMarker.put(sbomPath, (Marker)e);
                });
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, Collection<SourceFile> generatedInThisCycle, ExecutionContext ctx) {
        LinkedHashSet<Path> newSbomPaths = new LinkedHashSet<Path>(acc.sbomPaths);
        newSbomPaths.removeAll(acc.existingSboms);
        ArrayList newSboms = new ArrayList();
        XmlParser xmlParser = XmlParser.builder().build();
        for (Path sbomPath : newSbomPaths) {
            xmlParser.parse(ctx, new String[]{"<bom></bom>"}).map(it -> (Xml.Document)it.withSourcePath(sbomPath)).findAny().ifPresent(newSboms::add);
        }
        return newSboms;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new XmlVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                if (!acc.sbomPaths.contains(document.getSourcePath())) {
                    return document;
                }
                Marker marker = acc.sbomPathToDependencyMarker.get(document.getSourcePath());
                if (marker != null) {
                    Sbom.Bom sbom = Sbom.sbomFrom(marker);
                    try {
                        String rawSbom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xmlMapper.writeValueAsString((Object)sbom).replaceAll("\r", "") + "\n";
                        XmlParser xmlParser = XmlParser.builder().build();
                        Xml.Document d = xmlParser.parse(new String[]{rawSbom}).map(it -> it.withSourcePath(document.getSourcePath()).withId(document.getId())).map(Xml.Document.class::cast).findAny().get();
                        if (SemanticallyEqual.areEqual((Xml)document, (Xml)d)) {
                            return document;
                        }
                        return d;
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return document;
            }
        };
    }

    @Generated
    public SoftwareBillOfMaterials() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "SoftwareBillOfMaterials()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoftwareBillOfMaterials)) {
            return false;
        }
        SoftwareBillOfMaterials other = (SoftwareBillOfMaterials)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SoftwareBillOfMaterials;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Accumulator {
        Set<Path> existingSboms = new LinkedHashSet<Path>();
        Set<Path> sbomPaths = new LinkedHashSet<Path>();
        Map<Path, Marker> sbomPathToDependencyMarker = new HashMap<Path, Marker>();
    }
}

