/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpgradeDependencyVersion;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddManagedDependency;

public final class UpgradeTransitiveDependencyVersion
extends ScanningRecipe<AddManagedDependency.Scanned> {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.apache.logging.log4j:ARTIFACT_ID:VERSION'.", example="org.apache.logging.log4j")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.apache.logging.log4j:log4j-bom:VERSION'.", example="log4j-bom")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="latest.release")
    private final String version;
    @Option(displayName="Scope", description="An optional scope to use for the dependency management tag. Relevant only to Maven.", example="import", valid={"import", "runtime", "provided", "test"}, required=false)
    @Nullable
    private final String scope;
    @Option(displayName="Type", description="An optional type to use for the dependency management tag. Relevant only to Maven builds.", valid={"jar", "pom", "war"}, example="pom", required=false)
    @Nullable
    private final String type;
    @Option(displayName="Classifier", description="An optional classifier to use for the dependency management tag. Relevant only to Maven.", example="test", required=false)
    @Nullable
    private final String classifier;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration when using a semver selector", required=false)
    @Nullable
    private final Boolean releasesOnly;
    @Option(displayName="Only if using glob expression for group:artifact", description="Only add managed dependencies to projects having a dependency matching the expression.", example="org.apache.logging.log4j:log4j*", required=false)
    @Nullable
    private final String onlyIfUsing;
    @Option(displayName="Add to the root pom", description="Add to the root pom where root is the eldest parent of the pom within the source set.", required=false)
    @Nullable
    private final Boolean addToRootPom;

    public String getDisplayName() {
        return "Upgrade transitive Gradle or Maven dependencies";
    }

    public String getDescription() {
        return "Upgrades the version of a transitive dependency in a Maven pom.xml or Gradle build.gradle. Leaves direct dependencies unmodified. Can be paired with the regular Upgrade Dependency Version recipe to upgrade a dependency everywhere, regardless of whether it is direct or transitive.";
    }

    public AddManagedDependency.Scanned getInitialValue(ExecutionContext ctx) {
        return this.getMavenUpgradeDependencyVersion().getInitialValue(ctx);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AddManagedDependency.Scanned acc) {
        return this.getMavenUpgradeDependencyVersion().getScanner(acc);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AddManagedDependency.Scanned acc) {
        final TreeVisitor gradleUDV = new UpgradeDependencyVersion(this.groupId, this.artifactId, this.version, this.versionPattern).getVisitor();
        final TreeVisitor mavenUTDV = this.getMavenUpgradeDependencyVersion().getVisitor(acc);
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile t = (SourceFile)tree;
                if (gradleUDV.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)gradleUDV.visitNonNull((Tree)t, (Object)ctx);
                } else if (mavenUTDV.isAcceptable(t, (Object)ctx)) {
                    t = (SourceFile)mavenUTDV.visitNonNull((Tree)t, (Object)ctx);
                }
                return t;
            }
        };
    }

    private org.openrewrite.maven.UpgradeTransitiveDependencyVersion getMavenUpgradeDependencyVersion() {
        return new org.openrewrite.maven.UpgradeTransitiveDependencyVersion(this.groupId, this.artifactId, this.version, this.versionPattern, this.scope, this.type, this.versionPattern, this.releasesOnly, this.onlyIfUsing, this.addToRootPom);
    }

    @ConstructorProperties(value={"groupId", "artifactId", "version", "scope", "type", "classifier", "versionPattern", "releasesOnly", "onlyIfUsing", "addToRootPom"})
    @Generated
    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String versionPattern, @Nullable Boolean releasesOnly, @Nullable String onlyIfUsing, @Nullable Boolean addToRootPom) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.versionPattern = versionPattern;
        this.releasesOnly = releasesOnly;
        this.onlyIfUsing = onlyIfUsing;
        this.addToRootPom = addToRootPom;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Nullable
    @Generated
    public String getScope() {
        return this.scope;
    }

    @Nullable
    @Generated
    public String getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    @Generated
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    @Generated
    public Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Nullable
    @Generated
    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    @Generated
    public Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeTransitiveDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", versionPattern=" + this.getVersionPattern() + ", releasesOnly=" + this.getReleasesOnly() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", addToRootPom=" + this.getAddToRootPom() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeTransitiveDependencyVersion)) {
            return false;
        }
        UpgradeTransitiveDependencyVersion other = (UpgradeTransitiveDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        return !(this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeTransitiveDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        return result;
    }
}

