/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class AddDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Only if using", description="Used to determine if the dependency will be added and in which scope it should be placed.", example="org.junit.jupiter.api.*", required=false)
    @Nullable
    private final String onlyIfUsing;
    @Option(displayName="Classifier", description="A classifier to add. Commonly used to select variants of a library.", example="test", required=false)
    @Nullable
    private final String classifier;
    @Option(displayName="Family pattern", description="A pattern, applied to groupIds, used to determine which other dependencies should have aligned version numbers. Accepts '*' as a wildcard character.", example="com.fasterxml.jackson*", required=false)
    @Nullable
    private final String familyPattern;
    @Option(displayName="Extension", description="For Gradle only, The extension of the dependency to add. If omitted Gradle defaults to assuming the type is \"jar\".", example="jar", required=false)
    @Nullable
    private final String extension;
    @Option(displayName="Configuration", description="For Gradle only, A configuration to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a new as of yet unused dependency.", example="implementation", required=false)
    @Nullable
    private final String configuration;
    @Option(displayName="Scope", description="For Maven only, A scope to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a runtime, provided, or import dependency.", example="runtime", valid={"import", "runtime", "provided"}, required=false)
    @Nullable
    private final String scope;
    @Option(displayName="Releases only", description="For Maven only, Whether to exclude snapshots from consideration when using a semver selector", required=false)
    @Nullable
    private final Boolean releasesOnly;
    @Option(displayName="Type", description="For Maven only, The type of dependency to add. If omitted Maven defaults to assuming the type is \"jar\".", valid={"jar", "pom", "war"}, example="jar", required=false)
    @Nullable
    private final String type;
    @Option(displayName="Optional", description="Set the value of the `<optional>` tag. No `<optional>` tag will be added when this is `null`.", required=false)
    @Nullable
    private final Boolean optional;
    @Option(displayName="Accept transitive", description="Default false. If enabled, the dependency will not be added if it is already on the classpath as a transitive dependency.", example="true", required=false)
    @Nullable
    private final Boolean acceptTransitive;
    @Nullable
    private final org.openrewrite.gradle.AddDependency addGradleDependency;
    @Nullable
    private final org.openrewrite.maven.AddDependency addMavenDependency;

    public String getDisplayName() {
        return "Add Gradle or Maven dependency";
    }

    public String getDescription() {
        return "For a Gradle project, add a gradle dependency to a `build.gradle` file in the correct configuration based on where it is used. Or For a maven project, Add a Maven dependency to a `pom.xml` file in the correct scope based on where it is used.";
    }

    public AddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, String onlyIfUsing, @Nullable String classifier, @Nullable String familyPattern, @Nullable String extension, @Nullable String configuration, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable Boolean optional, @Nullable Boolean acceptTransitive) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.onlyIfUsing = onlyIfUsing;
        this.classifier = classifier;
        this.familyPattern = familyPattern;
        this.extension = extension;
        this.configuration = configuration;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.optional = optional;
        this.acceptTransitive = acceptTransitive;
        this.addGradleDependency = new org.openrewrite.gradle.AddDependency(groupId, artifactId, version, versionPattern, configuration, onlyIfUsing, classifier, extension, familyPattern, acceptTransitive);
        String versionForMaven = version != null ? version : "latest.release";
        this.addMavenDependency = new org.openrewrite.maven.AddDependency(groupId, artifactId, versionForMaven, versionPattern, scope, releasesOnly, onlyIfUsing, type, classifier, optional, familyPattern, acceptTransitive);
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(this.addGradleDependency, this.addMavenDependency);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getFamilyPattern() {
        return this.familyPattern;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public Boolean getOptional() {
        return this.optional;
    }

    @Nullable
    public Boolean getAcceptTransitive() {
        return this.acceptTransitive;
    }

    @Nullable
    public org.openrewrite.gradle.AddDependency getAddGradleDependency() {
        return this.addGradleDependency;
    }

    @Nullable
    public org.openrewrite.maven.AddDependency getAddMavenDependency() {
        return this.addMavenDependency;
    }

    @NonNull
    public String toString() {
        return "AddDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", classifier=" + this.getClassifier() + ", familyPattern=" + this.getFamilyPattern() + ", extension=" + this.getExtension() + ", configuration=" + this.getConfiguration() + ", scope=" + this.getScope() + ", releasesOnly=" + this.getReleasesOnly() + ", type=" + this.getType() + ", optional=" + this.getOptional() + ", acceptTransitive=" + this.getAcceptTransitive() + ", addGradleDependency=" + this.getAddGradleDependency() + ", addMavenDependency=" + this.getAddMavenDependency() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$optional = this.getOptional();
        Boolean other$optional = other.getOptional();
        if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
            return false;
        }
        Boolean this$acceptTransitive = this.getAcceptTransitive();
        Boolean other$acceptTransitive = other.getAcceptTransitive();
        if (this$acceptTransitive == null ? other$acceptTransitive != null : !((Object)this$acceptTransitive).equals(other$acceptTransitive)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$familyPattern = this.getFamilyPattern();
        String other$familyPattern = other.getFamilyPattern();
        if (this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        org.openrewrite.gradle.AddDependency this$addGradleDependency = this.getAddGradleDependency();
        org.openrewrite.gradle.AddDependency other$addGradleDependency = other.getAddGradleDependency();
        if (this$addGradleDependency == null ? other$addGradleDependency != null : !this$addGradleDependency.equals(other$addGradleDependency)) {
            return false;
        }
        org.openrewrite.maven.AddDependency this$addMavenDependency = this.getAddMavenDependency();
        org.openrewrite.maven.AddDependency other$addMavenDependency = other.getAddMavenDependency();
        return !(this$addMavenDependency == null ? other$addMavenDependency != null : !this$addMavenDependency.equals(other$addMavenDependency));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $optional = this.getOptional();
        result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
        Boolean $acceptTransitive = this.getAcceptTransitive();
        result = result * 59 + ($acceptTransitive == null ? 43 : ((Object)$acceptTransitive).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $familyPattern = this.getFamilyPattern();
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        org.openrewrite.gradle.AddDependency $addGradleDependency = this.getAddGradleDependency();
        result = result * 59 + ($addGradleDependency == null ? 43 : $addGradleDependency.hashCode());
        org.openrewrite.maven.AddDependency $addMavenDependency = this.getAddMavenDependency();
        result = result * 59 + ($addMavenDependency == null ? 43 : $addMavenDependency.hashCode());
        return result;
    }
}

