/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.Vulnerability;
import org.openrewrite.java.dependencies.internal.StaticVersionComparator;
import org.openrewrite.java.dependencies.internal.VersionParser;
import org.openrewrite.java.dependencies.table.VulnerabilityReport;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.xml.tree.Xml;

public final class DependencyVulnerabilityCheck
extends ScanningRecipe<Accumulator> {
    private final transient VersionParser versionParser = new VersionParser();
    private final transient VulnerabilityReport report = new VulnerabilityReport((Recipe)this);
    @Option(displayName="Scope", description="Match dependencies with the specified scope", valid={"compile", "test", "runtime", "provided"}, example="compile")
    private final String scope;
    @Option(displayName="Override managed version", description="This flag can be set to explicitly override a managed dependency's version. The default for this flag is `false`.", example="false", required=false)
    @Nullable
    private final Boolean overrideManagedVersion;
    @Option(displayName="Add markers", description="Report each vulnerability in search results. If this is off, it is easier to see suggested changes.", required=false)
    @Nullable
    private final Boolean addMarkers;

    public String getDisplayName() {
        return "Check for dependency vulnerabilities";
    }

    public String getDescription() {
        return "This is a software composition analysis (SCA) tool which detects publicly disclosed vulnerabilities. If vulnerabilities are found, it will generate a report linking to the associated CVE entries. Vulnerability information comes from the [GitHub Security Advisory Database](https://docs.github.com/en/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database), which aggregates vulnerability data from several public databases, including the [National Vulnerability Database](https://nvd.nist.gov/) maintained by the United States government. Dependencies following [Semantic Versioning](https://semver.org/) will see their _patch_ version updated where applicable.";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"scope", (String)"scope is a valid Maven scope", (Object)this.scope, s -> {
            try {
                Scope.fromName((String)s);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }));
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        Scope parsedScope = Scope.fromName((String)this.scope);
        CsvMapper csvMapper = new CsvMapper();
        HashMap<GroupArtifact, List<Vulnerability>> db = new HashMap<GroupArtifact, List<Vulnerability>>();
        try {
            CsvSchema schema = CsvSchema.builder().addColumn("cve").addColumn("published").addColumn("summary").addColumn("groupArtifact").addColumn("introducedVersion").addColumn("fixedVersion").addColumn("severity").build();
            MappingIterator vs = csvMapper.readerForMapOf(String.class).with((FormatSchema)schema).readValues(DependencyVulnerabilityCheck.class.getResourceAsStream("/advisories.csv"));
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new ParameterNamesModule());
            while (vs.hasNextValue()) {
                Vulnerability v = (Vulnerability)mapper.convertValue(vs.nextValue(), Vulnerability.class);
                String[] ga = v.getGroupArtifact().split(":");
                db.computeIfAbsent(new GroupArtifact(ga[0], ga[1]), g -> new ArrayList()).add(v);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Accumulator(db, new HashMap<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>>(), parsedScope, new HashSet<GroupArtifact>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                DependencyVulnerabilityCheck.this.scanMaven(acc.getDb(), acc.getVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                DependencyVulnerabilityCheck.this.scanGradleGroovy(acc.getDb(), acc.getVulnerabilities(), acc.getScope()).visitNonNull(tree, (Object)ctx);
                new UpgradeDependencyVersion("", "", "", null, null, null).getScanner(acc.getUdvAcc()).visit(tree, (Object)ctx);
                return tree;
            }
        };
    }

    public Collection<SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        for (Map.Entry<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilitiesByGav : acc.getVulnerabilities().entrySet()) {
            for (MinimumDepthVulnerability vDepth : vulnerabilitiesByGav.getValue()) {
                Vulnerability v = vDepth.getVulnerability();
                ResolvedGroupArtifactVersion gav = vulnerabilitiesByGav.getKey();
                boolean fixWithVersionUpdateOnly = new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion());
                this.report.insertRow(ctx, new VulnerabilityReport.Row(v.getCve(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), v.getFixedVersion(), fixWithVersionUpdateOnly, v.getSummary(), v.getSeverity().toString(), vDepth.getMinDepth()));
            }
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t;
                block4: {
                    block3: {
                        if (tree == null) {
                            return null;
                        }
                        t = tree;
                        if (!t.getMarkers().findFirst(MavenResolutionResult.class).isPresent()) break block3;
                        HashMap fixes = new HashMap();
                        t = DependencyVulnerabilityCheck.this.fixMaven(acc.getVulnerabilities(), acc.getScope(), fixes).visitNonNull(t, (Object)ctx);
                        for (Map.Entry gav : fixes.entrySet()) {
                            t = new UpgradeDependencyVersion(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), (String)gav.getValue(), null, DependencyVulnerabilityCheck.this.overrideManagedVersion, null).getVisitor(acc.getUdvAcc()).visitNonNull(t, (Object)ctx);
                        }
                        break block4;
                    }
                    if (!t.getMarkers().findFirst(GradleProject.class).isPresent()) break block4;
                    HashMap fixes = new HashMap();
                    t = DependencyVulnerabilityCheck.this.fixGradleGroovy(acc.getVulnerabilities(), acc.getScope(), fixes).visitNonNull(t, (Object)ctx);
                    for (Map.Entry gav : fixes.entrySet()) {
                        t = new org.openrewrite.gradle.UpgradeDependencyVersion(((GroupArtifact)gav.getKey()).getGroupId(), ((GroupArtifact)gav.getKey()).getArtifactId(), (String)gav.getValue(), null).getVisitor().visitNonNull(t, (Object)ctx);
                    }
                }
                return t;
            }
        };
    }

    private MavenVisitor<ExecutionContext> scanMaven(final Map<GroupArtifact, List<Vulnerability>> db, final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                List scopeDependencies = (List)this.getResolutionResult().getDependencies().get(aScope);
                if (scopeDependencies != null) {
                    for (ResolvedDependency resolvedDependency : scopeDependencies) {
                        DependencyVulnerabilityCheck.this.analyzeDependency(db, vulnerabilities, resolvedDependency);
                    }
                }
                return super.visitDocument(document, (Object)ctx);
            }
        };
    }

    private static boolean scopeExcludesConfiguration(GradleDependencyConfiguration configuration, Scope scope) {
        switch (scope) {
            case Test: {
                return !configuration.getName().contains("test");
            }
            case Compile: 
            case Runtime: {
                return configuration.getName().contains("test");
            }
            case Provided: {
                return !configuration.getName().contains("provided") && !configuration.getName().contains("compileOnly");
            }
        }
        return false;
    }

    private GroovyVisitor<ExecutionContext> scanGradleGroovy(final Map<GroupArtifact, List<Vulnerability>> db, final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                cu.getMarkers().findFirst(GradleProject.class).ifPresent(gradleProject -> {
                    for (GradleDependencyConfiguration configuration : gradleProject.getConfigurations()) {
                        if (DependencyVulnerabilityCheck.scopeExcludesConfiguration(configuration, aScope)) continue;
                        for (ResolvedDependency resolvedDependency : configuration.getResolved()) {
                            if (StringUtils.isBlank((String)resolvedDependency.getVersion())) continue;
                            DependencyVulnerabilityCheck.this.analyzeDependency(db, vulnerabilities, resolvedDependency);
                        }
                    }
                });
                return super.visitCompilationUnit(cu, (Object)ctx);
            }
        };
    }

    private void analyzeDependency(Map<GroupArtifact, List<Vulnerability>> db, Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, ResolvedDependency resolvedDependency) {
        List<Vulnerability> vs = db.get(new GroupArtifact(resolvedDependency.getGroupId(), resolvedDependency.getArtifactId()));
        if (vs != null) {
            Set gavVs = null;
            StaticVersionComparator vc = new StaticVersionComparator();
            block0: for (Vulnerability v : vs) {
                boolean isLessThanFixed = StringUtils.isBlank((String)v.getFixedVersion());
                if (!isLessThanFixed) {
                    if (resolvedDependency.getVersion().endsWith(".RELEASE")) {
                        String versionWithoutRelease = resolvedDependency.getVersion().substring(0, resolvedDependency.getVersion().length() - ".RELEASE".length());
                        if (vc.compare(this.versionParser.transform(v.getFixedVersion()), this.versionParser.transform(versionWithoutRelease)) > 0) {
                            isLessThanFixed = true;
                        }
                    } else if (vc.compare(this.versionParser.transform(v.getFixedVersion()), this.versionParser.transform(resolvedDependency.getVersion())) > 0) {
                        isLessThanFixed = true;
                    }
                }
                if (!isLessThanFixed || vc.compare(this.versionParser.transform(v.getIntroducedVersion()), this.versionParser.transform(resolvedDependency.getVersion())) > 0) continue;
                if (gavVs == null) {
                    gavVs = vulnerabilities.computeIfAbsent(resolvedDependency.getGav(), ga -> new TreeSet<MinimumDepthVulnerability>(Comparator.comparing(vDep -> vDep.getVulnerability().getSeverity()).reversed().thenComparing(vDep -> vDep.getVulnerability().getCve())));
                }
                for (MinimumDepthVulnerability vDep : gavVs) {
                    if (!vDep.getVulnerability().equals(v)) continue;
                    vDep.minDepth = Math.min(vDep.minDepth, resolvedDependency.getDepth());
                    continue block0;
                }
                gavVs.add(new MinimumDepthVulnerability(resolvedDependency.getDepth(), v));
            }
        }
    }

    private MavenVisitor<ExecutionContext> fixMaven(final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope, final Map<GroupArtifact, String> fixes) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ResolvedDependency resolved;
                if (this.isDependencyTag() && (resolved = this.findDependency(tag, aScope)) != null) {
                    for (Map.Entry vulnerabilitiesByGav : vulnerabilities.entrySet()) {
                        ResolvedGroupArtifactVersion gav = (ResolvedGroupArtifactVersion)vulnerabilitiesByGav.getKey();
                        ResolvedDependency match = resolved.findDependency(Objects.requireNonNull(gav.getGroupId()), gav.getArtifactId());
                        if (match == null) continue;
                        boolean vulnerable = false;
                        for (MinimumDepthVulnerability vDepth2 : (Set)vulnerabilitiesByGav.getValue()) {
                            Vulnerability v = vDepth2.getVulnerability();
                            vulnerable = true;
                            GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                            String fixVersion = (String)fixes.get(ga);
                            if (StringUtils.isBlank((String)v.getFixedVersion()) || !new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion()) || fixVersion != null && new StaticVersionComparator().compare(DependencyVulnerabilityCheck.this.versionParser.transform(v.getFixedVersion()), DependencyVulnerabilityCheck.this.versionParser.transform(fixVersion)) <= 0) continue;
                            fixes.put(ga, v.getFixedVersion());
                        }
                        if (!vulnerable || !Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.addMarkers)) continue;
                        return (Xml.Tag)SearchResult.found((Tree)tag, (String)("This dependency includes " + gav + " which has the following vulnerabilities:\n" + ((Set)vulnerabilitiesByGav.getValue()).stream().map(vDepth -> {
                            Vulnerability v = vDepth.getVulnerability();
                            return v.getCve() + " (" + (Object)((Object)v.getSeverity()) + " severity" + (StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion()) + ") - " + v.getSummary();
                        }).collect(Collectors.joining("\n"))));
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    private GroovyVisitor<ExecutionContext> fixGradleGroovy(final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, final Scope aScope, final Map<GroupArtifact, String> fixes) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit c = cu;
                GradleProject gp = (GradleProject)c.getMarkers().findFirst(GradleProject.class).get();
                for (Map.Entry vulnerabilitiesByGav : vulnerabilities.entrySet()) {
                    ResolvedGroupArtifactVersion gav = (ResolvedGroupArtifactVersion)vulnerabilitiesByGav.getKey();
                    if (Boolean.TRUE.equals(DependencyVulnerabilityCheck.this.addMarkers)) {
                        c = (G.CompilationUnit)SearchResult.found((Tree)c, (String)("This project has the following vulnerabilities:\n" + ((Set)vulnerabilitiesByGav.getValue()).stream().map(vDepth -> {
                            Vulnerability v = vDepth.getVulnerability();
                            return "Dependency " + gav + " has " + v.getCve() + " (" + (Object)((Object)v.getSeverity()) + " severity" + (StringUtils.isBlank((String)v.getFixedVersion()) ? "" : ", fixed in " + v.getFixedVersion()) + ") - " + v.getSummary();
                        }).collect(Collectors.joining("\n"))));
                    }
                    for (GradleDependencyConfiguration configuration : gp.getConfigurations()) {
                        if (DependencyVulnerabilityCheck.scopeExcludesConfiguration(configuration, aScope) || !configuration.isCanBeResolved()) continue;
                        List resolved = configuration.getResolved();
                        for (ResolvedDependency resolvedDependency : resolved) {
                            if (!Objects.equals(resolvedDependency.getGroupId(), gav.getGroupId()) || !Objects.equals(resolvedDependency.getArtifactId(), gav.getArtifactId())) continue;
                            for (MinimumDepthVulnerability vDepth2 : (Set)vulnerabilitiesByGav.getValue()) {
                                Vulnerability v = vDepth2.getVulnerability();
                                GroupArtifact ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId());
                                String fixVersion = (String)fixes.get(ga);
                                if (StringUtils.isBlank((String)v.getFixedVersion()) || !new LatestPatch(null).isValid(gav.getVersion(), v.getFixedVersion()) || fixVersion != null && new StaticVersionComparator().compare(DependencyVulnerabilityCheck.this.versionParser.transform(v.getFixedVersion()), DependencyVulnerabilityCheck.this.versionParser.transform(fixVersion)) <= 0) continue;
                                fixes.put(ga, v.getFixedVersion());
                            }
                        }
                    }
                }
                return c;
            }
        };
    }

    @ConstructorProperties(value={"scope", "overrideManagedVersion", "addMarkers"})
    public DependencyVulnerabilityCheck(String scope, @Nullable Boolean overrideManagedVersion, @Nullable Boolean addMarkers) {
        this.scope = scope;
        this.overrideManagedVersion = overrideManagedVersion;
        this.addMarkers = addMarkers;
    }

    public VersionParser getVersionParser() {
        return this.versionParser;
    }

    public VulnerabilityReport getReport() {
        return this.report;
    }

    public String getScope() {
        return this.scope;
    }

    @Nullable
    public Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Nullable
    public Boolean getAddMarkers() {
        return this.addMarkers;
    }

    @NonNull
    public String toString() {
        return "DependencyVulnerabilityCheck(versionParser=" + this.getVersionParser() + ", report=" + (Object)((Object)this.getReport()) + ", scope=" + this.getScope() + ", overrideManagedVersion=" + this.getOverrideManagedVersion() + ", addMarkers=" + this.getAddMarkers() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVulnerabilityCheck)) {
            return false;
        }
        DependencyVulnerabilityCheck other = (DependencyVulnerabilityCheck)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        Boolean this$addMarkers = this.getAddMarkers();
        Boolean other$addMarkers = other.getAddMarkers();
        if (this$addMarkers == null ? other$addMarkers != null : !((Object)this$addMarkers).equals(other$addMarkers)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyVulnerabilityCheck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        Boolean $addMarkers = this.getAddMarkers();
        result = result * 59 + ($addMarkers == null ? 43 : ((Object)$addMarkers).hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }

    static final class Accumulator {
        private final Map<GroupArtifact, List<Vulnerability>> db;
        private final Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities;
        private final Scope scope;
        private final Set<GroupArtifact> udvAcc;

        @ConstructorProperties(value={"db", "vulnerabilities", "scope", "udvAcc"})
        public Accumulator(Map<GroupArtifact, List<Vulnerability>> db, Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> vulnerabilities, Scope scope, Set<GroupArtifact> udvAcc) {
            this.db = db;
            this.vulnerabilities = vulnerabilities;
            this.scope = scope;
            this.udvAcc = udvAcc;
        }

        public Map<GroupArtifact, List<Vulnerability>> getDb() {
            return this.db;
        }

        public Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> getVulnerabilities() {
            return this.vulnerabilities;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Set<GroupArtifact> getUdvAcc() {
            return this.udvAcc;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Map<GroupArtifact, List<Vulnerability>> this$db = this.getDb();
            Map<GroupArtifact, List<Vulnerability>> other$db = other.getDb();
            if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
                return false;
            }
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> this$vulnerabilities = this.getVulnerabilities();
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> other$vulnerabilities = other.getVulnerabilities();
            if (this$vulnerabilities == null ? other$vulnerabilities != null : !((Object)this$vulnerabilities).equals(other$vulnerabilities)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            Set<GroupArtifact> this$udvAcc = this.getUdvAcc();
            Set<GroupArtifact> other$udvAcc = other.getUdvAcc();
            return !(this$udvAcc == null ? other$udvAcc != null : !((Object)this$udvAcc).equals(other$udvAcc));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<GroupArtifact, List<Vulnerability>> $db = this.getDb();
            result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
            Map<ResolvedGroupArtifactVersion, Set<MinimumDepthVulnerability>> $vulnerabilities = this.getVulnerabilities();
            result = result * 59 + ($vulnerabilities == null ? 43 : ((Object)$vulnerabilities).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            Set<GroupArtifact> $udvAcc = this.getUdvAcc();
            result = result * 59 + ($udvAcc == null ? 43 : ((Object)$udvAcc).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DependencyVulnerabilityCheck.Accumulator(db=" + this.getDb() + ", vulnerabilities=" + this.getVulnerabilities() + ", scope=" + this.getScope() + ", udvAcc=" + this.getUdvAcc() + ")";
        }
    }

    private static final class MinimumDepthVulnerability {
        private int minDepth;
        private final Vulnerability vulnerability;

        @ConstructorProperties(value={"minDepth", "vulnerability"})
        public MinimumDepthVulnerability(int minDepth, Vulnerability vulnerability) {
            this.minDepth = minDepth;
            this.vulnerability = vulnerability;
        }

        public int getMinDepth() {
            return this.minDepth;
        }

        public Vulnerability getVulnerability() {
            return this.vulnerability;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinimumDepthVulnerability)) {
                return false;
            }
            MinimumDepthVulnerability other = (MinimumDepthVulnerability)o;
            if (this.getMinDepth() != other.getMinDepth()) {
                return false;
            }
            Vulnerability this$vulnerability = this.getVulnerability();
            Vulnerability other$vulnerability = other.getVulnerability();
            return !(this$vulnerability == null ? other$vulnerability != null : !((Object)this$vulnerability).equals(other$vulnerability));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinDepth();
            Vulnerability $vulnerability = this.getVulnerability();
            result = result * 59 + ($vulnerability == null ? 43 : ((Object)$vulnerability).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DependencyVulnerabilityCheck.MinimumDepthVulnerability(minDepth=" + this.getMinDepth() + ", vulnerability=" + this.getVulnerability() + ")";
        }
    }
}

