/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class BotConditionsRecipe
extends Recipe {
    private static final Set<String> KNOWN_BOT_ACTOR_IDS = new HashSet<String>(Arrays.asList("29110", "49699333", "27856297", "29139614"));
    private static final Pattern[] SPOOFABLE_ACTOR_NAME_PATTERNS = new Pattern[]{Pattern.compile("github\\.actor\\s*==\\s*['\"][^'\"]*\\[bot\\]['\"]"), Pattern.compile("github\\.triggering_actor\\s*==\\s*['\"][^'\"]*\\[bot\\]['\"]"), Pattern.compile("github\\.event\\.pull_request\\.sender\\.login\\s*==\\s*['\"][^'\"]*\\[bot\\]['\"]"), Pattern.compile("github\\.actor\\s*==\\s*['\"]dependabot\\[bot\\]['\"]"), Pattern.compile("github\\.actor\\s*==\\s*['\"]renovate\\[bot\\]['\"]"), Pattern.compile("github\\.actor\\s*==\\s*['\"][^'\"]*bot[^'\"]*['\"]")};
    private static final Pattern CONTAINS_BOT_PATTERN = Pattern.compile("contains\\s*\\(\\s*github\\.[^,]+,\\s*['\"]bot['\"]\\s*\\)");
    private static final Pattern ACTOR_ID_STRING_PATTERN = Pattern.compile("github\\.(actor_id|event\\.pull_request\\.sender\\.id)\\s*==\\s*['\"]\\d+['\"]");
    private final String displayName = "Find spoofable bot actor checks";
    private final String description = "Find workflow conditions that check for bot actors in ways that can be spoofed. Bot actor names (like `dependabot[bot]`) can be easily spoofed by creating accounts with similar names. Use `actor_id` with numeric comparison instead for secure bot validation. Based on [zizmor's `bot-conditions` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/bot_conditions.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new BotConditionsVisitor());
    }

    @Generated
    public BotConditionsRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "BotConditionsRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotConditionsRecipe)) {
            return false;
        }
        BotConditionsRecipe other = (BotConditionsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BotConditionsRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class BotConditionsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private BotConditionsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isIfEntry(mappingEntry)) {
                return this.checkIfCondition(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isIfEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "if".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkIfCondition(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String condition = ((Yaml.Scalar)entry.getValue()).getValue();
            for (Pattern pattern : SPOOFABLE_ACTOR_NAME_PATTERNS) {
                if (!pattern.matcher(condition).find()) continue;
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Bot actor name check is spoofable. Consider using actor_id instead for more secure bot validation.");
            }
            if (CONTAINS_BOT_PATTERN.matcher(condition).find()) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Bot actor check using contains() is unreliable and spoofable. Use exact actor_id comparison instead.");
            }
            if (ACTOR_ID_STRING_PATTERN.matcher(condition).find()) {
                for (String botId : KNOWN_BOT_ACTOR_IDS) {
                    if (!condition.contains("'" + botId + "'") && !condition.contains("\"" + botId + "\"")) continue;
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Using string comparison for actor_id. Consider using numeric comparison for better reliability.");
                }
            }
            return entry;
        }
    }
}

