/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class AddDependabotCooldown
extends Recipe {
    @Option(displayName="Default cooldown days", description="The number of days to wait before considering a published dependency suitable for use (1-90). This delay allows security vendors time to identify potential compromises. Applied to all version types unless specific semver options are set.", example="7", required=false)
    private final @Nullable Integer cooldownDays;
    @Option(displayName="Semver major cooldown days", description="The number of days to wait for major version updates (1-90). Only applies to package managers that support semantic versioning.", example="14", required=false)
    private final @Nullable Integer semverMajorDays;
    @Option(displayName="Semver minor cooldown days", description="The number of days to wait for minor version updates (1-90). Only applies to package managers that support semantic versioning.", example="7", required=false)
    private final @Nullable Integer semverMinorDays;
    @Option(displayName="Semver patch cooldown days", description="The number of days to wait for patch version updates (1-90). Only applies to package managers that support semantic versioning.", example="3", required=false)
    private final @Nullable Integer semverPatchDays;
    @Option(displayName="Include dependencies", description="List of up to 150 dependencies to apply cooldown to. Supports wildcard patterns with `*`. If not specified, cooldown applies to all dependencies.", example="lodash, react*", required=false)
    private final @Nullable List<String> include;
    @Option(displayName="Exclude dependencies", description="List of up to 150 dependencies to exempt from cooldown. Supports wildcard patterns with `*`. Exclude list takes precedence over include list.", example="critical-security-package", required=false)
    private final @Nullable List<String> exclude;
    private final String displayName = "Add cooldown periods to Dependabot configuration";
    private final String description = "Adds a `cooldown` section to each update configuration in Dependabot files. Supports `default-days`, `semver-major-days`, `semver-minor-days`, `semver-patch-days`, `include`, and `exclude` options. This implements a security best practice where dependencies are not immediately adopted upon release, allowing time for security vendors to identify potential supply chain compromises. Cooldown applies only to version updates, not security updates. [Read more about dependency cooldowns](https://blog.yossarian.net/2025/11/21/We-should-all-be-using-dependency-cooldowns). [The available configuration options for dependabot are listed on GitHub](https://docs.github.com/en/code-security/supply-chain-security/keeping-your-dependencies-updated-automatically/configuration-options-for-dependency-updates).";

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add("dependabot");
        tags.add("dependencies");
        tags.add("github");
        tags.add("security");
        return tags;
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        int days = this.cooldownDays == null ? 7 : this.cooldownDays;
        Predicate<Integer> lessThanNinety = d -> d >= 1 && d <= 90;
        validated = validated.and(Validated.test((String)"cooldownDays", (String)"must be between 1 and 90", (Object)days, lessThanNinety));
        if (this.semverMajorDays != null) {
            validated = validated.and(Validated.test((String)"semverMajorDays", (String)"must be between 1 and 90", (Object)this.semverMajorDays, lessThanNinety));
        }
        if (this.semverMinorDays != null) {
            validated = validated.and(Validated.test((String)"semverMinorDays", (String)"must be between 1 and 90", (Object)this.semverMinorDays, lessThanNinety));
        }
        if (this.semverPatchDays != null) {
            validated = validated.and(Validated.test((String)"semverPatchDays", (String)"must be between 1 and 90", (Object)this.semverPatchDays, lessThanNinety));
        }
        if (this.include != null) {
            validated = validated.and(Validated.test((String)"include", (String)"list limited to 150 items", this.include, i -> i.size() <= 150));
        }
        if (this.exclude != null) {
            validated = validated.and(Validated.test((String)"exclude", (String)"list limited to 150 items", this.exclude, e -> e.size() <= 150));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/dependabot.{yml,yaml}"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private final JsonPathMatcher packageEcosystemMatch = new JsonPathMatcher("$.updates[*].package-ecosystem");

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (this.packageEcosystemMatch.matches(this.getCursor())) {
                    this.getCursor().dropParentUntil(Yaml.Mapping.class::isInstance).putMessage("ADD_COOLDOWN", (Object)true);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }

            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                boolean hasCooldown;
                Yaml.Mapping m = super.visitMapping(mapping, (Object)ctx);
                if (Boolean.TRUE.equals(this.getCursor().pollMessage("ADD_COOLDOWN")) && !(hasCooldown = m.getEntries().stream().anyMatch(entry -> "cooldown".equals(entry.getKey().getValue())))) {
                    String yamlToMerge = this.cooldownYaml();
                    Yaml.Documents documents = new YamlParser().parse(ctx, new String[]{yamlToMerge}).map(Yaml.Documents.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Failed to parse cooldown YAML"));
                    Yaml.Mapping cooldownMapping = (Yaml.Mapping)((Yaml.Document)documents.getDocuments().get(0)).getBlock();
                    Yaml.Mapping.Entry cooldownEntry = (Yaml.Mapping.Entry)cooldownMapping.getEntries().get(0);
                    cooldownEntry = (Yaml.Mapping.Entry)this.autoFormat((Yaml)cooldownEntry, ctx, this.getCursor());
                    m = m.withEntries(ListUtils.concat((List)m.getEntries(), (Object)cooldownEntry));
                }
                return m;
            }

            private String cooldownYaml() {
                int days = AddDependabotCooldown.this.cooldownDays == null ? 7 : AddDependabotCooldown.this.cooldownDays;
                StringBuilder cooldownYaml = new StringBuilder();
                cooldownYaml.append("cooldown:\n");
                cooldownYaml.append("  default-days: ").append(days).append("\n");
                if (AddDependabotCooldown.this.semverMajorDays != null) {
                    cooldownYaml.append("  semver-major-days: ").append(AddDependabotCooldown.this.semverMajorDays).append("\n");
                }
                if (AddDependabotCooldown.this.semverMinorDays != null) {
                    cooldownYaml.append("  semver-minor-days: ").append(AddDependabotCooldown.this.semverMinorDays).append("\n");
                }
                if (AddDependabotCooldown.this.semverPatchDays != null) {
                    cooldownYaml.append("  semver-patch-days: ").append(AddDependabotCooldown.this.semverPatchDays).append("\n");
                }
                if (AddDependabotCooldown.this.include != null && !AddDependabotCooldown.this.include.isEmpty()) {
                    cooldownYaml.append("  include:\n");
                    for (String dep : AddDependabotCooldown.this.include) {
                        cooldownYaml.append("    - ").append(dep).append("\n");
                    }
                }
                if (AddDependabotCooldown.this.exclude != null && !AddDependabotCooldown.this.exclude.isEmpty()) {
                    cooldownYaml.append("  exclude:\n");
                    for (String dep : AddDependabotCooldown.this.exclude) {
                        cooldownYaml.append("    - ").append(dep).append("\n");
                    }
                }
                return cooldownYaml.toString();
            }
        });
    }

    @Generated
    public AddDependabotCooldown(@Nullable Integer cooldownDays, @Nullable Integer semverMajorDays, @Nullable Integer semverMinorDays, @Nullable Integer semverPatchDays, @Nullable List<String> include, @Nullable List<String> exclude) {
        this.cooldownDays = cooldownDays;
        this.semverMajorDays = semverMajorDays;
        this.semverMinorDays = semverMinorDays;
        this.semverPatchDays = semverPatchDays;
        this.include = include;
        this.exclude = exclude;
    }

    @Generated
    public @Nullable Integer getCooldownDays() {
        return this.cooldownDays;
    }

    @Generated
    public @Nullable Integer getSemverMajorDays() {
        return this.semverMajorDays;
    }

    @Generated
    public @Nullable Integer getSemverMinorDays() {
        return this.semverMinorDays;
    }

    @Generated
    public @Nullable Integer getSemverPatchDays() {
        return this.semverPatchDays;
    }

    @Generated
    public @Nullable List<String> getInclude() {
        return this.include;
    }

    @Generated
    public @Nullable List<String> getExclude() {
        return this.exclude;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "AddDependabotCooldown(cooldownDays=" + this.getCooldownDays() + ", semverMajorDays=" + this.getSemverMajorDays() + ", semverMinorDays=" + this.getSemverMinorDays() + ", semverPatchDays=" + this.getSemverPatchDays() + ", include=" + this.getInclude() + ", exclude=" + this.getExclude() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependabotCooldown)) {
            return false;
        }
        AddDependabotCooldown other = (AddDependabotCooldown)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$cooldownDays = this.getCooldownDays();
        Integer other$cooldownDays = other.getCooldownDays();
        if (this$cooldownDays == null ? other$cooldownDays != null : !((Object)this$cooldownDays).equals(other$cooldownDays)) {
            return false;
        }
        Integer this$semverMajorDays = this.getSemverMajorDays();
        Integer other$semverMajorDays = other.getSemverMajorDays();
        if (this$semverMajorDays == null ? other$semverMajorDays != null : !((Object)this$semverMajorDays).equals(other$semverMajorDays)) {
            return false;
        }
        Integer this$semverMinorDays = this.getSemverMinorDays();
        Integer other$semverMinorDays = other.getSemverMinorDays();
        if (this$semverMinorDays == null ? other$semverMinorDays != null : !((Object)this$semverMinorDays).equals(other$semverMinorDays)) {
            return false;
        }
        Integer this$semverPatchDays = this.getSemverPatchDays();
        Integer other$semverPatchDays = other.getSemverPatchDays();
        if (this$semverPatchDays == null ? other$semverPatchDays != null : !((Object)this$semverPatchDays).equals(other$semverPatchDays)) {
            return false;
        }
        List<String> this$include = this.getInclude();
        List<String> other$include = other.getInclude();
        if (this$include == null ? other$include != null : !((Object)this$include).equals(other$include)) {
            return false;
        }
        List<String> this$exclude = this.getExclude();
        List<String> other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddDependabotCooldown;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cooldownDays = this.getCooldownDays();
        result = result * 59 + ($cooldownDays == null ? 43 : ((Object)$cooldownDays).hashCode());
        Integer $semverMajorDays = this.getSemverMajorDays();
        result = result * 59 + ($semverMajorDays == null ? 43 : ((Object)$semverMajorDays).hashCode());
        Integer $semverMinorDays = this.getSemverMinorDays();
        result = result * 59 + ($semverMinorDays == null ? 43 : ((Object)$semverMinorDays).hashCode());
        Integer $semverPatchDays = this.getSemverPatchDays();
        result = result * 59 + ($semverPatchDays == null ? 43 : ((Object)$semverPatchDays).hashCode());
        List<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        List<String> $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

